/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.DebugUIMessages;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.QVTODebugUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.SWTFactory;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpoint;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class QVTOBreakpointPage
extends PropertyPage {
    protected Button fEnabledButton;
    protected Button fHitCountButton;
    protected Text fHitCountText;
    protected Combo fSuspendPolicy;
    protected List<String> fErrorMessages = new ArrayList<String>();
    public static final String ATTR_DELETE_ON_CANCEL = "org.eclipse.m2m.qvt.oml.debug.ui.ATTR_DELETE_ON_CANCEL";
    protected static final String EMPTY_STRING = "";
    private static final String fgHitCountErrorMessage = DebugUIMessages.QVTOBreakpointPage_HitCountErrorMessage;

    public boolean performOk() {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                boolean delOnCancel;
                QVTOBreakpoint breakpoint = QVTOBreakpointPage.this.getBreakpoint();
                boolean bl = delOnCancel = breakpoint.getMarker().getAttribute(QVTOBreakpointPage.ATTR_DELETE_ON_CANCEL) != null;
                if (delOnCancel) {
                    breakpoint.getMarker().setAttribute(QVTOBreakpointPage.ATTR_DELETE_ON_CANCEL, null);
                    breakpoint.setRegistered(true);
                }
                QVTOBreakpointPage.this.doStore();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(wr, null, 0, null);
        }
        catch (CoreException e) {
            QVTODebugUIPlugin.statusDialog(e.getStatus());
            QVTODebugUIPlugin.log(e);
        }
        return super.performOk();
    }

    protected void addErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        this.fErrorMessages.add(message);
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    protected void removeErrorMessage(String message) {
        this.fErrorMessages.remove(message);
        if (this.fErrorMessages.isEmpty()) {
            this.addErrorMessage(null);
        } else {
            this.addErrorMessage(this.fErrorMessages.get(this.fErrorMessages.size() - 1));
        }
    }

    protected void doStore() throws CoreException {
        QVTOBreakpoint breakpoint = this.getBreakpoint();
        this.storeHitCount(breakpoint);
        this.storeEnabled(breakpoint);
    }

    private void storeEnabled(QVTOBreakpoint breakpoint) throws CoreException {
        breakpoint.setEnabled(this.fEnabledButton.getSelection());
    }

    private void storeHitCount(QVTOBreakpoint breakpoint) throws CoreException {
        int hitCount = -1;
        if (this.fHitCountButton.getSelection()) {
            try {
                hitCount = Integer.parseInt(this.fHitCountText.getText());
            }
            catch (NumberFormatException e) {
                QVTODebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.debug.ui", 4, MessageFormat.format("JavaBreakpointPage allowed input of invalid string for hit count value: {0}.", this.fHitCountText.getText()), (Throwable)e));
            }
        }
        breakpoint.setHitCount(hitCount);
    }

    protected Control createContents(Composite parent) {
        this.setTitle(DebugUIMessages.QVTOBreakpointPage_ModulePrepareBreakpoint);
        this.noDefaultAndApplyButton();
        Composite mainComposite = this.createComposite(parent, 1);
        try {
            this.createLabels(mainComposite);
            this.createEnabledButton(mainComposite);
            this.createHitCountEditor(mainComposite);
            this.createTypeSpecificEditors(mainComposite);
        }
        catch (CoreException e) {
            QVTODebugUIPlugin.log(e);
        }
        this.setValid(true);
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getShell().addShellListener(new ShellListener(){

                    public void shellActivated(ShellEvent e) {
                        Shell shell = (Shell)e.getSource();
                        shell.setText(MessageFormat.format(DebugUIMessages.QVTOBreakpointPage_CreateBreakpointForModule, QVTOBreakpointPage.this.getName((IAdaptable)QVTOBreakpointPage.this.getBreakpoint())));
                        shell.removeShellListener((ShellListener)this);
                    }

                    public void shellClosed(ShellEvent e) {
                    }

                    public void shellDeactivated(ShellEvent e) {
                    }

                    public void shellDeiconified(ShellEvent e) {
                    }

                    public void shellIconified(ShellEvent e) {
                    }
                });
            }
        }
        catch (CoreException e) {
            QVTODebugUIPlugin.log(e);
        }
        return mainComposite;
    }

    private String getName(IAdaptable element) {
        IWorkbenchAdapter adapter = (IWorkbenchAdapter)element.getAdapter(IWorkbenchAdapter.class);
        if (adapter != null) {
            return adapter.getLabel((Object)element);
        }
        return EMPTY_STRING;
    }

    protected void createLabels(Composite parent) throws CoreException {
        Composite labelComposite = this.createComposite(parent, 2);
        String typeName = this.getBreakpoint().getUnitURI().toPlatformString(true);
        if (typeName != null) {
            this.createLabel(labelComposite, DebugUIMessages.QVTOBreakpointPage_Module);
            Text text = SWTFactory.createText(labelComposite, 8, 1, typeName);
            text.setBackground(parent.getBackground());
        }
        this.createTypeSpecificLabels(labelComposite);
    }

    private void createHitCountEditor(Composite parent) throws CoreException {
        Composite hitCountComposite = this.createComposite(parent, 2);
        this.fHitCountButton = this.createCheckButton(hitCountComposite, DebugUIMessages.QVTOBreakpointPage_HitCount);
        this.fHitCountButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QVTOBreakpointPage.this.fHitCountText.setEnabled(QVTOBreakpointPage.this.fHitCountButton.getSelection());
                QVTOBreakpointPage.this.hitCountChanged();
            }
        });
        int hitCount = this.getBreakpoint().getHitCount();
        String hitCountString = EMPTY_STRING;
        if (hitCount > 0) {
            hitCountString = new Integer(hitCount).toString();
            this.fHitCountButton.setSelection(true);
        } else {
            this.fHitCountButton.setSelection(false);
        }
        this.fHitCountText = this.createText(hitCountComposite, hitCountString);
        if (hitCount <= 0) {
            this.fHitCountText.setEnabled(false);
        }
        this.fHitCountText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QVTOBreakpointPage.this.hitCountChanged();
            }
        });
    }

    private void hitCountChanged() {
        if (!this.fHitCountButton.getSelection()) {
            this.removeErrorMessage(fgHitCountErrorMessage);
            return;
        }
        String hitCountText = this.fHitCountText.getText();
        int hitCount = -1;
        try {
            hitCount = Integer.parseInt(hitCountText);
        }
        catch (NumberFormatException numberFormatException) {
            this.addErrorMessage(fgHitCountErrorMessage);
            return;
        }
        if (hitCount < 1) {
            this.addErrorMessage(fgHitCountErrorMessage);
        } else {
            this.removeErrorMessage(fgHitCountErrorMessage);
        }
    }

    protected void createEnabledButton(Composite parent) throws CoreException {
        this.fEnabledButton = this.createCheckButton(parent, DebugUIMessages.QVTOBreakpointPage_Enabled);
        this.fEnabledButton.setSelection(this.getBreakpoint().isEnabled());
    }

    protected QVTOBreakpoint getBreakpoint() {
        return (QVTOBreakpoint)this.getElement();
    }

    protected void createTypeSpecificLabels(Composite parent) {
    }

    protected void createTypeSpecificEditors(Composite parent) throws CoreException {
    }

    protected Text createText(Composite parent, String initialValue) {
        return SWTFactory.createText(parent, 2052, 1, initialValue);
    }

    protected Composite createComposite(Composite parent, int numColumns) {
        return SWTFactory.createComposite(parent, parent.getFont(), numColumns, 1, 768, 0, 0);
    }

    protected Button createCheckButton(Composite parent, String text) {
        return SWTFactory.createCheckButton(parent, text, null, false, 1);
    }

    protected Label createLabel(Composite parent, String text) {
        return SWTFactory.createLabel(parent, text, 1);
    }

    protected Button createRadioButton(Composite parent, String text) {
        return SWTFactory.createRadioButton(parent, text, 1);
    }

    public boolean performCancel() {
        try {
            if (this.getBreakpoint().getMarker().getAttribute(ATTR_DELETE_ON_CANCEL) != null) {
                this.getBreakpoint().delete();
            }
        }
        catch (CoreException e) {
            QVTODebugUIPlugin.statusDialog(DebugUIMessages.QVTOBreakpointPage_CancelBreakpointCreationError, e.getStatus());
        }
        return super.performCancel();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }
}

