/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.ui.wizards.project;

import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.m2m.internal.qvt.oml.project.builder.QVTOBuilderConfig;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectCreationOperation;
import org.eclipse.m2m.internal.qvt.oml.ui.wizards.project.NewProjectData;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@RunWith(value=Parameterized.class)
public class NewProjectCreationOperationTest {
    @Parameterized.Parameter(value=0)
    public NewProjectData data;
    IProject project;
    private static NewProjectData simpleProjectData = new NewProjectData();
    private static NewProjectData pluginProjectData = new NewProjectData();
    private static NewProjectData javaProjectData = new NewProjectData();
    NewProjectCreationOperation operation;

    @Parameterized.Parameters
    public static Iterable<NewProjectData> data() {
        return Arrays.asList(simpleProjectData, pluginProjectData, javaProjectData);
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        simpleProjectData.setName("simpleProject");
        simpleProjectData.setCreateJava(false);
        simpleProjectData.setPlugin(false);
        simpleProjectData.setQVTSourceFolderName("simpleTransforms");
        pluginProjectData.setName("pluginProject");
        pluginProjectData.setID("org.eclipse.m2m.tests.qvt.oml.ui.pluginProject");
        pluginProjectData.setProviderName("Plugin Provider");
        pluginProjectData.setVersion("1.0.0.qualifier");
        pluginProjectData.setCreateJava(false);
        pluginProjectData.setPlugin(true);
        pluginProjectData.setQVTSourceFolderName("pluginTransforms");
        IExecutionEnvironment[] executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        IExecutionEnvironment environment = executionEnvironments[executionEnvironments.length - 1];
        javaProjectData.setName("javaProject");
        javaProjectData.setID("org.eclipse.m2m.tests.qvt.oml.uijavaProject");
        javaProjectData.setProviderName("javaProvider");
        javaProjectData.setVersion("1.0.0.qualifier");
        javaProjectData.setCreateJava(true);
        javaProjectData.setPlugin(true);
        javaProjectData.setQVTSourceFolderName("javaTransforms");
        javaProjectData.setDoGenerateClass(true);
        javaProjectData.setfExecutionEnv(environment.getId());
        javaProjectData.setOutFolderName("bin");
        javaProjectData.setSourceFolderName("src");
        javaProjectData.setClassName("Activator");
    }

    @Before
    public void setUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.data.getName());
        this.operation = new NewProjectCreationOperation(this.project, this.data);
    }

    @Test
    public void testExecute() throws Exception {
        this.operation.execute((IProgressMonitor)new NullProgressMonitor());
        Assert.assertTrue((boolean)this.project.exists());
        Assert.assertEquals((Object)this.data.getName(), (Object)this.project.getName());
        Assert.assertTrue((boolean)this.project.hasNature("org.eclipse.m2m.qvt.oml.project.QVTONature"));
        Assert.assertTrue((boolean)this.project.getFolder(this.data.getQVTSourceFolderName()).exists());
        QVTOBuilderConfig config = QVTOBuilderConfig.getConfig((IProject)this.project);
        Assert.assertNotNull((Object)config);
        Assert.assertTrue((boolean)config.getSourceContainer().exists());
        if (this.data.isPlugin()) {
            Assert.assertTrue((boolean)this.project.hasNature("org.eclipse.pde.PluginNature"));
            BundleContext context = FrameworkUtil.getBundle(NewProjectCreationOperation.class).getBundleContext();
            ServiceReference serviceReference = context.getServiceReference(IBundleProjectService.class);
            IBundleProjectService service = (IBundleProjectService)context.getService(serviceReference);
            IBundleProjectDescription description = service.getDescription(this.project);
            Assert.assertEquals((Object)this.data.getID(), (Object)description.getSymbolicName());
            Assert.assertEquals((Object)this.data.getProviderName(), (Object)description.getBundleVendor());
            Assert.assertEquals((Object)this.data.getVersion(), (Object)description.getBundleVersion().toString());
            IPluginModelBase workspaceModel = PluginRegistry.findModel((IProject)this.project);
            Assert.assertNotNull((Object)workspaceModel);
            IExtensions extensions = workspaceModel.getExtensions();
            boolean isSourceContainerExtensionFound = false;
            IPluginExtension[] iPluginExtensionArray = extensions.getExtensions();
            int n = iPluginExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginExtension extension = iPluginExtensionArray[n2];
                if ("org.eclipse.m2m.qvt.oml.runtime.qvtTransformationContainer".equals(extension.getPoint())) {
                    isSourceContainerExtensionFound = true;
                    boolean isSourceContainerElementFound = false;
                    IPluginObject[] iPluginObjectArray = extension.getChildren();
                    int n3 = iPluginObjectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPluginObject child = iPluginObjectArray[n4];
                        if ("sourceContainer".equals(child.getName())) {
                            isSourceContainerElementFound = true;
                            Assert.assertTrue((boolean)(child instanceof IPluginElement));
                            IPluginAttribute attribute = ((IPluginElement)child).getAttribute("path");
                            Assert.assertNotNull((Object)attribute);
                            Assert.assertEquals((Object)this.data.getQVTSourceFolderName(), (Object)attribute.getValue());
                        }
                        ++n4;
                    }
                    Assert.assertTrue((boolean)isSourceContainerElementFound);
                }
                ++n2;
            }
            Assert.assertTrue((boolean)isSourceContainerExtensionFound);
        }
        if (this.data.isCreateJava()) {
            Assert.assertTrue((boolean)this.project.hasNature("org.eclipse.jdt.core.javanature"));
            Assert.assertTrue((boolean)this.project.getFolder(this.data.getSourceFolderName()).exists());
            Assert.assertTrue((boolean)this.project.getFolder(this.data.getOutFolderName()).exists());
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            if (this.data.isDoGenerateClass()) {
                Assert.assertNotNull((Object)javaProject.findType(this.data.getClassName()));
            }
            IPath sourcePath = this.project.getFolder(this.data.getSourceFolderName()).getFullPath();
            Assert.assertNotNull((Object)javaProject.getClasspathEntryFor(sourcePath));
            Assert.assertEquals((Object)this.project.findMember(this.data.getOutFolderName()).getFullPath(), (Object)javaProject.getOutputLocation());
            boolean isExecutionEnvironmentFound = false;
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n5 = 0;
            while (n5 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n5];
                String environmentId = JavaRuntime.getExecutionEnvironmentId((IPath)entry.getPath());
                if (environmentId != null && environmentId.equals(this.data.getfExecutionEnv())) {
                    isExecutionEnvironmentFound = true;
                }
                ++n5;
            }
            Assert.assertTrue((boolean)isExecutionEnvironmentFound);
        }
    }

    @After
    public void tearDown() throws Exception {
        this.project.delete(true, (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((boolean)this.project.exists());
    }
}

