/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.internal.viewer.diagram.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.description.concern.provider.ConcernItemProviderAdapterFactory;
import org.eclipse.sirius.diagram.description.filter.provider.FilterItemProviderAdapterFactory;
import org.eclipse.sirius.ui.tools.api.views.common.item.ItemWrapper;
import org.eclipse.sirius.ui.tools.api.views.common.item.RepresentationDescriptionItem;
import org.eclipse.sirius.ui.tools.api.views.common.item.ViewpointItem;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointsFolderItemImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.audit.provider.AuditItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.provider.DescriptionItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.style.provider.StyleItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.tool.provider.ToolItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.description.validation.provider.ValidationItemProviderAdapterFactory;
import org.eclipse.sirius.viewpoint.provider.ViewpointItemProviderAdapterFactory;

public class DiagramViewerContentProvider
extends AdapterFactoryContentProvider {
    private static final Object[] NO_CHILD = new Object[0];
    private Set<String> _handledViewpoint;

    public DiagramViewerContentProvider(Set<String> handledViewpoint_p) {
        super((AdapterFactory)DiagramViewerContentProvider.createAdapterFactory());
        this._handledViewpoint = handledViewpoint_p;
    }

    protected static ComposedAdapterFactory createAdapterFactory() {
        ArrayList<ComposedAdapterFactory> factories = new ArrayList<ComposedAdapterFactory>();
        factories.add(new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
        DiagramViewerContentProvider.fillItemProviderFactories(factories);
        return new ComposedAdapterFactory(factories);
    }

    protected static void fillItemProviderFactories(List factories) {
        factories.add(new ViewpointItemProviderAdapterFactory());
        factories.add(new DescriptionItemProviderAdapterFactory());
        factories.add(new StyleItemProviderAdapterFactory());
        factories.add(new ToolItemProviderAdapterFactory());
        factories.add(new FilterItemProviderAdapterFactory());
        factories.add(new ValidationItemProviderAdapterFactory());
        factories.add(new AuditItemProviderAdapterFactory());
        factories.add(new ConcernItemProviderAdapterFactory());
        factories.add(new EcoreItemProviderAdapterFactory());
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
    }

    public Object[] getChildren(Object parentElement_p) {
        RepresentationDescription representationDescription;
        RepresentationDescriptionItem representationDescriptionItem;
        Collection representationItems;
        Object[] result = NO_CHILD;
        if (parentElement_p instanceof Session) {
            result = this.getSessionChildren((Session)parentElement_p);
        } else if (parentElement_p instanceof ViewpointItem) {
            ViewpointItem viewpointItem = (ViewpointItem)parentElement_p;
            result = this.handleViewPointItem(parentElement_p, viewpointItem.getChildren());
        } else if (parentElement_p instanceof RepresentationDescriptionItem && !(representationItems = (representationDescriptionItem = (RepresentationDescriptionItem)parentElement_p).getChildren()).isEmpty() && this._handledViewpoint.contains((representationDescription = (RepresentationDescription)representationDescriptionItem.getWrappedObject()).getName())) {
            Iterator it = representationItems.iterator();
            ArrayList<DRepresentation> desc = new ArrayList<DRepresentation>();
            while (it.hasNext()) {
                RepresentationItemImpl item = (RepresentationItemImpl)it.next();
                desc.add(item.getRepresentation());
            }
            result = desc.toArray();
        }
        return result;
    }

    public Object[] getElements(Object inputElement_p) {
        return this.getChildren(inputElement_p);
    }

    public Object getParent(Object element_p) {
        return null;
    }

    private Object[] getSessionChildren(Session session) {
        ViewpointsFolderItemImpl viewpointsFolderItem = new ViewpointsFolderItemImpl(session, (Object)session);
        Collection viewpointItems = viewpointsFolderItem.getChildren();
        Iterator iterator = viewpointItems.iterator();
        while (iterator.hasNext()) {
            ViewpointItem viewpointItem;
            Object item = iterator.next();
            if (!(item instanceof ViewpointItem) || this.getChildren(viewpointItem = (ViewpointItem)item).length > 0) continue;
            iterator.remove();
        }
        return viewpointItems.toArray();
    }

    private Object[] handleViewPointItem(Object element_p, Collection<? extends Object> children_p) {
        ArrayList<Object> result = new ArrayList<Object>(children_p);
        if (element_p instanceof ViewpointItem) {
            ArrayList selectedChildren = new ArrayList(0);
            for (Object e : result) {
                ItemWrapper item = (ItemWrapper)e;
                Collection itemChildren = item.getChildren();
                if (itemChildren.isEmpty() || this.getChildren(e).length <= 0) continue;
                selectedChildren.add(e);
            }
            result = selectedChildren;
        }
        return result.toArray();
    }

    public boolean hasChildren(Object element_p) {
        return this.getChildren(element_p).length > 0;
    }
}

