/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ExplorerElementUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isDestroyed(EObject rootElement_p, List<Notification> notifications_p) {
        try {
            LinkedList<EObject> list = new LinkedList<EObject>();
            list.add(rootElement_p);
            List<EObject> parents = ExplorerElementUtil.getParents(list, rootElement_p);
            block7: for (Notification notification : notifications_p) {
                EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
                if (!(feature instanceof EReference)) continue;
                Object objectToLink = notification.getNewValue();
                Object formerObject = notification.getOldValue();
                switch (notification.getEventType()) {
                    case 1: 
                    case 3: {
                        if (objectToLink != null || formerObject == null || !parents.contains(formerObject)) continue block7;
                        return true;
                    }
                    case 4: {
                        if (!parents.contains(formerObject)) continue block7;
                        return true;
                    }
                    case 6: {
                        Collection children = (Collection)notification.getOldValue();
                        for (EObject child : children) {
                            if (!parents.contains(child)) continue;
                            return true;
                        }
                        continue block7;
                    }
                    default: {
                        return false;
                    }
                }
            }
            return false;
        }
        catch (NoSuchElementException noSuchElementException) {
            return false;
        }
    }

    public static List<EObject> getParents(List<EObject> parents_p, EObject rootElement_p) {
        EObject parent = rootElement_p.eContainer();
        if (parent == null) {
            return parents_p;
        }
        parents_p.add(parent);
        return ExplorerElementUtil.getParents(parents_p, parent);
    }
}

