/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diagram.ide.ui.decoration.provider;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.diagram.DiagramDiff;
import org.eclipse.emf.compare.diagram.ide.ui.EMFCompareDiagramIDEUIMessages;
import org.eclipse.emf.compare.diagram.ide.ui.GMFCompareUIPlugin;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.DiffEdgeDecorator;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.DiffLabelDecorator;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.DiffNodeDecorator;
import org.eclipse.emf.compare.diagram.ide.ui.decoration.provider.SelectedDiffAdapter;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

public class DiffDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    public static final String DIFF = "diff-marker";
    public static final String DIFF_ADDED = "diff-added";
    public static final String DIFF_REMOVED = "diff-removed";
    public static final String DIFF_MOVED = "diff-moved";
    public static final String DIFF_HIDED = "diff-hided";
    public static final String DIFF_SHOWED = "diff-showed";
    public static final String DIFF_MODIFIED = "diff-modified";
    public static final String DIFF_LABEL_MODIFIED = "diff-label-modified";

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateDecoratorsOperation) {
            IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
            return DiffDecoratorProvider.shouldDecorate(decoratorTarget);
        }
        return false;
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        View view = (View)decoratorTarget.getAdapter(View.class);
        if (DiffDecoratorProvider.shouldDecorate(view)) {
            ITextAwareEditPart label = (ITextAwareEditPart)decoratorTarget.getAdapter(ITextAwareEditPart.class);
            if (label != null && DiffDecoratorProvider.isNode(view)) {
                decoratorTarget.installDecorator((Object)DIFF, (IDecorator)new DiffLabelDecorator(decoratorTarget));
            } else if (DiffDecoratorProvider.isEdge(view)) {
                decoratorTarget.installDecorator((Object)DIFF, (IDecorator)new DiffEdgeDecorator(decoratorTarget));
            } else if (DiffDecoratorProvider.isNode(view)) {
                decoratorTarget.installDecorator((Object)DIFF, (IDecorator)new DiffNodeDecorator(decoratorTarget));
            } else {
                String errorMsg = EMFCompareDiagramIDEUIMessages.getString("DiffDecoratorProvider.UnknownView", view);
                Status status = new Status(2, "org.eclipse.emf.compare.diagram.ide.ui", errorMsg);
                GMFCompareUIPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public static boolean shouldDecorate(IDecoratorTarget decoratorTarget) {
        return DiffDecoratorProvider.shouldDecorate((View)decoratorTarget.getAdapter(View.class));
    }

    public static boolean shouldDecorate(View view) {
        return !(view instanceof Diagram) && DiffDecoratorProvider.getRelatedSelectedDifference(view) != null;
    }

    private static boolean isEdge(View view) {
        return view != null && view instanceof Edge && view.eContainer() instanceof Diagram;
    }

    private static boolean isNode(View view) {
        return view != null && view instanceof Node;
    }

    public static DiagramDiff getRelatedSelectedDifference(View view) {
        Notifier notifier;
        SelectedDiffAdapter adapter = DiffDecoratorProvider.getSelectedDiffAdapter(view);
        if (adapter != null && (notifier = adapter.getTarget()) instanceof DiagramDiff) {
            return (DiagramDiff)notifier;
        }
        return null;
    }

    private static SelectedDiffAdapter getSelectedDiffAdapter(View view) {
        for (Adapter adapter : view.eAdapters()) {
            if (!adapter.isAdapterForType(DiagramDiff.class)) continue;
            return (SelectedDiffAdapter)adapter;
        }
        return null;
    }
}

