/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.uml2.internal.postprocessor.extension.profile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.uml2.internal.ProfileApplicationChange;
import org.eclipse.emf.compare.uml2.internal.StereotypeApplicationChange;
import org.eclipse.emf.compare.uml2.internal.UMLCompareFactory;
import org.eclipse.emf.compare.uml2.internal.UMLDiff;
import org.eclipse.emf.compare.uml2.internal.postprocessor.extension.AbstractDiffExtensionFactory;
import org.eclipse.emf.compare.utils.MatchUtil;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.internal.impl.ProfileApplicationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLProfileApplicationChangeFactory
extends AbstractDiffExtensionFactory {
    private static final String UML_VERSIONS = "http://www.eclipse.org/uml2/\\d.0.0/UML";

    @Override
    public Class<? extends UMLDiff> getExtensionKind() {
        return ProfileApplicationChange.class;
    }

    @Override
    protected UMLDiff createExtension() {
        return UMLCompareFactory.eINSTANCE.createProfileApplicationChange();
    }

    @Override
    protected EObject getDiscriminantFromDiff(Diff input) {
        EObject result = null;
        DifferenceKind kind = this.getRelatedExtensionKind(input);
        if (kind == DifferenceKind.ADD || kind == DifferenceKind.DELETE) {
            return ((ReferenceChange)input).getValue();
        }
        if (kind == DifferenceKind.CHANGE) {
            EObject container = MatchUtil.getContainer((Comparison)input.getMatch().getComparison(), (Diff)input);
            return this.getDiscriminantForChanges(container);
        }
        return result;
    }

    private ProfileApplication getDiscriminantForChanges(EObject container) {
        if (container instanceof ProfileApplication) {
            return (ProfileApplication)container;
        }
        if (container instanceof EAnnotation && container.eContainer() instanceof ProfileApplication) {
            return (ProfileApplication)container.eContainer();
        }
        return null;
    }

    @Override
    protected List<EObject> getPotentialChangedValuesFromDiscriminant(EObject discriminant) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (discriminant instanceof ProfileApplicationImpl) {
            result.add((EObject)((ProfileApplicationImpl)discriminant).basicGetAppliedProfile());
            for (EAnnotation annotation : ReferenceUtil.getAsList((EObject)discriminant, (EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS)) {
                result.addAll(ReferenceUtil.getAsList((EObject)annotation, (EStructuralFeature)EcorePackage.Literals.EANNOTATION__REFERENCES));
            }
        }
        return result;
    }

    @Override
    protected boolean isRelatedToAnExtensionAdd(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.ADD) && input.getValue() instanceof ProfileApplication;
    }

    @Override
    protected boolean isRelatedToAnExtensionDelete(ReferenceChange input) {
        return input.getReference().isContainment() && input.getKind().equals((Object)DifferenceKind.DELETE) && input.getValue() instanceof ProfileApplication;
    }

    @Override
    protected boolean isRelatedToAnExtensionChange(ReferenceChange input) {
        boolean ret;
        EReference reference = input.getReference();
        if (reference == UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE) {
            ret = true;
        } else if (reference == EcorePackage.Literals.EANNOTATION__REFERENCES) {
            Comparison comparison = input.getMatch().getComparison();
            EAnnotation container = (EAnnotation)MatchUtil.getContainer((Comparison)comparison, (Diff)input);
            ret = UMLProfileApplicationChangeFactory.isSourceMatchesUMLVersion(container);
        } else if (reference == EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS) {
            EAnnotation eAnnotation = (EAnnotation)input.getValue();
            ret = UMLProfileApplicationChangeFactory.isSourceMatchesUMLVersion(eAnnotation);
        } else {
            ret = false;
        }
        return ret;
    }

    private static boolean isSourceMatchesUMLVersion(EAnnotation container) {
        String source = container.getSource();
        boolean ret = source != null ? source.matches(UML_VERSIONS) : false;
        return ret;
    }

    @Override
    public void fillRequiredDifferences(Comparison comparison, UMLDiff extension) {
        ProfileApplicationChange profileApplicationChange;
        if (extension instanceof ProfileApplicationChange && (profileApplicationChange = (ProfileApplicationChange)extension).getKind() == DifferenceKind.DELETE) {
            for (EObject eObject : this.getStereotypeApplications((ProfileApplication)profileApplicationChange.getDiscriminant())) {
                for (Diff diff : comparison.getDifferences(eObject)) {
                    if (!(diff instanceof StereotypeApplicationChange) || diff.getKind() != DifferenceKind.DELETE) continue;
                    profileApplicationChange.getRequires().add((Object)diff);
                }
            }
        }
    }

    private List<EObject> getStereotypeApplications(ProfileApplication profileApplication) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Package p = profileApplication.getApplyingPackage();
        TreeIterator it = p.eAllContents();
        while (it.hasNext()) {
            EObject elt = (EObject)it.next();
            if (!(elt instanceof Element)) continue;
            for (Stereotype stereotype : ((Element)elt).getAppliedStereotypes()) {
                if (!stereotype.getProfile().equals(profileApplication.getAppliedProfile())) continue;
                EObject stereotypeApplication = ((Element)elt).getStereotypeApplication(stereotype);
                result.add(stereotypeApplication);
            }
        }
        return result;
    }

    @Override
    public Match getParentMatch(Diff input) {
        EObject discriminant = this.getDiscriminantFromDiff(input);
        if (discriminant instanceof ProfileApplication) {
            Package p = ((ProfileApplication)discriminant).getApplyingPackage();
            Match match = input.getMatch().getComparison().getMatch((EObject)p);
            if (match != null) {
                return match;
            }
        }
        return super.getParentMatch(input);
    }
}

