/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.handler;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.domain.impl.EMFCompareEditingDomain;
import org.eclipse.emf.compare.ide.ui.internal.editor.ComparisonScopeEditorInput;
import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IEqualityHelperFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.provider.AdapterFactoryUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCompareHandler
extends AbstractHandler {
    protected static CompareEditorInput createCompareEditorInput(IWorkbenchPart part, AdapterFactory adapterFactory, Notifier left, Notifier right, Notifier origin) {
        ComparisonScopeEditorInput input = null;
        ICompareEditingDomain editingDomain = AbstractCompareHandler.createEMFCompareEditingDomain(part, left, right, origin);
        CompareConfiguration configuration = new CompareConfiguration();
        MatchEObjectEngineFactory eObjectMatchEngineFactory = new MatchEObjectEngineFactory();
        eObjectMatchEngineFactory.setRanking(9);
        IMatchEngine.Factory.Registry matchEngineFactoryRegistry = EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry();
        matchEngineFactoryRegistry.add((IMatchEngine.Factory)eObjectMatchEngineFactory);
        EMFCompare comparator = EMFCompare.builder().setMatchEngineFactoryRegistry(matchEngineFactoryRegistry).setPostProcessorRegistry(EMFCompareRCPPlugin.getDefault().getPostProcessorRegistry()).build();
        IComparisonScope scope = EMFCompare.createDefaultScope((Notifier)left, (Notifier)right, (Notifier)origin);
        input = new ComparisonScopeEditorInput(configuration, editingDomain, adapterFactory, comparator, scope);
        input.setTitle("Compare ('" + AdapterFactoryUtil.getText((AdapterFactory)adapterFactory, (Object)left) + "' - '" + AdapterFactoryUtil.getText((AdapterFactory)adapterFactory, (Object)right) + "')");
        configuration.setContainer((ICompareContainer)input);
        return input;
    }

    private static ICompareEditingDomain createEMFCompareEditingDomain(IWorkbenchPart activePart, Notifier left, Notifier right, Notifier origin) {
        EditingDomain delegatingEditingDomain = AbstractCompareHandler.getDelegatingEditingDomain(activePart, left, right);
        CommandStack delegatingCommandStack = null;
        if (delegatingEditingDomain != null) {
            delegatingCommandStack = delegatingEditingDomain.getCommandStack();
        }
        return EMFCompareEditingDomain.create((Notifier)left, (Notifier)right, (Notifier)origin, (CommandStack)delegatingCommandStack);
    }

    private static EditingDomain getDelegatingEditingDomain(IWorkbenchPart activePart, Notifier left, Notifier right) {
        EditingDomain rightEditingDomain;
        EditingDomain leftEditingDomain;
        EditingDomain delegatingEditingDomain = null;
        if (activePart instanceof IEditingDomainProvider) {
            delegatingEditingDomain = ((IEditingDomainProvider)activePart).getEditingDomain();
        } else if (AdapterFactoryEditingDomain.getEditingDomainFor((Object)left) != null && (leftEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)left)) == (rightEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)right))) {
            delegatingEditingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)left);
        }
        return delegatingEditingDomain;
    }

    private static class MatchEObjectEngine
    extends DefaultMatchEngine {
        public MatchEObjectEngine() {
            super(DefaultMatchEngine.createDefaultEObjectMatcher((UseIdentifiers)UseIdentifiers.NEVER), (IComparisonFactory)new DefaultComparisonFactory((IEqualityHelperFactory)new DefaultEqualityHelperFactory()));
        }

        public MatchEObjectEngine(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
            super(matcher, comparisonFactory);
        }

        protected void match(Comparison comparison, IComparisonScope scope, EObject left, EObject right, EObject origin, Monitor monitor) {
            if (left == null || right == null) {
                throw new IllegalArgumentException();
            }
            Match rootMatch = CompareFactory.eINSTANCE.createMatch();
            rootMatch.setLeft(left);
            rootMatch.setRight(right);
            rootMatch.setOrigin(origin);
            comparison.getMatches().add((Object)rootMatch);
            Iterator leftEObjects = scope.getChildren(left);
            Iterator rightEObjects = scope.getChildren(right);
            Object originEObjects = origin != null ? scope.getChildren(origin) : Iterators.emptyIterator();
            this.getEObjectMatcher().createMatches(comparison, leftEObjects, rightEObjects, (Iterator)originEObjects, monitor);
        }
    }

    private static class MatchEObjectEngineFactory
    extends MatchEngineFactoryImpl {
        public MatchEObjectEngineFactory() {
            this.matchEngine = new MatchEObjectEngine();
        }

        public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
            Notifier left = scope.getLeft();
            Notifier right = scope.getRight();
            return left instanceof EObject && right instanceof EObject;
        }
    }
}

