/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.logical;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.compare.ide.ui.logical.EMFSynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EMFResourceMapping
extends ResourceMapping {
    private IFile file;
    private String providerId;
    private ResourceTraversal[] cachedTraversals;

    public EMFResourceMapping(IFile file, String providerId) {
        Preconditions.checkNotNull((Object)file);
        this.file = file;
        this.providerId = providerId;
    }

    public Object getModelObject() {
        if (this.file.exists()) {
            return ResourceUtil.loadResource((IStorage)this.file, (ResourceSet)new ResourceSetImpl(), Collections.emptyMap());
        }
        return new Object();
    }

    public String getModelProviderId() {
        return this.providerId;
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        if (this.cachedTraversals == null) {
            this.cachedTraversals = this.convertCompareTraversal(this.resolveEMFTraversal(context, monitor));
        }
        return this.cachedTraversals;
    }

    private StorageTraversal resolveEMFTraversal(ResourceMappingContext context, IProgressMonitor monitor) {
        return EMFSynchronizationModel.resolveTraversal((IResource)this.file);
    }

    private ResourceTraversal[] convertCompareTraversal(StorageTraversal traversal) {
        ResourceTraversal converted = (ResourceTraversal)traversal.getAdapter(ResourceTraversal.class);
        return new ResourceTraversal[]{converted};
    }

    public IProject[] getProjects() {
        ResourceTraversal[] traversals;
        LinkedHashSet projects = Sets.newLinkedHashSet();
        if (this.cachedTraversals == null) {
            try {
                traversals = this.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < traversals.length) {
                    IResource[] resources = traversals[i].getResources();
                    int j = 0;
                    while (j < resources.length) {
                        projects.add(resources[j].getProject());
                        ++j;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                projects.add(this.file.getProject());
            }
        } else {
            traversals = this.cachedTraversals;
            int i = 0;
            while (i < traversals.length) {
                IResource[] resources = traversals[i].getResources();
                int j = 0;
                while (j < resources.length) {
                    projects.add(resources[j].getProject());
                    ++j;
                }
                ++i;
            }
        }
        IProject[] projectArray = projects.toArray(new IProject[projects.size()]);
        return projectArray;
    }
}

