/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.merge;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.merge.AbstractMerger;
import org.eclipse.emf.compare.utils.DiffUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAttachmentChangeMerger
extends AbstractMerger {
    @Override
    public boolean isMergerFor(Diff target) {
        return target instanceof ResourceAttachmentChange;
    }

    @Override
    public void copyLeftToRight(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ResourceAttachmentChange diff = (ResourceAttachmentChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null) {
            for (Diff equivalent : diff.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequires(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, false);
                    break;
                }
            }
        } else {
            this.mergeRequiredBy(diff, false, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, false);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, false);
                    break;
                }
            }
        }
    }

    @Override
    public void copyRightToLeft(Diff target, Monitor monitor) {
        if (target.getState() != DifferenceState.UNRESOLVED) {
            return;
        }
        ResourceAttachmentChange diff = (ResourceAttachmentChange)target;
        diff.setState(DifferenceState.MERGED);
        if (diff.getEquivalence() != null) {
            for (Diff equivalent : diff.getEquivalence().getDifferences()) {
                equivalent.setState(DifferenceState.MERGED);
            }
        }
        if (diff.getSource() == DifferenceSource.LEFT) {
            this.mergeRequiredBy(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.removeFromTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.addInTarget(diff, true);
                    break;
                }
            }
        } else {
            this.mergeRequires(diff, true, monitor);
            switch (diff.getKind()) {
                case ADD: {
                    this.addInTarget(diff, true);
                    break;
                }
                case DELETE: {
                    this.removeFromTarget(diff, true);
                    break;
                }
            }
        }
    }

    protected void addInTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        EObject expectedValue;
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        Resource expectedContainer = this.findOrCreateTargetResource(match, rightToLeft);
        EObject sourceValue = rightToLeft ? match.getRight() : match.getLeft();
        if (rightToLeft) {
            if (match.getLeft() != null) {
                expectedValue = match.getLeft();
            } else {
                expectedValue = this.createCopy(sourceValue);
                match.setLeft(expectedValue);
            }
        } else if (match.getRight() != null) {
            expectedValue = match.getRight();
        } else {
            expectedValue = this.createCopy(sourceValue);
            match.setRight(expectedValue);
        }
        URI sourceURI = EcoreUtil.getURI((EObject)sourceValue);
        if (expectedContainer.getEObject(sourceURI.fragment()) != null) {
            ((InternalEObject)expectedValue).eSetProxyURI(sourceURI);
            if (expectedContainer.getResourceSet() != null) {
                EcoreUtil.resolveAll((ResourceSet)expectedContainer.getResourceSet());
            } else {
                EcoreUtil.resolveAll((Resource)expectedContainer);
            }
            if (rightToLeft) {
                match.setLeft(expectedContainer.getEObject(sourceURI.fragment()));
            } else {
                match.setRight(expectedContainer.getEObject(sourceURI.fragment()));
            }
            return;
        }
        Resource initialResource = sourceValue.eResource();
        EList sourceList = initialResource.getContents();
        EList targetList = expectedContainer.getContents();
        int insertionIndex = this.findInsertionIndex(comparison, (List)sourceList, (List)targetList, (Object)expectedValue);
        this.addAt(targetList, expectedValue, insertionIndex);
        if (initialResource instanceof XMIResource && expectedContainer instanceof XMIResource) {
            ((XMIResource)expectedContainer).setID(expectedValue, ((XMIResource)initialResource).getID(sourceValue));
        }
    }

    protected Resource findOrCreateTargetResource(Match match, boolean rightToLeft) {
        Resource target;
        Comparison comparison = match.getComparison();
        Resource sourceRes = rightToLeft ? match.getRight().eResource() : match.getLeft().eResource();
        MatchResource soughtMatch = this.getMatchResource(comparison, sourceRes);
        if (rightToLeft && soughtMatch.getLeft() != null) {
            target = soughtMatch.getLeft();
        } else if (!rightToLeft && soughtMatch.getRight() != null) {
            target = soughtMatch.getRight();
        } else {
            URI targetURI = this.computeTargetURI(match, rightToLeft);
            if (targetURI == null) {
                return null;
            }
            EList<MatchResource> matchedResources = comparison.getMatchedResources();
            int size = matchedResources.size();
            ResourceSet targetSet = null;
            int i = 0;
            while (i < size && targetSet == null) {
                MatchResource matchRes = (MatchResource)matchedResources.get(i);
                if (rightToLeft && matchRes.getLeft() != null) {
                    targetSet = matchRes.getLeft().getResourceSet();
                } else if (!rightToLeft && matchRes.getRight() != null) {
                    targetSet = matchRes.getRight().getResourceSet();
                }
                ++i;
            }
            if (targetSet == null) {
                throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingRS", targetURI.lastSegment()));
            }
            target = targetSet.getURIConverter().exists(targetURI, Collections.emptyMap()) ? targetSet.getResource(targetURI, true) : targetSet.createResource(targetURI);
            if (rightToLeft) {
                soughtMatch.setLeft(target);
            } else {
                soughtMatch.setRight(target);
            }
        }
        return target;
    }

    protected URI computeTargetURI(Match match, boolean rightToLeft) {
        EObject targetObject;
        EObject sourceObject;
        if (rightToLeft) {
            sourceObject = match.getRight();
            targetObject = match.getLeft();
        } else {
            sourceObject = match.getLeft();
            targetObject = match.getRight();
        }
        Resource sourceResource = sourceObject.eResource();
        Resource currentResource = targetObject.eResource();
        MatchResource matchCurrent = this.getMatchResource(match.getComparison(), currentResource);
        Resource currentFromSourceSide = rightToLeft ? matchCurrent.getRight() : matchCurrent.getLeft();
        URI relativeTargetURI = sourceResource.getURI().deresolve(currentFromSourceSide.getURI());
        return relativeTargetURI.resolve(currentResource.getURI());
    }

    protected MatchResource getMatchResource(Comparison comparison, Resource resource) {
        EList<MatchResource> matchedResources = comparison.getMatchedResources();
        int size = matchedResources.size();
        MatchResource soughtMatch = null;
        int i = 0;
        while (i < size && soughtMatch == null) {
            MatchResource matchRes = (MatchResource)matchedResources.get(i);
            if (matchRes.getRight() == resource || matchRes.getLeft() == resource || matchRes.getOrigin() == resource) {
                soughtMatch = matchRes;
            }
            ++i;
        }
        if (soughtMatch == null) {
            throw new RuntimeException(EMFCompareMessages.getString("ResourceAttachmentChangeSpec.MissingMatch", resource.getURI().lastSegment()));
        }
        return soughtMatch;
    }

    protected void removeFromTarget(ResourceAttachmentChange diff, boolean rightToLeft) {
        Match valueMatch = diff.getMatch();
        EObject expectedValue = rightToLeft ? valueMatch.getLeft() : valueMatch.getRight();
        if (expectedValue != null) {
            Resource.Internal resource = ((InternalEObject)expectedValue).eDirectResource();
            resource.getContents().remove((Object)expectedValue);
        }
    }

    protected <E> int findInsertionIndex(Comparison comparison, List<E> source, List<E> target, E newElement) {
        return DiffUtil.findInsertionIndex(comparison, source, target, newElement);
    }
}

