/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructuralFeatureAccessor
implements IStructuralFeatureAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final EStructuralFeature fStructuralFeature;
    private final ImmutableList<Diff> fDifferences;

    public AbstractStructuralFeatureAccessor(Diff diff, IMergeViewer.MergeViewerSide side) {
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
        this.fStructuralFeature = this.getAffectedFeature(diff);
        this.fDifferences = this.computeDifferences();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        IMergeViewerItem ret = null;
        ImmutableList<? extends IMergeViewerItem> items = this.getItems();
        for (IMergeViewerItem item : items) {
            Diff diff = item.getDiff();
            if (diff != this.fDiff) continue;
            ret = item;
        }
        return ret;
    }

    @Override
    public EObject getEObject(IMergeViewer.MergeViewerSide side) {
        EObject eObject;
        switch (side) {
            case ANCESTOR: {
                eObject = this.fOwnerMatch.getOrigin();
                break;
            }
            case LEFT: {
                eObject = this.fOwnerMatch.getLeft();
                break;
            }
            case RIGHT: {
                eObject = this.fOwnerMatch.getRight();
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return eObject;
    }

    @Override
    public EStructuralFeature getStructuralFeature() {
        return this.fStructuralFeature;
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected final ImmutableList<Diff> getDifferences() {
        return this.fDifferences;
    }

    protected ImmutableList<Diff> computeDifferences() {
        EList siblingDifferences = this.fOwnerMatch.getDifferences();
        Predicate diffFilter = Predicates.and((Predicate)EMFComparePredicates.onFeature((String)this.fStructuralFeature.getName()), (Predicate)Predicates.not((Predicate)EMFComparePredicates.hasConflict((ConflictKind[])new ConflictKind[]{ConflictKind.PSEUDO})));
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, (Predicate)diffFilter));
    }

    protected EStructuralFeature getAffectedFeature(Diff diff) {
        Object feature = diff instanceof ReferenceChange ? ((ReferenceChange)diff).getReference() : (diff instanceof AttributeChange ? ((AttributeChange)diff).getAttribute() : null);
        return feature;
    }

    protected final Diff getInitialDiff() {
        return this.fDiff;
    }
}

