/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl.AbstractStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.InsertionPoint;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.impl.MatchedObject;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleStructuralFeatureAccessorImpl
extends AbstractStructuralFeatureAccessor {
    public SingleStructuralFeatureAccessorImpl(Diff diff, IMergeViewer.MergeViewerSide side) {
        super(diff, side);
    }

    @Override
    public ImmutableList<? extends IMergeViewerItem> getItems() {
        ImmutableList ret;
        Object thisSideValue = this.getValue(this.getSide());
        if (thisSideValue == null && this.getSide() == IMergeViewer.MergeViewerSide.ANCESTOR) {
            return ImmutableList.of();
        }
        Object leftValue = this.getValue(IMergeViewer.MergeViewerSide.LEFT);
        Object rightValue = this.getValue(IMergeViewer.MergeViewerSide.RIGHT);
        Object ancestorValue = this.getValue(IMergeViewer.MergeViewerSide.ANCESTOR);
        Diff diff = (Diff)Iterables.getFirst(this.getDifferences(), null);
        if (thisSideValue == null) {
            InsertionPoint insertionPoint = new InsertionPoint(diff, leftValue, rightValue, ancestorValue);
            ret = ImmutableList.of((Object)insertionPoint);
        } else {
            MatchedObject matchedObject = new MatchedObject(diff, leftValue, rightValue, ancestorValue);
            ret = ImmutableList.of((Object)matchedObject);
        }
        return ret;
    }

    private Object getValue(IMergeViewer.MergeViewerSide side) {
        Object value = null;
        EObject eObject = this.getEObject(side);
        if (eObject != null) {
            value = ReferenceUtil.safeEGet((EObject)eObject, (EStructuralFeature)this.getStructuralFeature());
        }
        return value;
    }

    @Override
    public String getName() {
        return SingleStructuralFeatureAccessorImpl.class.getName();
    }

    @Override
    public Image getImage() {
        if (this.getStructuralFeature() instanceof EAttribute) {
            return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EAttribute"));
        }
        return ExtendedImageRegistry.getInstance().getImage(EcoreEditPlugin.getPlugin().getImage("full/obj16/EReference"));
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eDiff";
    }
}

