/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.internal.postprocessor;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.internal.EMFCompareRCPMessages;
import org.eclipse.emf.compare.rcp.internal.postprocessor.PostProcessorDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostProcessorFactoryRegistryListener
extends AbstractRegistryEventListener {
    static final String TAG_PROCESSOR = "processor";
    static final String TAG_NS_URI = "nsURI";
    static final String TAG_RESOURCE_URI = "resourceURI";
    static final String ATT_VALUE = "value";
    static final String ATT_CLASS = "class";
    static final String ATT_ORDINAL = "ordinal";
    private final IPostProcessor.Descriptor.Registry<String> registry;

    public PostProcessorFactoryRegistryListener(String pluginID, String extensionPointID, ILog log, IPostProcessor.Descriptor.Registry<String> registry) {
        super(pluginID, extensionPointID, log);
        this.registry = registry;
    }

    @Override
    protected boolean validateExtensionElement(IConfigurationElement element) {
        boolean valid;
        if (TAG_PROCESSOR.equals(element.getName())) {
            IConfigurationElement[] nsURIChildren = element.getChildren(TAG_NS_URI);
            IConfigurationElement[] resourceURIChildren = element.getChildren(TAG_RESOURCE_URI);
            if (element.getAttribute(ATT_CLASS) == null) {
                this.logMissingAttribute(element, ATT_CLASS);
                valid = false;
            } else if (element.getAttribute(ATT_ORDINAL) == null) {
                this.logMissingAttribute(element, ATT_ORDINAL);
                valid = false;
            } else if (element.getAttribute(ATT_ORDINAL) != null) {
                String ordinalStr = element.getAttribute(ATT_ORDINAL);
                try {
                    Integer.parseInt(ordinalStr);
                }
                catch (NumberFormatException numberFormatException) {
                    this.log(4, element, EMFCompareRCPMessages.getString("malformed.extension.attribute", ATT_ORDINAL));
                    return false;
                }
                valid = true;
            } else if (nsURIChildren.length > 0) {
                if (nsURIChildren[0].getAttribute(ATT_VALUE) == null) {
                    this.logMissingAttribute(nsURIChildren[0], ATT_VALUE);
                    valid = false;
                } else {
                    valid = true;
                }
            } else if (resourceURIChildren.length > 0) {
                if (resourceURIChildren[0].getAttribute(ATT_VALUE) == null) {
                    this.logMissingAttribute(resourceURIChildren[0], ATT_VALUE);
                    valid = false;
                } else {
                    valid = true;
                }
            } else {
                this.log(4, element, "Post processor must have an nsURI or a resource URI");
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }

    @Override
    protected boolean addedValid(IConfigurationElement element) {
        IConfigurationElement[] nsURIChildren = element.getChildren(TAG_NS_URI);
        IConfigurationElement[] resourceURIChildren = element.getChildren(TAG_RESOURCE_URI);
        Pattern nsURI = null;
        if (nsURIChildren.length > 0) {
            nsURI = Pattern.compile(nsURIChildren[0].getAttribute(ATT_VALUE));
        }
        Pattern resourceURI = null;
        if (resourceURIChildren.length > 0) {
            resourceURI = Pattern.compile(resourceURIChildren[0].getAttribute(ATT_VALUE));
        }
        String className = element.getAttribute(ATT_CLASS);
        PostProcessorDescriptor descriptor = new PostProcessorDescriptor(element, nsURI, resourceURI);
        descriptor.setOrdinal(Integer.parseInt(element.getAttribute(ATT_ORDINAL)));
        IPostProcessor.Descriptor previous = this.registry.put((Object)className, (IPostProcessor.Descriptor)descriptor);
        if (previous != null) {
            EMFCompareRCPPlugin.getDefault().log(2, "The post processor factory '" + className + "' is registered twice.");
        }
        return true;
    }

    @Override
    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getAttribute(ATT_CLASS);
        this.registry.remove((Object)className);
        return true;
    }
}

