/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.IStructuralFeatureAccessor;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.accessor.legacy.impl.AbstractTypedElementAdapter;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.IMergeViewer;
import org.eclipse.emf.compare.rcp.ui.internal.mergeviewer.item.IMergeViewerItem;
import org.eclipse.emf.compare.rcp.ui.internal.util.MergeViewerUtil;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStructuralFeatureAccessor
extends AbstractTypedElementAdapter
implements IStructuralFeatureAccessor {
    private final Diff fDiff;
    private final IMergeViewer.MergeViewerSide fSide;
    private final Match fOwnerMatch;
    private final EStructuralFeature fStructuralFeature;
    private final ImmutableList<Diff> fDifferences;

    public AbstractStructuralFeatureAccessor(AdapterFactory adapterFactory, Diff diff, IMergeViewer.MergeViewerSide side) {
        super(adapterFactory);
        this.fDiff = diff;
        this.fSide = side;
        this.fOwnerMatch = diff.getMatch();
        this.fStructuralFeature = this.getAffectedFeature(diff);
        this.fDifferences = this.computeDifferences();
    }

    @Override
    public Comparison getComparison() {
        return this.fOwnerMatch.getComparison();
    }

    @Override
    public IMergeViewerItem getInitialItem() {
        IMergeViewerItem ret = null;
        ImmutableList<? extends IMergeViewerItem> items = this.getItems();
        for (IMergeViewerItem item : items) {
            Diff diff = item.getDiff();
            if (diff != this.fDiff) continue;
            ret = item;
        }
        return ret;
    }

    @Override
    public EObject getEObject(IMergeViewer.MergeViewerSide side) {
        return MergeViewerUtil.getEObject(this.fOwnerMatch, side);
    }

    @Override
    public EStructuralFeature getStructuralFeature() {
        return this.fStructuralFeature;
    }

    protected final IMergeViewer.MergeViewerSide getSide() {
        return this.fSide;
    }

    protected final ImmutableList<Diff> getDifferences() {
        return this.fDifferences;
    }

    protected ImmutableList<Diff> computeDifferences() {
        EList siblingDifferences = this.fOwnerMatch.getDifferences();
        return ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)siblingDifferences, (Predicate)EMFComparePredicates.onFeature((String)this.fStructuralFeature.getName())));
    }

    protected EStructuralFeature getAffectedFeature(Diff diff) {
        return MergeViewerUtil.getAffectedFeature(diff);
    }

    protected final Diff getInitialDiff() {
        return this.fDiff;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public Image getImage() {
        return ExtendedImageRegistry.INSTANCE.getImage(this.getItemDelegator().getImage((Object)this.fStructuralFeature));
    }

    @Override
    public String getType() {
        return "org.eclipse.emf.compare.rcp.ui.eListDiff";
    }
}

