/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceGroupRegistryImpl
implements IDifferenceGroupProvider.Registry {
    private final Map<String, IDifferenceGroupProvider> map = new ConcurrentHashMap<String, IDifferenceGroupProvider>();

    public List<IDifferenceGroupProvider> getGroupProviders(IComparisonScope scope, Comparison comparison) {
        Iterable providers = Iterables.filter(this.map.values(), DifferenceGroupRegistryImpl.isGroupProviderActivable(scope, comparison));
        return ImmutableList.copyOf((Iterable)providers);
    }

    static final Predicate<IDifferenceGroupProvider> isGroupProviderActivable(final IComparisonScope scope, final Comparison comparison) {
        return new Predicate<IDifferenceGroupProvider>(){

            public boolean apply(IDifferenceGroupProvider d) {
                return d.isEnabled(scope, comparison);
            }
        };
    }

    @Override
    public IDifferenceGroupProvider add(IDifferenceGroupProvider provider) {
        Preconditions.checkNotNull((Object)provider);
        return this.map.put(provider.getClass().getName(), provider);
    }

    @Override
    public IDifferenceGroupProvider remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

