/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.internal.EMFCompareEditMessages;
import org.eclipse.emf.compare.provider.ConflictItemProvider;
import org.eclipse.emf.compare.provider.IItemDescriptionProvider;
import org.eclipse.emf.compare.provider.IItemStyledLabelProvider;
import org.eclipse.emf.compare.provider.utils.ComposedStyledString;
import org.eclipse.emf.compare.provider.utils.IStyledString;
import org.eclipse.emf.compare.utils.EMFComparePredicates;

public class ConflictItemProviderSpec
extends ConflictItemProvider
implements IItemStyledLabelProvider,
IItemDescriptionProvider {
    public ConflictItemProviderSpec(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        return this.getStyledText(object).getString();
    }

    public Object getImage(Object object) {
        if (((Conflict)object).getKind() == ConflictKind.PSEUDO) {
            return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/PseudoConflict"));
        }
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Conflict"));
    }

    public IStyledString.IComposedStyledString getStyledText(Object object) {
        Conflict conflict = (Conflict)object;
        ComposedStyledString ret = new ComposedStyledString();
        if (Iterables.any((Iterable)conflict.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED}))) {
            ret.append("> ", IStyledString.Style.DECORATIONS_STYLER);
        }
        if (conflict.getKind() == ConflictKind.PSEUDO) {
            ret.append(EMFCompareEditMessages.getString("pseudoconflict"));
        } else {
            ret.append(EMFCompareEditMessages.getString("conflict"));
        }
        return ret;
    }

    public String getDescription(Object object) {
        Conflict conflict = (Conflict)object;
        int size = conflict.getDifferences().size() - 1;
        String ret = String.valueOf(conflict.getKind().getName()) + " conflict with " + size + " other difference";
        if (size > 1) {
            ret = String.valueOf(ret) + "s";
        }
        return ret;
    }
}

