/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider.spec;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.internal.merge.IDiffMergeData;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedImage;

public class OverlayImageProvider {
    private static final String MERGED_TO_RIGHT_OV = "merged_right_ov";
    private static final String MERGED_TO_LEFT_OV = "merged_left_ov";
    private static final String REJECTED_OV = "removed_ov";
    private static final String ACCEPTED_OV = "merged_ov";
    private final ResourceLocator fResourceLocator;

    public OverlayImageProvider(ResourceLocator resourceLocator) {
        this.fResourceLocator = resourceLocator;
    }

    public Object getComposedImage(Diff diff, Object imageToCompose) {
        String overlay = this.getImageOverlay(diff);
        return this.getComposedImage(imageToCompose, overlay);
    }

    public Object getComposedImage(Match match, Object imageToCompose) {
        String overlay = this.getImageOverlay(match);
        return this.getComposedImage(imageToCompose, overlay);
    }

    private Object getComposedImage(Object imageToCompose, String overlayPath) {
        ArrayList images = Lists.newArrayList();
        images.add(imageToCompose);
        if (overlayPath != null) {
            Object image = this.fResourceLocator.getImage(overlayPath);
            images.add(image);
        }
        return new ComposedImageExtension(images);
    }

    private String getImageOverlay(Diff diff) {
        Match match = diff.getMatch();
        Comparison comparison = match.getComparison();
        String path = "full/ovr16/";
        if (diff.getState() == DifferenceState.MERGED) {
            path = String.valueOf(path) + this.getMergedOverlay(diff);
        } else if (diff.getState() == DifferenceState.DISCARDED) {
            path = String.valueOf(path) + REJECTED_OV;
        } else if (comparison.isThreeWay()) {
            path = String.valueOf(path) + this.getThreeWayOverlay(diff);
        } else {
            DifferenceKind diffKind = diff.getKind();
            switch (diffKind) {
                case ADD: {
                    path = String.valueOf(path) + "add_ov";
                    break;
                }
                case DELETE: {
                    path = String.valueOf(path) + "del_ov";
                    break;
                }
                case CHANGE: 
                case MOVE: {
                    path = String.valueOf(path) + "chg_ov";
                    break;
                }
            }
        }
        return path;
    }

    private String getThreeWayOverlay(Diff diff) {
        Conflict conflict = diff.getConflict();
        DifferenceKind diffKind = diff.getKind();
        DifferenceSource source = diff.getSource();
        String path = "";
        if (conflict != null) {
            if (conflict.getKind() == ConflictKind.PSEUDO) {
                path = String.valueOf(path) + "p";
            }
            path = String.valueOf(path) + "conf";
            if (source == DifferenceSource.RIGHT) {
                path = String.valueOf(path) + "r_";
            }
        } else {
            switch (source) {
                case LEFT: {
                    path = String.valueOf(path) + "r_out";
                    break;
                }
                case RIGHT: {
                    path = String.valueOf(path) + "r_in";
                    break;
                }
            }
        }
        switch (diffKind) {
            case ADD: {
                path = String.valueOf(path) + "add_ov";
                break;
            }
            case DELETE: {
                path = String.valueOf(path) + "del_ov";
                break;
            }
            case CHANGE: 
            case MOVE: {
                path = String.valueOf(path) + "chg_ov";
                break;
            }
        }
        return path;
    }

    private String getMergedOverlay(Diff diff) {
        IDiffMergeData mergeData;
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)diff, IDiffMergeData.class);
        String path = adapter != null ? (!(mergeData = (IDiffMergeData)adapter).isLeftEditable() || !mergeData.isRightEditable() ? (mergeData.mergedTo() == diff.getSource() ? REJECTED_OV : ACCEPTED_OV) : (mergeData.isLeftEditable() && mergeData.isRightEditable() ? (mergeData.hasBeenMergedToLeft() ? MERGED_TO_LEFT_OV : MERGED_TO_RIGHT_OV) : ACCEPTED_OV)) : ACCEPTED_OV;
        return path;
    }

    private String getImageOverlay(Match match) {
        return "full/ovr16/match_ov";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ComposedImageExtension
    extends ComposedImage {
        private static final int X_OFFSET = 10;

        ComposedImageExtension(Collection<?> images) {
            super(images);
        }

        public List<ComposedImage.Point> getDrawPoints(ComposedImage.Size size) {
            List result = super.getDrawPoints(size);
            if (result.size() > 1) {
                ((ComposedImage.Point)result.get((int)1)).x = 10;
                ((ComposedImage.Point)result.get((int)1)).y = 2;
            }
            return result;
        }

        public ComposedImage.Size getSize(Collection<? extends ComposedImage.Size> sizes) {
            this.imageSizes = Lists.newArrayList(sizes);
            List<ComposedImage.Point> drawPoints = this.getDrawPoints(null);
            ComposedImage.Size result = new ComposedImage.Size();
            int i = 0;
            while (i < sizes.size()) {
                ComposedImage.Size size = (ComposedImage.Size)this.imageSizes.get(i);
                ComposedImage.Point point = drawPoints.get(i);
                result.width = Math.max(result.width, size.width + Math.abs(point.x));
                result.height = Math.max(result.height, size.height + Math.abs(point.y));
                ++i;
            }
            return result;
        }
    }
}

