/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.IModelResolverRegistry;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;

public final class ModelResolverRegistryImpl
implements IModelResolverRegistry {
    private final Map<String, IModelResolver> resolvers = new ConcurrentHashMap<String, IModelResolver>();

    public IModelResolver getBestResolverFor(IStorage sourceStorage) {
        IModelResolver resolver = null;
        for (IModelResolver candidate : this.resolvers.values()) {
            if (!candidate.canResolve(sourceStorage) || ModelResolverRegistryImpl.ranking(resolver) >= ModelResolverRegistryImpl.ranking(candidate)) continue;
            resolver = candidate;
        }
        return resolver;
    }

    private static final int ranking(IModelResolver resolver) {
        if (resolver == null) {
            return -1;
        }
        return resolver.getRanking();
    }

    public void addResolver(String key, IModelResolver resolver) {
        this.resolvers.put((String)Preconditions.checkNotNull((Object)key), (IModelResolver)Preconditions.checkNotNull((Object)resolver));
    }

    public IModelResolver removeResolver(String key) {
        return this.resolvers.remove(key);
    }

    public void clear() {
        this.resolvers.clear();
    }
}

