/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareViewerPane;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.INavigatable;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.ui.internal.actions.collapse.CollapseAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.actions.expand.ExpandAllModelAction;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.CompareInputComparer;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerContentProvider;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewerLabelProvider;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.FilterActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.actions.GroupActionMenu;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilterSelectionChangeEvent;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.StructureMergeViewerFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.StructureMergeViewerGrouper;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.groups.impl.DefaultGroupProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFCompareDiffTreeViewer
extends DiffTreeViewer {
    public static final String REQUIRED_DIFF_COLOR = "RequiredDiffColor";
    public static final String REQUIRED_DIFF_BORDER_COLOR = "RequiredDiffBorderColor";
    public static final String UNMERGEABLE_DIFF_COLOR = "UnmergeableDiffColor";
    public static final String UNMERGEABLE_DIFF_BORDER_COLOR = "UnmergeableDiffBorderColor";
    private final Color requiredDiffColor;
    private final Color unmergeableDiffColor;
    private final ISelectionChangedListener fSelectionChangedListener;
    private final CompareViewerSwitchingPane fParent;
    private ToolBarManager toolbarManager;
    private Object fRoot;
    private StructureMergeViewerFilter structureMergeViewerFilter;
    private StructureMergeViewerGrouper structureMergeViewerGrouper;
    private MenuManager groupsMenuManager;
    private MenuManager filtersMenuManager;
    private GroupActionMenu groupActionMenu;
    private FilterActionMenu filterActionMenu;
    private EventBus eventBus;
    private Listener fEraseItemListener;
    private AdapterFactory adapterFactory;
    private static Predicate<EObject> IS_DIFF_TREE_NODE = new Predicate<EObject>(){

        public boolean apply(EObject t) {
            return t instanceof TreeNode && ((TreeNode)t).getData() instanceof Diff;
        }
    };

    public EMFCompareDiffTreeViewer(Composite parent, final AdapterFactory adapterFactory, CompareConfiguration configuration) {
        super(parent, configuration);
        this.adapterFactory = adapterFactory;
        ToolBarManager tbm = CompareViewerPane.getToolBarManager((Composite)parent.getParent());
        if (tbm != null) {
            tbm.removeAll();
            tbm.add((IContributionItem)new Separator("merge"));
            tbm.add((IContributionItem)new Separator("modes"));
            tbm.add((IContributionItem)new Separator("navigation"));
            this.createToolItems(tbm);
            tbm.update(true);
        }
        this.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new EMFCompareStructureMergeViewerLabelProvider(adapterFactory, (Viewer)this)));
        this.setContentProvider((IContentProvider)new EMFCompareStructureMergeViewerContentProvider(adapterFactory));
        this.fParent = parent.getParent() instanceof CompareViewerSwitchingPane ? (CompareViewerSwitchingPane)parent.getParent() : null;
        this.fSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EMFCompareDiffTreeViewer.this.getControl().redraw();
                EMFCompareDiffTreeViewer.this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SMV_SELECTION", (Object)event.getSelection());
                if (EMFCompareDiffTreeViewer.this.toolbarManager != null) {
                    IContributionItem[] iContributionItemArray = EMFCompareDiffTreeViewer.this.toolbarManager.getItems();
                    int n = iContributionItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        item.update();
                        ++n2;
                    }
                }
            }
        };
        this.addSelectionChangedListener(this.fSelectionChangedListener);
        this.fEraseItemListener = new Listener(){

            public void handleEvent(Event event) {
                EMFCompareDiffTreeViewer.this.handleEraseItemEvent(event);
            }
        };
        this.getControl().addListener(40, this.fEraseItemListener);
        this.setComparer(new CompareInputComparer(super.getComparer()));
        if (this.eventBus == null) {
            this.eventBus = new EventBus();
            this.eventBus.register((Object)this);
        }
        JFaceResources.getColorRegistry().put(REQUIRED_DIFF_COLOR, new RGB(215, 255, 200));
        JFaceResources.getColorRegistry().put(REQUIRED_DIFF_BORDER_COLOR, new RGB(195, 235, 180));
        JFaceResources.getColorRegistry().put(UNMERGEABLE_DIFF_COLOR, new RGB(255, 205, 180));
        JFaceResources.getColorRegistry().put(UNMERGEABLE_DIFF_BORDER_COLOR, new RGB(235, 185, 160));
        this.requiredDiffColor = JFaceResources.getColorRegistry().get(REQUIRED_DIFF_COLOR);
        this.unmergeableDiffColor = JFaceResources.getColorRegistry().get(UNMERGEABLE_DIFF_COLOR);
        INavigatable nav = new INavigatable(){

            public boolean selectChange(int flag) {
                Notifier target;
                Object firstElement;
                ISelection selection = EMFCompareDiffTreeViewer.this.getSelection();
                TreeNode nextOrPrev = null;
                if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof Adapter && (target = ((Adapter)firstElement).getTarget()) instanceof TreeNode) {
                    TreeNode treeNode = (TreeNode)target;
                    if (flag == 1) {
                        nextOrPrev = EMFCompareDiffTreeViewer.this.getNextDiffNode(treeNode);
                    } else if (flag == 2) {
                        nextOrPrev = EMFCompareDiffTreeViewer.this.getPrevDiffNode(treeNode);
                    } else if (flag == 3 || flag == 4) {
                        return true;
                    }
                    if (nextOrPrev != null) {
                        StructuredSelection newSelection = new StructuredSelection((Object)adapterFactory.adapt((Notifier)nextOrPrev, ICompareInput.class));
                        EMFCompareDiffTreeViewer.this.setSelection((ISelection)newSelection);
                        EMFCompareDiffTreeViewer.this.fireOpen(new OpenEvent((Viewer)EMFCompareDiffTreeViewer.this, (ISelection)newSelection));
                    }
                }
                return nextOrPrev == null;
            }

            public Object getInput() {
                return EMFCompareDiffTreeViewer.this.getInput();
            }

            public boolean openSelectedChange() {
                return true;
            }

            public boolean hasChange(int changeFlag) {
                return changeFlag == 1 || changeFlag == 2;
            }
        };
        this.getTree().setData("org.eclipse.compare.internal.Navigator", (Object)nav);
    }

    private TreeNode getPrevDiffNode(TreeNode treeNode) {
        TreeNode previousNode = null;
        TreeNode parentNode = treeNode.getParent();
        if (parentNode != null) {
            ImmutableList children = this.getSortedTreeNodeChildren(this.adapterFactory.adapt((Notifier)parentNode, ICompareInput.class)).reverse();
            int indexOfTreeNode = children.indexOf(treeNode);
            if (indexOfTreeNode == children.size() - 1) {
                previousNode = IS_DIFF_TREE_NODE.apply((Object)parentNode) ? parentNode : this.getPrevDiffNode(parentNode);
            } else {
                boolean stop = false;
                while (!stop) {
                    if (children.size() > indexOfTreeNode + 1) {
                        TreeNode prevSibling = (TreeNode)children.get(indexOfTreeNode + 1);
                        previousNode = this.getLastChildDiffNode(prevSibling);
                        if (previousNode != null) {
                            stop = true;
                        } else if (IS_DIFF_TREE_NODE.apply((Object)prevSibling)) {
                            previousNode = prevSibling;
                            stop = true;
                        }
                        ++indexOfTreeNode;
                        continue;
                    }
                    previousNode = this.getPrevDiffNode(parentNode);
                    stop = true;
                }
            }
        }
        return previousNode;
    }

    private TreeNode getNextDiffNode(TreeNode treeNode) {
        TreeNode next = this.getFirstChildDiffNode(treeNode);
        if (next == null) {
            TreeNode currentNode = treeNode;
            boolean stop = false;
            while (!stop && currentNode != null) {
                next = this.getNextSiblingDiffNode(currentNode);
                if (next == null) {
                    currentNode = currentNode.getParent();
                    continue;
                }
                stop = true;
            }
        }
        return next;
    }

    private TreeNode getNextSiblingDiffNode(TreeNode treeNode) {
        TreeNode next = null;
        TreeNode parent = treeNode.getParent();
        if (parent != null) {
            ImmutableList<TreeNode> children = this.getSortedTreeNodeChildren(this.adapterFactory.adapt((Notifier)parent, ICompareInput.class));
            int indexOfTreeNode = children.indexOf(treeNode);
            boolean stop = false;
            while (!stop) {
                if (children.size() > indexOfTreeNode + 1) {
                    TreeNode nextSibling = (TreeNode)children.get(indexOfTreeNode + 1);
                    next = IS_DIFF_TREE_NODE.apply((Object)nextSibling) ? nextSibling : this.getFirstChildDiffNode(nextSibling);
                    if (next != null) {
                        stop = true;
                    }
                    ++indexOfTreeNode;
                    continue;
                }
                stop = true;
            }
        }
        return next;
    }

    private TreeNode getFirstChildDiffNode(TreeNode treeNode) {
        UnmodifiableIterator diffChildren = Iterators.filter((Iterator)treeNode.eAllContents(), IS_DIFF_TREE_NODE);
        while (diffChildren.hasNext()) {
            TreeNode next = (TreeNode)diffChildren.next();
            if (this.isFiltered(this.adapterFactory.adapt((Notifier)next, ICompareInput.class), this.adapterFactory.adapt((Notifier)next.getParent(), ICompareInput.class), this.getFilters())) continue;
            return next;
        }
        return null;
    }

    private TreeNode getLastChildDiffNode(TreeNode treeNode) {
        UnmodifiableIterator diffChildren = Iterators.filter((Iterator)treeNode.eAllContents(), IS_DIFF_TREE_NODE);
        ArrayList l = Lists.newArrayList((Iterator)diffChildren);
        ListIterator li = l.listIterator(l.size());
        while (li.hasPrevious()) {
            TreeNode prev = (TreeNode)li.previous();
            if (this.isFiltered(this.adapterFactory.adapt((Notifier)prev, ICompareInput.class), this.adapterFactory.adapt((Notifier)prev.getParent(), ICompareInput.class), this.getFilters())) continue;
            return prev;
        }
        return null;
    }

    private ImmutableList<TreeNode> getSortedTreeNodeChildren(Adapter treeNodeAdapter) {
        Object[] sortedChildren;
        ArrayList treeNodeChildren = Lists.newArrayList();
        Object[] objectArray = sortedChildren = this.getSortedChildren(treeNodeAdapter);
        int n = sortedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Notifier target;
            Object object = objectArray[n2];
            if (object instanceof Adapter && (target = ((Adapter)object).getTarget()) instanceof TreeNode) {
                treeNodeChildren.add((TreeNode)target);
            }
            ++n2;
        }
        return ImmutableList.copyOf((Collection)treeNodeChildren);
    }

    public ViewerComparator getComparator() {
        return null;
    }

    @Subscribe
    public void recordFilterSelectionChange(IDifferenceFilterSelectionChangeEvent event) {
        Object property = this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS");
        HashSet<Object> selectedFilters = property == null ? new HashSet<IDifferenceFilter>() : new HashSet((Collection)property);
        switch (event.getAction()) {
            case ACTIVATE: {
                selectedFilters.add(event.getFilter());
                break;
            }
            case DEACTIVATE: {
                selectedFilters.remove(event.getFilter());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS", selectedFilters);
    }

    @Subscribe
    public void recordGroupProviderSelectionChange(IDifferenceGroupProvider differenceGroupProvider) {
        EList eAdapters = ((Adapter)this.fRoot).getTarget().eAdapters();
        IDifferenceGroupProvider oldDifferenceGroupProvider = (IDifferenceGroupProvider)EcoreUtil.getAdapter((List)eAdapters, IDifferenceGroupProvider.class);
        if (oldDifferenceGroupProvider != null) {
            eAdapters.remove((Object)oldDifferenceGroupProvider);
        }
        eAdapters.add((Object)differenceGroupProvider);
        this.getCompareConfiguration().setProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_GROUP", (Object)differenceGroupProvider);
    }

    public void configurationPropertyChanged() {
        this.getControl().redraw();
        if (this.toolbarManager != null) {
            IContributionItem[] iContributionItemArray = this.toolbarManager.getItems();
            int n = iContributionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                item.update();
                ++n2;
            }
        }
    }

    public Object getRoot() {
        return this.fRoot;
    }

    public void setRoot(Object root) {
        this.fRoot = root;
    }

    public void createChildrenSilently(Object o) {
        block3: {
            block2: {
                if (!(o instanceof Tree)) break block2;
                this.createChildren((Widget)o);
                TreeItem[] treeItemArray = ((Tree)o).getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    this.createChildrenSilently(item);
                    ++n2;
                }
                break block3;
            }
            if (!(o instanceof TreeItem)) break block3;
            this.createChildren((Widget)o);
            TreeItem[] treeItemArray = ((TreeItem)o).getItems();
            int n = treeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem item = treeItemArray[n3];
                this.createChildrenSilently(item);
                ++n3;
            }
        }
    }

    public void initialSelection() {
        super.initialSelection();
    }

    public boolean isExpandable(Object parent) {
        if (this.hasFilters()) {
            return this.hasFilteredChildren(parent);
        }
        return super.isExpandable(parent);
    }

    public final boolean hasFilteredChildren(Object parent) {
        Object[] rawChildren = this.getRawChildren(parent);
        return this.containsNonFiltered(rawChildren, parent);
    }

    private boolean containsNonFiltered(Object[] elements, Object parent) {
        if (elements.length == 0) {
            return false;
        }
        if (!this.hasFilters()) {
            return true;
        }
        ViewerFilter[] filters = this.getFilters();
        int i = 0;
        while (i < elements.length) {
            Object object = elements[i];
            if (!this.isFiltered(object, parent, filters)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isFiltered(Object object, Object parent, ViewerFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ViewerFilter filter = filters[i];
            if (!filter.select((Viewer)this, parent, object)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void refreshAfterDiff(Object root) {
        if (this.getControl().isDisposed()) {
            return;
        }
        if (this.fParent != null) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
            int displayedDiff = this.getMatchCount(contentProvider, contentProvider.getElements(this.getRoot()));
            Comparison comparison = (Comparison)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
            int computedDiff = comparison.getDifferences().size();
            int filteredDiff = computedDiff - displayedDiff;
            this.fParent.setTitleArgument(String.valueOf(computedDiff) + " differences \u2013 " + filteredDiff + " differences filtered from view");
        }
        this.refresh(root);
    }

    private int getMatchCount(ITreeContentProvider cp, Object[] elements) {
        HashSet diffs = Sets.newHashSet();
        this.getMatchCount(cp, elements, diffs);
        return diffs.size();
    }

    private void getMatchCount(ITreeContentProvider cp, Object[] elements, Set<Diff> diffs) {
        ViewerFilter[] filters = this.getFilters();
        int j = 0;
        while (j < elements.length) {
            TreeNode treeNode;
            EObject data;
            Notifier target;
            Object element = elements[j];
            if (!this.isFiltered(element, null, filters) && element instanceof Adapter && (target = ((Adapter)element).getTarget()) instanceof TreeNode && (data = (treeNode = (TreeNode)target).getData()) instanceof Diff) {
                diffs.add((Diff)data);
            }
            Object[] children = cp.getChildren(element);
            this.getMatchCount(cp, children, diffs);
            ++j;
        }
    }

    public void setComparer(IElementComparer comparer) {
        super.setComparer((IElementComparer)new CompareInputComparer(comparer));
    }

    protected void createToolItems(ToolBarManager toolbarManager) {
        this.toolbarManager = toolbarManager;
        super.createToolItems(toolbarManager);
        IWorkbench workbench = PlatformUI.getWorkbench();
        IMenuService menuService = (IMenuService)workbench.getService(IMenuService.class);
        if (menuService != null) {
            menuService.populateContributionManager((ContributionManager)toolbarManager, "toolbar:org.eclipse.emf.compare.structuremergeviewer.toolbar");
        }
        Bundle uiWorkbenchBundle = Platform.getBundle((String)"org.eclipse.ui.workbench");
        Version junoStart = Version.parseVersion((String)"3.103");
        Version keplerStart = Version.parseVersion((String)"3.105");
        if (uiWorkbenchBundle != null && uiWorkbenchBundle.getVersion().compareTo(junoStart) >= 0 && uiWorkbenchBundle.getVersion().compareTo(keplerStart) < 0) {
            this.addActionsForJuno(toolbarManager);
        }
        this.groupActionMenu = new GroupActionMenu(this.getStructureMergeViewerGrouper(), this.getGroupsMenuManager(), this.getDefaultGroupProvider());
        this.filterActionMenu = new FilterActionMenu(this.getStructureMergeViewerFilter(), this.getFiltersMenuManager());
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)new ExpandAllModelAction((AbstractTreeViewer)this));
        toolbarManager.add((IAction)new CollapseAllModelAction((AbstractTreeViewer)this));
        toolbarManager.add((IContributionItem)new Separator());
        toolbarManager.add((IAction)this.groupActionMenu);
        toolbarManager.add((IAction)this.filterActionMenu);
    }

    public void addActionsForJuno(ToolBarManager toolbarManager) {
        boolean bothSidesEditable = this.getCompareConfiguration().isLeftEditable() && this.getCompareConfiguration().isRightEditable();
        this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.dropdown", "Select the way of merge", "icons/full/toolb16/left_to_right.gif", true);
        toolbarManager.add((IContributionItem)new Separator());
        if (bothSidesEditable) {
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.mergedToRight", "Copy Current Change From Left To Right", "icons/full/toolb16/merge_to_right.gif", true);
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.mergedAllToRight", "Copy All Non-Conflicting Changes From Left To Right", "icons/full/toolb16/merge_all_to_right.gif", true);
            toolbarManager.add((IContributionItem)new Separator());
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.mergedToLeft", "Copy Current Change From Right To Left", "icons/full/toolb16/merge_to_left.gif", true);
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.mergedAllToLeft", "Copy All Non-Conflicting Changes From Right To Left", "icons/full/toolb16/merge_all_to_left.gif", true);
        } else {
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.acceptChange", "Accept Change", "icons/full/toolb16/accept_change.gif", true);
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.acceptAllChanges", "Accept All Non-Conflicting Changes", "icons/full/toolb16/accept_all_changes.gif", true);
            toolbarManager.add((IContributionItem)new Separator());
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.rejectChange", "Reject Change", "icons/full/toolb16/reject_change.gif", true);
            this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.rejectAllChanges", "Reject All Non-Conflicting Changes", "icons/full/toolb16/reject_all_changes.gif", true);
        }
        toolbarManager.add((IContributionItem)new Separator());
        this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.nextDiff", "Next Difference", "icons/full/toolb16/next_diff.gif", true);
        this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.previousDiff", "Previous Difference", "icons/full/toolb16/prev_diff.gif", true);
        toolbarManager.add((IContributionItem)new Separator());
        this.addSMVAction(toolbarManager, "org.eclipse.emf.compare.ide.ui.saveComparisonModel", "Save Comparison Model", "icons/full/toolb16/saveas_edit.gif", true);
    }

    private void addSMVAction(ToolBarManager tb, String actionId, String tooltip, String imagePath, boolean activated) {
        CommandAction action = new CommandAction((IServiceLocator)PlatformUI.getWorkbench(), actionId);
        action.setToolTipText(tooltip);
        action.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.emf.compare.ide.ui", (String)imagePath));
        action.setEnabled(activated);
        tb.add((IAction)action);
    }

    protected StructureMergeViewerFilter getStructureMergeViewerFilter() {
        if (this.structureMergeViewerFilter == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerFilter = new StructureMergeViewerFilter(this.eventBus);
            this.structureMergeViewerFilter.install((TreeViewer)this);
        }
        return this.structureMergeViewerFilter;
    }

    protected StructureMergeViewerGrouper getStructureMergeViewerGrouper() {
        if (this.structureMergeViewerGrouper == null) {
            if (this.eventBus == null) {
                this.eventBus = new EventBus();
                this.eventBus.register((Object)this);
            }
            this.structureMergeViewerGrouper = new StructureMergeViewerGrouper(this.eventBus);
            this.structureMergeViewerGrouper.install((TreeViewer)this);
        }
        return this.structureMergeViewerGrouper;
    }

    public MenuManager getGroupsMenuManager() {
        if (this.groupsMenuManager == null) {
            this.groupsMenuManager = new MenuManager();
        }
        return this.groupsMenuManager;
    }

    public GroupActionMenu getGroupActionMenu() {
        return this.groupActionMenu;
    }

    public void setGroupActionMenu(GroupActionMenu groupActionMenu) {
        this.groupActionMenu = groupActionMenu;
    }

    public MenuManager getFiltersMenuManager() {
        if (this.filtersMenuManager == null) {
            this.filtersMenuManager = new MenuManager();
        }
        return this.filtersMenuManager;
    }

    public FilterActionMenu getFilterActionMenu() {
        return this.filterActionMenu;
    }

    public void setFilterActionMenu(FilterActionMenu filterActionMenu) {
        this.filterActionMenu = filterActionMenu;
    }

    public DefaultGroupProvider getDefaultGroupProvider() {
        return new DefaultGroupProvider();
    }

    protected void handleDispose(DisposeEvent event) {
        this.getControl().removeListener(40, this.fEraseItemListener);
        this.removeSelectionChangedListener(this.fSelectionChangedListener);
        super.handleDispose(event);
    }

    protected Object[] getSortedChildren(Object parentElementOrTreePath) {
        EObject data;
        Notifier target;
        Object[] result = super.getSortedChildren(parentElementOrTreePath);
        if (parentElementOrTreePath instanceof Adapter && (target = ((Adapter)parentElementOrTreePath).getTarget()) instanceof TreeNode && (data = ((TreeNode)target).getData()) instanceof Conflict) {
            Collections.sort(Arrays.asList(result), new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return this.getValue(o1) - this.getValue(o2);
                }

                public int getValue(Object o) {
                    EObject d;
                    Notifier n;
                    int value = 0;
                    if (o instanceof Adapter && (n = ((Adapter)o).getTarget()) instanceof TreeNode && (d = ((TreeNode)n).getData()) instanceof Diff) {
                        value = ((Diff)d).getSource() == DifferenceSource.LEFT ? 1 : 2;
                    }
                    return value;
                }
            });
        }
        return result;
    }

    protected void handleEraseItemEvent(Event event) {
        Notifier targetItem;
        TreeItem item;
        Object dataTreeItem;
        EObject selectionData;
        Notifier target;
        ISelection selection = this.getSelection();
        Object firstElement = ((IStructuredSelection)selection).getFirstElement();
        if (firstElement instanceof Adapter && (target = ((Adapter)firstElement).getTarget()) instanceof TreeNode && (selectionData = ((TreeNode)target).getData()) instanceof Diff && (dataTreeItem = (item = (TreeItem)event.item).getData()) instanceof Adapter && (targetItem = ((Adapter)dataTreeItem).getTarget()) instanceof TreeNode) {
            Object unmergeables;
            Object requires;
            EObject dataItem = ((TreeNode)targetItem).getData();
            Boolean leftToRight = (Boolean)this.getCompareConfiguration().getProperty("org.eclipse.emf.compare.rcp.ui.MERGE_WAY");
            boolean ltr = false;
            if (leftToRight == null || leftToRight.booleanValue()) {
                ltr = true;
            }
            boolean leftEditable = this.getCompareConfiguration().isLeftEditable();
            boolean rightEditable = this.getCompareConfiguration().isRightEditable();
            Diff selectedDiff = (Diff)selectionData;
            if (rightEditable) {
                if (leftEditable) {
                    requires = DiffUtil.getRequires((Diff)selectedDiff, (boolean)ltr);
                    unmergeables = DiffUtil.getUnmergeables((Diff)selectedDiff, (boolean)ltr);
                } else {
                    requires = DiffUtil.getRequires((Diff)selectedDiff, (!ltr ? 1 : 0) != 0);
                    unmergeables = DiffUtil.getUnmergeables((Diff)selectedDiff, (!ltr ? 1 : 0) != 0);
                }
            } else if (leftEditable) {
                requires = DiffUtil.getRequires((Diff)selectedDiff, (boolean)ltr);
                unmergeables = DiffUtil.getUnmergeables((Diff)selectedDiff, (boolean)ltr);
            } else {
                requires = ImmutableSet.of();
                unmergeables = ImmutableSet.of();
            }
            GC g = event.gc;
            if (requires.contains(dataItem)) {
                this.paintItemBackground(g, item, this.requiredDiffColor);
            } else if (unmergeables.contains(dataItem)) {
                this.paintItemBackground(g, item, this.unmergeableDiffColor);
            }
        }
    }

    private void paintItemBackground(GC g, TreeItem item, Color color) {
        Rectangle itemBounds = item.getBounds();
        Tree tree = item.getParent();
        Rectangle areaBounds = tree.getClientArea();
        g.setClipping(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
        g.setBackground(color);
        g.fillRectangle(areaBounds.x, itemBounds.y, areaBounds.width, itemBounds.height);
    }
}

