/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.handler.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareNavigator;
import org.eclipse.compare.ICompareNavigator;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.DifferenceState;
import org.eclipse.emf.compare.domain.ICompareEditingDomain;
import org.eclipse.emf.compare.internal.merge.DiffMergeDataAdapter;
import org.eclipse.emf.compare.internal.merge.IDiffMergeData;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl.CascadingDifferencesFilter;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class EMFCompareUIHandlerUtil {
    private EMFCompareUIHandlerUtil() {
    }

    public static boolean isCascadingDifferencesFilterActive(CompareConfiguration configuration) {
        Object property = configuration.getProperty("org.eclipse.emf.compare.rcp.ui.SELECTED_FILTERS");
        if (property != null) {
            Collection selectedFilters = (Collection)property;
            for (IDifferenceFilter iDifferenceFilter : selectedFilters) {
                if (!(iDifferenceFilter instanceof CascadingDifferencesFilter)) continue;
                return true;
            }
        }
        return false;
    }

    public static void copyDiff(Diff diffToCopy, boolean leftToRight, CompareConfiguration configuration) {
        if (diffToCopy != null) {
            ArrayList<Diff> diffsToCopy = new ArrayList<Diff>();
            diffsToCopy.add(diffToCopy);
            for (Diff require : DiffUtil.getRequires((Diff)diffToCopy, (boolean)leftToRight)) {
                EMFCompareUIHandlerUtil.setMergeDataForDiff(require, leftToRight, configuration.isLeftEditable(), configuration.isRightEditable());
            }
            if (EMFCompareUIHandlerUtil.isCascadingDifferencesFilterActive(configuration)) {
                Iterables.addAll(diffsToCopy, (Iterable)((Iterable)org.eclipse.emf.compare.utils.DiffUtil.getSubDiffs((boolean)leftToRight).apply((Object)diffToCopy)));
            }
            for (Diff diff : diffsToCopy) {
                EMFCompareUIHandlerUtil.setMergeDataForDiff(diff, leftToRight, configuration.isLeftEditable(), configuration.isRightEditable());
            }
            EMFCompareUIHandlerUtil.addMergeDataForConflictedDiffs(diffToCopy, leftToRight, configuration);
            ICompareEditingDomain editingDomain = (ICompareEditingDomain)configuration.getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            Command copyCommand = editingDomain.createCopyCommand(diffsToCopy, leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            editingDomain.getCommandStack().execute(copyCommand);
        }
    }

    private static void addMergeDataForConflictedDiffs(Diff diffToCopy, boolean leftToRight, CompareConfiguration configuration) {
        Conflict conflict = diffToCopy.getConflict();
        if (conflict != null) {
            for (Diff conflictedDiff : conflict.getDifferences()) {
                if (diffToCopy == conflictedDiff || diffToCopy.getKind() == DifferenceKind.MOVE || (diffToCopy.getSource() != DifferenceSource.LEFT || conflictedDiff.getSource() != DifferenceSource.RIGHT) && (diffToCopy.getSource() != DifferenceSource.RIGHT || conflictedDiff.getSource() != DifferenceSource.LEFT)) continue;
                EMFCompareUIHandlerUtil.setMergeDataForDiff(conflictedDiff, leftToRight, configuration.isLeftEditable(), configuration.isRightEditable());
            }
        }
    }

    public static void copyAllDiffs(final boolean leftToRight, CompareConfiguration configuration) {
        Comparison comparison = (Comparison)configuration.getProperty("org.eclipse.emf.compare.rcp.ui.COMPARE.RESULT");
        ImmutableList differences = comparison.isThreeWay() ? ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)new Predicate<Diff>(){

            public boolean apply(Diff diff) {
                boolean fromRightToLeft;
                boolean unresolved = diff.getState() == DifferenceState.UNRESOLVED;
                boolean nonConflictual = diff.getConflict() == null;
                boolean fromLeftToRight = leftToRight && diff.getSource() == DifferenceSource.LEFT;
                boolean bl = fromRightToLeft = !leftToRight && diff.getSource() == DifferenceSource.RIGHT;
                return unresolved && nonConflictual && (fromLeftToRight || fromRightToLeft);
            }
        })) : ImmutableList.copyOf((Iterable)Iterables.filter((Iterable)comparison.getDifferences(), (Predicate)EMFComparePredicates.hasState((DifferenceState[])new DifferenceState[]{DifferenceState.UNRESOLVED})));
        if (differences.size() > 0) {
            for (Diff diff : differences) {
                EMFCompareUIHandlerUtil.setMergeDataForDiff(diff, leftToRight, configuration.isLeftEditable(), configuration.isRightEditable());
            }
            ICompareEditingDomain editingDomain = (ICompareEditingDomain)configuration.getProperty("org.eclipse.emf.compare.rcp.ui.EDITING_DOMAIN");
            Command copyCommand = editingDomain.createCopyCommand((List)differences, leftToRight, EMFCompareRCPPlugin.getDefault().getMergerRegistry());
            editingDomain.getCommandStack().execute(copyCommand);
        }
    }

    public static void navigate(boolean next, CompareConfiguration configuration) {
        ICompareNavigator navigator = configuration.getContainer().getNavigator();
        if (navigator instanceof CompareNavigator && ((CompareNavigator)navigator).hasChange(next)) {
            navigator.selectChange(next);
        }
    }

    public static void setMergeDataForDiff(Diff diff, boolean leftToRight, boolean leftEditable, boolean rightEditable) {
        Adapter adapter = EcoreUtil.getExistingAdapter((Notifier)diff, IDiffMergeData.class);
        if (adapter != null) {
            ((IDiffMergeData)adapter).setMergedTo(leftToRight);
            ((IDiffMergeData)adapter).setLeftEditable(leftEditable);
            ((IDiffMergeData)adapter).setRightEditable(rightEditable);
        } else {
            diff.eAdapters().add((Object)new DiffMergeDataAdapter(leftToRight, leftEditable, rightEditable));
        }
    }
}

