/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Predicate;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.diff.DefaultDiffEngine;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.internal.spec.ComparisonSpec;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.eobject.ProximityEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.URIDistance;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.internal.ReflectiveWeightProvider;
import org.eclipse.emf.compare.utils.EqualityHelper;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.InternalEList;

public class EditionDistance
implements ProximityEObjectMatcher.DistanceFunction {
    private int locationChangeCoef = 1;
    private int orderChangeCoef = 1;
    private URIDistance uriDistance = new URIDistance();
    private double[] thresholds = new double[]{0.0, 0.6, 0.6, 0.55, 0.465};
    private Comparison fakeComparison;
    private WeightProvider weights = new ReflectiveWeightProvider();

    public EditionDistance() {
        DefaultEqualityHelperFactory fakeEqualityHelperFactory = new DefaultEqualityHelperFactory(){

            public IEqualityHelper createEqualityHelper() {
                LoadingCache<EObject, URI> cache = EqualityHelper.createDefaultCache(this.getCacheBuilder());
                return new EqualityHelper(cache){

                    protected boolean matchingURIs(EObject object1, EObject object2) {
                        if (object1.eContainer() != null && object2.eContainer() != null && EditionDistance.this.fakeComparison.getMatch(object1.eContainer()) != null) {
                            return EditionDistance.this.uriDistance.retrieveFragment(object1).equals(EditionDistance.this.uriDistance.retrieveFragment(object2));
                        }
                        return EditionDistance.this.uriDistance.proximity(object1, object2) == 0;
                    }
                };
            }
        };
        this.fakeComparison = new ComparisonSpec(){

            public Match getMatch(EObject element) {
                for (Match m : this.getMatches()) {
                    if (m.getLeft() != element && m.getRight() != element && m.getOrigin() != element) continue;
                    return m;
                }
                return null;
            }
        };
        Match fakeMatch = CompareFactory.eINSTANCE.createMatch();
        ((InternalEList)this.fakeComparison.getMatches()).addUnique((Object)fakeMatch);
        IEqualityHelper equalityHelper = fakeEqualityHelperFactory.createEqualityHelper();
        this.fakeComparison.eAdapters().add((Object)equalityHelper);
        equalityHelper.setTarget((Notifier)this.fakeComparison);
    }

    public double distance(Comparison inProgress, EObject a, EObject b) {
        this.uriDistance.setComparison(inProgress);
        double maxDist = Math.max(this.getThresholdAmount(a), this.getThresholdAmount(b));
        double measuredDist = new CountingDiffEngine(maxDist, this.fakeComparison).measureDifferences(inProgress, a, b);
        if (measuredDist > maxDist) {
            return Double.MAX_VALUE;
        }
        return measuredDist;
    }

    public boolean areIdentic(Comparison inProgress, EObject a, EObject b) {
        return new CountingDiffEngine(0.0, this.fakeComparison).measureDifferences(inProgress, a, b) == 0.0;
    }

    public static Builder builder() {
        return new Builder();
    }

    public double getThresholdAmount(EObject eObj) {
        int max = 0;
        int nbFeatures = 0;
        for (EStructuralFeature feat : eObj.eClass().getEAllStructuralFeatures()) {
            int featureWeight = this.weights.getWeight(feat);
            if (featureWeight == 0 || !eObj.eIsSet(feat)) continue;
            max += featureWeight;
            ++nbFeatures;
        }
        return (double)(max += this.weights.getContainingFeatureWeight(eObj)) * this.getThresholdRatio(nbFeatures);
    }

    protected double getThresholdRatio(int nbFeatures) {
        if (nbFeatures >= this.thresholds.length) {
            return 0.465;
        }
        return this.thresholds[nbFeatures];
    }

    public static class Builder {
        private EditionDistance toBeBuilt = new EditionDistance();

        protected Builder() {
        }

        public Builder uri(int weight) {
            this.toBeBuilt.locationChangeCoef = weight;
            return this;
        }

        public Builder order(int weight) {
            this.toBeBuilt.orderChangeCoef = weight;
            return this;
        }

        public Builder weightProvider(WeightProvider provider) {
            this.toBeBuilt.weights = provider;
            return this;
        }

        public EditionDistance build() {
            return this.toBeBuilt;
        }
    }

    class CountingDiffEngine
    extends DefaultDiffEngine {
        private double maxDistance;
        private final Comparison comparison;

        public CountingDiffEngine(double maxDistance, Comparison fakeComparison) {
            super(new CountingDiffProcessor());
            this.maxDistance = maxDistance;
            this.comparison = fakeComparison;
        }

        protected void checkResourceAttachment(Match match, Monitor monitor) {
        }

        protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, attribute, checkOrdering);
            }
        }

        protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
            if (this.getCounter().getComputedDistance() <= this.maxDistance) {
                super.computeDifferences(match, reference, checkOrdering);
            }
        }

        public double measureDifferences(Comparison comparisonInProgress, EObject a, EObject b) {
            Match fakeMatch = this.createOrUpdateFakeMatch(a, b);
            this.getCounter().reset();
            double changes = 0.0;
            if (!this.haveSameContainer(comparisonInProgress, a, b)) {
                changes += (double)(EditionDistance.this.locationChangeCoef * EditionDistance.this.weights.getParentWeight(a));
            } else {
                int bIndex;
                int aIndex = this.getContainmentIndex(a);
                if (aIndex != (bIndex = this.getContainmentIndex(b))) {
                    changes += 5.0;
                }
            }
            if (a.eContainingFeature() != b.eContainingFeature()) {
                changes += (double)Math.max(EditionDistance.this.weights.getContainingFeatureWeight(a), EditionDistance.this.weights.getContainingFeatureWeight(b));
            }
            if (changes <= this.maxDistance) {
                this.checkForDifferences(fakeMatch, (Monitor)new BasicMonitor());
                changes += this.getCounter().getComputedDistance();
            }
            return changes;
        }

        private int getContainmentIndex(EObject a) {
            EStructuralFeature feat = a.eContainingFeature();
            EObject container = a.eContainer();
            int position = 0;
            if (container != null) {
                if (feat instanceof EAttribute) {
                    position = this.indexFromFeatureMap(a, feat, container);
                } else if (feat != null && feat.isMany()) {
                    EList eList = (EList)container.eGet(feat, false);
                    position = eList.indexOf((Object)a);
                }
            }
            return position;
        }

        private int indexFromFeatureMap(EObject a, EStructuralFeature feat, EObject container) {
            FeatureMap featureMap = (FeatureMap)container.eGet(feat, false);
            int i = 0;
            int size = featureMap.size();
            while (i < size) {
                EStructuralFeature entryFeature;
                if (featureMap.getValue(i) == a && (entryFeature = featureMap.getEStructuralFeature(i)) instanceof EReference && ((EReference)entryFeature).isContainment()) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        private boolean haveSameContainer(Comparison inProgress, EObject a, EObject b) {
            boolean matching;
            EObject aContainer = a.eContainer();
            EObject bContainer = b.eContainer();
            if (aContainer == null && bContainer != null || aContainer != null && bContainer == null) {
                return false;
            }
            boolean bl = matching = aContainer == null && bContainer == null;
            if (!matching) {
                Match mA = inProgress.getMatch(aContainer);
                Match mB = inProgress.getMatch(bContainer);
                matching = mA == null && mB == null ? EditionDistance.this.fakeComparison.getEqualityHelper().matchingValues(aContainer, bContainer) : this.isReferencedByTheMatch(bContainer, mA) || this.isReferencedByTheMatch(aContainer, mB);
            }
            return matching;
        }

        private boolean isReferencedByTheMatch(EObject eObj, Match match) {
            return match != null && (match.getRight() == eObj || match.getLeft() == eObj || match.getOrigin() == eObj);
        }

        private Match createOrUpdateFakeMatch(EObject a, EObject b) {
            Match fakeMatch = (Match)this.comparison.getMatches().get(0);
            fakeMatch.setLeft(a);
            fakeMatch.setRight(b);
            return fakeMatch;
        }

        protected CountingDiffProcessor getCounter() {
            return (CountingDiffProcessor)this.getDiffProcessor();
        }

        protected FeatureFilter createFeatureFilter() {
            return new FeatureFilter(){

                @Override
                public Iterator<EReference> getReferencesToCheck(Match match) {
                    return Iterators.filter(super.getReferencesToCheck(match), (Predicate)new Predicate<EReference>(){

                        public boolean apply(EReference input) {
                            return EditionDistance.this.weights.getWeight((EStructuralFeature)input) != 0;
                        }
                    });
                }

                @Override
                public Iterator<EAttribute> getAttributesToCheck(Match match) {
                    return Iterators.filter(super.getAttributesToCheck(match), (Predicate)new Predicate<EAttribute>(){

                        public boolean apply(EAttribute input) {
                            return EditionDistance.this.weights.getWeight((EStructuralFeature)input) != 0;
                        }
                    });
                }
            };
        }
    }

    class CountingDiffProcessor
    implements IDiffProcessor {
        private Set<EStructuralFeature> alreadyChanged = Sets.newLinkedHashSet();
        private double distance;

        CountingDiffProcessor() {
        }

        public void referenceChange(Match match, EReference reference, EObject value, DifferenceKind kind, DifferenceSource source) {
            if (!this.alreadyChanged.contains(reference)) {
                switch (kind) {
                    case MOVE: {
                        this.distance += (double)(EditionDistance.this.weights.getWeight((EStructuralFeature)reference) * EditionDistance.this.orderChangeCoef);
                        break;
                    }
                    case ADD: 
                    case DELETE: 
                    case CHANGE: {
                        this.distance += (double)EditionDistance.this.weights.getWeight((EStructuralFeature)reference);
                        break;
                    }
                }
                this.alreadyChanged.add((EStructuralFeature)reference);
            } else {
                this.distance += 1.0;
            }
        }

        public void attributeChange(Match match, EAttribute attribute, Object value, DifferenceKind kind, DifferenceSource source) {
            if (!this.alreadyChanged.contains(attribute)) {
                Object aValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attribute);
                Object bValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attribute);
                switch (kind) {
                    case MOVE: {
                        this.distance += (double)(EditionDistance.this.weights.getWeight((EStructuralFeature)attribute) * EditionDistance.this.orderChangeCoef);
                        break;
                    }
                    case ADD: 
                    case DELETE: 
                    case CHANGE: {
                        if (aValue instanceof String && bValue instanceof String) {
                            this.distance += (double)EditionDistance.this.weights.getWeight((EStructuralFeature)attribute) * (1.0 - DiffUtil.diceCoefficient((String)aValue, (String)bValue));
                            break;
                        }
                        this.distance += (double)EditionDistance.this.weights.getWeight((EStructuralFeature)attribute);
                        break;
                    }
                }
                this.alreadyChanged.add((EStructuralFeature)attribute);
            } else {
                this.distance += 1.0;
            }
        }

        public void resourceAttachmentChange(Match match, String uri, DifferenceKind kind, DifferenceSource source) {
        }

        public double getComputedDistance() {
            return this.distance;
        }

        public void reset() {
            this.alreadyChanged.clear();
        }
    }
}

