/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.structuremergeviewer.filters.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.filters.IDifferenceFilter;
import org.eclipse.emf.compare.scope.IComparisonScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DifferenceFilterRegistryImpl
implements IDifferenceFilter.Registry {
    private final Map<String, IDifferenceFilter> map = new ConcurrentHashMap<String, IDifferenceFilter>();

    public List<IDifferenceFilter> getFilters(IComparisonScope scope, Comparison comparison) {
        return Lists.newArrayList((Iterable)Iterables.filter(this.map.values(), DifferenceFilterRegistryImpl.isFilterActivable(scope, comparison)));
    }

    static final Predicate<IDifferenceFilter> isFilterActivable(final IComparisonScope scope, final Comparison comparison) {
        return new Predicate<IDifferenceFilter>(){

            public boolean apply(IDifferenceFilter d) {
                return d.isEnabled(scope, comparison);
            }
        };
    }

    @Override
    public IDifferenceFilter add(IDifferenceFilter filter) {
        Preconditions.checkNotNull((Object)filter);
        return this.map.put(filter.getClass().getName(), filter);
    }

    @Override
    public IDifferenceFilter remove(String className) {
        return this.map.remove(className);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

