/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Conflict;
import org.eclipse.emf.compare.ConflictKind;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Equivalence;
import org.eclipse.emf.compare.FeatureMapChange;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.ResourceAttachmentChange;
import org.eclipse.emf.compare.utils.EMFComparePredicates;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComparisonUtil {
    private static final Predicate<Diff> CASCADING_DIFF = Predicates.and((Predicate)Predicates.not(EMFComparePredicates.hasConflict(ConflictKind.REAL)), (Predicate)Predicates.not((Predicate)Predicates.instanceOf(ResourceAttachmentChange.class)));

    private ComparisonUtil() {
    }

    public static Function<Diff, Iterable<Diff>> getSubDiffs(boolean leftToRight) {
        return ComparisonUtil.getSubDiffs(leftToRight, new LinkedHashSet<Diff>());
    }

    public static boolean isAddOrSetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.ADD) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : (difference instanceof FeatureMapChange ? ((FeatureMapChange)difference).getAttribute() : null))) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject source = match.getComparison().isThreeWay() ? match.getOrigin() : match.getRight();
            result = source == null ? true : ComparisonUtil.isEqualToDefault(source, (EStructuralFeature)feature);
        }
        return result;
    }

    private static boolean isEqualToDefault(EObject object, EStructuralFeature feature) {
        Object value = ReferenceUtil.safeEGet(object, feature);
        Object defaultValue = feature.getDefaultValue();
        if (value == null) {
            return defaultValue == null;
        }
        return value.equals(feature.getDefaultValue()) || "".equals(value);
    }

    public static boolean isDeleteOrUnsetDiff(Diff difference) {
        Object feature;
        boolean result = false;
        if (difference.getKind() == DifferenceKind.DELETE) {
            result = true;
        } else if (difference.getKind() == DifferenceKind.CHANGE && (feature = difference instanceof ReferenceChange ? ((ReferenceChange)difference).getReference() : (difference instanceof AttributeChange ? ((AttributeChange)difference).getAttribute() : (difference instanceof FeatureMapChange ? ((FeatureMapChange)difference).getAttribute() : null))) != null && !feature.isMany()) {
            Match match = difference.getMatch();
            EObject expectedContainer = difference.getSource() == DifferenceSource.LEFT ? match.getLeft() : match.getRight();
            result = expectedContainer == null ? true : ComparisonUtil.isEqualToDefault(expectedContainer, (EStructuralFeature)feature);
        }
        return result;
    }

    public static boolean isFeatureMapContainment(Diff diff) {
        FeatureMap.Entry entry;
        Object entryValue;
        if (diff instanceof FeatureMapChange && (entryValue = (entry = (FeatureMap.Entry)((FeatureMapChange)diff).getValue()).getValue()) instanceof EObject) {
            Match match;
            EObject container = ((EObject)entryValue).eContainer();
            return container == (match = diff.getMatch()).getLeft() || container == match.getRight() || container == match.getOrigin();
        }
        return false;
    }

    public static EObject moveElementGetExpectedContainer(Comparison comparison, FeatureMapChange diff, boolean rightToLeft) {
        EObject expectedContainer = !ComparisonUtil.isFeatureMapContainment(diff) ? (rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight()) : (diff.getSource() == DifferenceSource.LEFT ? (rightToLeft ? ComparisonUtil.getContainerInEquivalence(comparison, diff, rightToLeft) : diff.getMatch().getRight()) : (rightToLeft ? diff.getMatch().getLeft() : ComparisonUtil.getContainerInEquivalence(comparison, diff, rightToLeft)));
        return expectedContainer;
    }

    private static EObject getContainerInEquivalence(Comparison comparison, FeatureMapChange diff, boolean rightToLeft) {
        EObject expectedContainer = null;
        Equivalence equ = diff.getEquivalence();
        if (equ != null) {
            for (Diff equivalence : equ.getDifferences()) {
                if (!(equivalence instanceof ReferenceChange)) continue;
                Match valueMatch = comparison.getMatch(((ReferenceChange)equivalence).getValue());
                Match targetContainerMatch = rightToLeft && valueMatch.getRight() != null ? comparison.getMatch(valueMatch.getRight().eContainer()) : (!rightToLeft && valueMatch.getLeft() != null ? comparison.getMatch(valueMatch.getLeft().eContainer()) : comparison.getMatch(valueMatch.getOrigin().eContainer()));
                expectedContainer = rightToLeft ? targetContainerMatch.getLeft() : targetContainerMatch.getRight();
                break;
            }
        } else {
            expectedContainer = rightToLeft ? diff.getMatch().getLeft() : diff.getMatch().getRight();
        }
        return expectedContainer;
    }

    private static Function<Diff, Iterable<Diff>> getSubDiffs(final boolean leftToRight, final LinkedHashSet<Diff> processedDiffs) {
        return new Function<Diff, Iterable<Diff>>(){

            public Iterable<Diff> apply(Diff diff) {
                if (diff instanceof ReferenceChange) {
                    Match matchOfValue = diff.getMatch().getComparison().getMatch(((ReferenceChange)diff).getValue());
                    if (((ReferenceChange)diff).getReference().isContainment()) {
                        Object subDiffs = EMFComparePredicates.ofKind(DifferenceKind.MOVE).apply((Object)diff) ? ImmutableList.of() : (matchOfValue != null ? Iterables.filter(matchOfValue.getAllDifferences(), (Predicate)CASCADING_DIFF) : ImmutableList.of());
                        Iterables.addAll((Collection)processedDiffs, (Iterable)subDiffs);
                        Iterable associatedDiffs = ComparisonUtil.getAssociatedDiffs(diff, (Iterable)subDiffs, processedDiffs, leftToRight);
                        return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)subDiffs, (Iterable)associatedDiffs));
                    }
                }
                return ImmutableSet.of();
            }
        };
    }

    private static Iterable<Diff> getAssociatedDiffs(Diff diffRoot, Iterable<Diff> subDiffs, LinkedHashSet<Diff> processedDiffs, boolean leftToRight) {
        HashSet<Diff> associatedDiffs = new HashSet<Diff>();
        for (Diff diff : subDiffs) {
            LinkedHashSet<Diff> reqs = new LinkedHashSet<Diff>();
            if (leftToRight) {
                if (diff.getSource() == DifferenceSource.LEFT) {
                    reqs.addAll((Collection<Diff>)diff.getRequires());
                } else {
                    reqs.addAll((Collection<Diff>)diff.getRequiredBy());
                }
            } else if (diff.getSource() == DifferenceSource.LEFT) {
                reqs.addAll((Collection<Diff>)diff.getRequiredBy());
            } else {
                reqs.addAll((Collection<Diff>)diff.getRequires());
            }
            reqs.remove(diffRoot);
            associatedDiffs.addAll(reqs);
            for (Diff req : reqs) {
                if (Iterables.contains(subDiffs, (Object)req) || processedDiffs.contains(req)) continue;
                processedDiffs.add(req);
                Iterables.addAll(associatedDiffs, (Iterable)((Iterable)ComparisonUtil.getSubDiffs(leftToRight, processedDiffs).apply((Object)req)));
            }
        }
        return associatedDiffs;
    }

    public static Comparison getComparison(EObject object) {
        EList<Diff> differences;
        Diff first;
        EObject eContainer;
        Comparison comparison = object instanceof Match ? ((Match)object).getComparison() : (object instanceof Diff ? ((Diff)object).getMatch().getComparison() : (object instanceof MatchResource ? ((MatchResource)object).getComparison() : (object instanceof Equivalence ? ((eContainer = object.eContainer()) instanceof Comparison ? (Comparison)eContainer : ((first = (Diff)Iterables.getFirst(differences = ((Equivalence)object).getDifferences(), null)) != null ? first.getMatch().getComparison() : null)) : (object instanceof Conflict ? ((eContainer = object.eContainer()) instanceof Comparison ? (Comparison)eContainer : ((first = (Diff)Iterables.getFirst(differences = ((Conflict)object).getDifferences(), null)) != null ? first.getMatch().getComparison() : null)) : null))));
        return comparison;
    }

    public static EObject getExpectedSide(Match match, DifferenceSource source, boolean mergeRightToLeft) {
        boolean undoingLeft = mergeRightToLeft && source == DifferenceSource.LEFT;
        boolean undoingRight = !mergeRightToLeft && source == DifferenceSource.RIGHT;
        Comparison comparison = match.getComparison();
        EObject result = comparison.isThreeWay() && (undoingLeft || undoingRight) && match.getOrigin() != null ? match.getOrigin() : (mergeRightToLeft ? match.getRight() : match.getLeft());
        return result;
    }
}

