/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.ComparisonCanceledException;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.EMFCompareMessages;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.diff.DiffBuilder;
import org.eclipse.emf.compare.diff.FeatureFilter;
import org.eclipse.emf.compare.diff.IDiffEngine;
import org.eclipse.emf.compare.diff.IDiffProcessor;
import org.eclipse.emf.compare.internal.utils.ComparisonUtil;
import org.eclipse.emf.compare.internal.utils.DiffUtil;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.compare.utils.ReferenceUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDiffEngine
implements IDiffEngine {
    protected static final Object UNMATCHED_VALUE = new Object();
    private IDiffProcessor diffProcessor;

    public DefaultDiffEngine() {
        this(new DiffBuilder());
    }

    public DefaultDiffEngine(IDiffProcessor processor) {
        this.diffProcessor = processor;
    }

    protected <E> boolean contains(Comparison comparison, Iterable<E> iterable, E element) {
        for (E candidate : iterable) {
            if (!comparison.getEqualityHelper().matchingValues(candidate, element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void diff(Comparison comparison, Monitor monitor) {
        monitor.subTask(EMFCompareMessages.getString("DefaultDiffEngine.monitor.diff"));
        for (Match rootMatch : comparison.getMatches()) {
            this.checkForDifferences(rootMatch, monitor);
        }
        for (MatchResource matchResource : comparison.getMatchedResources()) {
            this.checkResourceLocationChange(matchResource, monitor);
        }
    }

    protected void checkForDifferences(Match match, Monitor monitor) {
        if (monitor.isCanceled()) {
            throw new ComparisonCanceledException();
        }
        this.checkResourceAttachment(match, monitor);
        FeatureFilter featureFilter = this.createFeatureFilter();
        Iterator<EReference> references = featureFilter.getReferencesToCheck(match);
        while (references.hasNext()) {
            EReference reference = references.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)reference);
            this.computeDifferences(match, reference, considerOrdering);
        }
        Iterator<EAttribute> attributes = featureFilter.getAttributesToCheck(match);
        while (attributes.hasNext()) {
            EAttribute attribute = attributes.next();
            boolean considerOrdering = featureFilter.checkForOrderingChanges((EStructuralFeature)attribute);
            this.computeDifferences(match, attribute, considerOrdering);
        }
        for (Match submatch : match.getSubmatches()) {
            this.checkForDifferences(submatch, monitor);
        }
    }

    protected void checkResourceAttachment(Match match, Monitor monitor) {
        Comparison comparison = match.getComparison();
        if (comparison.getMatchedResources().isEmpty()) {
            return;
        }
        boolean originIsRoot = DefaultDiffEngine.isRoot(match.getOrigin());
        if (comparison.isThreeWay()) {
            if (originIsRoot) {
                String uri;
                if (!DefaultDiffEngine.isRoot(match.getLeft())) {
                    uri = match.getOrigin().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.LEFT);
                }
                if (!DefaultDiffEngine.isRoot(match.getRight())) {
                    uri = match.getOrigin().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.RIGHT);
                }
            } else {
                String uri;
                if (DefaultDiffEngine.isRoot(match.getLeft())) {
                    uri = match.getLeft().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.ADD, DifferenceSource.LEFT);
                }
                if (DefaultDiffEngine.isRoot(match.getRight())) {
                    uri = match.getRight().eResource().getURI().toString();
                    this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.ADD, DifferenceSource.RIGHT);
                }
            }
        } else {
            boolean leftIsRoot = DefaultDiffEngine.isRoot(match.getLeft());
            boolean rightIsRoot = DefaultDiffEngine.isRoot(match.getRight());
            if (leftIsRoot && !rightIsRoot) {
                String uri = match.getLeft().eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.ADD, DifferenceSource.LEFT);
            } else if (!leftIsRoot && rightIsRoot) {
                String uri = match.getRight().eResource().getURI().toString();
                this.getDiffProcessor().resourceAttachmentChange(match, uri, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
        }
    }

    protected void checkResourceLocationChange(MatchResource matchResource, Monitor monitor) {
        Resource rightResource;
        String left = matchResource.getLeftURI();
        String right = matchResource.getRightURI();
        Resource leftResource = matchResource.getLeft();
        if (!ComparisonUtil.bothResourceHaveResourceSet(leftResource, rightResource = matchResource.getRight()) || !ComparisonUtil.bothArePlatformResourcesAndOnlyOneExists(leftResource, rightResource)) {
            return;
        }
        if (matchResource.getComparison().isThreeWay()) {
            String origin = matchResource.getOriginURI();
            if (left == null || right == null || origin == null) {
                return;
            }
            if (!left.equals(right) && left.equals(origin)) {
                this.getDiffProcessor().resourceLocationChange(matchResource, left, right, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            } else if (!right.equals(left) && right.equals(origin)) {
                this.getDiffProcessor().resourceLocationChange(matchResource, right, left, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else if (!origin.equals(left) && !origin.equals(right)) {
                this.getDiffProcessor().resourceLocationChange(matchResource, origin, left, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                this.getDiffProcessor().resourceLocationChange(matchResource, origin, right, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            }
        } else if (left != null && right != null && !left.equals(right)) {
            this.getDiffProcessor().resourceLocationChange(matchResource, left, right, DifferenceKind.CHANGE, DifferenceSource.LEFT);
        }
    }

    protected static boolean isRoot(EObject eObj) {
        if (eObj instanceof InternalEObject) {
            return ((InternalEObject)eObj).eDirectResource() != null;
        }
        boolean isRoot = false;
        if (eObj != null) {
            Resource res = eObj.eResource();
            EObject container = eObj.eContainer();
            isRoot = container == null && res != null || container != null && container.eResource() != res;
        }
        return isRoot;
    }

    protected void computeContainmentDifferencesThreeWay(Match match, EReference reference, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> originValues = ReferenceUtil.getAsList(match.getOrigin(), (EStructuralFeature)reference);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(comparison, originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(comparison, originValues, rightValues);
        this.createContainmentDifferences(match, reference, checkOrdering, leftValues, lcsOriginLeft, DifferenceSource.LEFT);
        this.createContainmentDifferences(match, reference, checkOrdering, rightValues, lcsOriginRight, DifferenceSource.RIGHT);
        for (Object diffCandidate : originValues) {
            Match candidateMatch = comparison.getMatch((EObject)diffCandidate);
            if (candidateMatch == null) continue;
            if (candidateMatch.getLeft() == null) {
                this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (candidateMatch.getRight() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void createContainmentDifferences(Match match, EReference reference, boolean checkOrdering, List<Object> values, List<Object> lcsWithOrigin, DifferenceSource side) {
        Comparison comparison = match.getComparison();
        int lcsCursor = 0;
        Optional<Match> lcsCurrent = DefaultDiffEngine.getMatchIfPresent(comparison, lcsWithOrigin, lcsCursor);
        for (Object diffCandidate : values) {
            Match candidateMatch = comparison.getMatch((EObject)diffCandidate);
            if (candidateMatch == null || lcsCurrent.orNull() == candidateMatch) {
                lcsCurrent = DefaultDiffEngine.getMatchIfPresent(comparison, lcsWithOrigin, ++lcsCursor);
                continue;
            }
            EObject value = side == DifferenceSource.LEFT ? candidateMatch.getLeft() : candidateMatch.getRight();
            EObject originValue = comparison.isThreeWay() ? candidateMatch.getOrigin() : candidateMatch.getRight();
            if (this.matchingContainment(comparison.getEqualityHelper(), value, originValue)) {
                if (!checkOrdering) continue;
                this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.MOVE, side);
                continue;
            }
            if (originValue != null) {
                this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.MOVE, side);
                continue;
            }
            this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.ADD, side);
        }
    }

    protected boolean matchingContainment(IEqualityHelper equalityHelper, EObject o1, EObject o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        boolean matchingContainment = false;
        EObject container1 = o1.eContainer();
        EObject container2 = o2.eContainer();
        if (container1 != null && container2 != null) {
            EReference containing2;
            EReference containing1 = o1.eContainmentFeature();
            matchingContainment = (containing1 == (containing2 = o2.eContainmentFeature()) || containing1.getName().equals(containing2.getName())) && equalityHelper.matchingValues(o1.eContainer(), o2.eContainer());
        }
        return matchingContainment;
    }

    protected static Optional<Match> getMatchIfPresent(Comparison comparison, List<Object> list, int index) {
        EObject current;
        Optional value = Optional.absent();
        if (list.size() > index && (current = (EObject)list.get(index)) != null) {
            value = Optional.fromNullable((Object)comparison.getMatch(current));
        }
        return value;
    }

    protected static Optional<Object> getIfPresent(List<Object> list, int index) {
        Optional value = Optional.absent();
        if (list.size() > index) {
            value = Optional.fromNullable((Object)list.get(index));
        }
        return value;
    }

    protected void computeContainmentDifferencesTwoWay(Match match, EReference reference, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), (EStructuralFeature)reference);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), (EStructuralFeature)reference);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, rightValues, leftValues);
        this.createContainmentDifferences(match, reference, checkOrdering, leftValues, lcs, DifferenceSource.LEFT);
        for (Object diffCandidate : rightValues) {
            Match candidateMatch = comparison.getMatch((EObject)diffCandidate);
            if (candidateMatch == null || candidateMatch.getLeft() != null) continue;
            this.featureChange(match, (EStructuralFeature)reference, diffCandidate, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    protected void computeDifferences(Match match, EAttribute attribute, boolean checkOrdering) {
        EObject owner;
        Comparison comparison = match.getComparison();
        boolean shortcut = false;
        if (comparison.isThreeWay()) {
            shortcut = match.getOrigin() == null;
        } else {
            boolean bl = shortcut = match.getLeft() == null || match.getRight() == null;
        }
        if (shortcut && FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute) && (owner = this.getOwner(match)) != null && FeatureMapUtil.isMany((EObject)owner, (EStructuralFeature)attribute)) {
            shortcut = false;
        }
        if (shortcut) {
            return;
        }
        if (attribute.isMany()) {
            if (comparison.isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)attribute, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)attribute, checkOrdering);
            }
        } else {
            this.computeSingleValuedAttributeDifferences(match, attribute);
        }
    }

    private EObject getOwner(Match match) {
        EObject owner = null;
        if (match.getOrigin() != null) {
            owner = match.getOrigin();
        } else if (match.getLeft() != null) {
            owner = match.getLeft();
        } else if (match.getRight() != null) {
            owner = match.getRight();
        }
        return owner;
    }

    protected void computeDifferences(Match match, EReference reference, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        if (reference.isContainment()) {
            if (comparison.isThreeWay()) {
                this.computeContainmentDifferencesThreeWay(match, reference, checkOrdering);
            } else {
                this.computeContainmentDifferencesTwoWay(match, reference, checkOrdering);
            }
        } else if (reference.isMany()) {
            if (comparison.isThreeWay()) {
                this.computeMultiValuedFeatureDifferencesThreeWay(match, (EStructuralFeature)reference, checkOrdering);
            } else {
                this.computeMultiValuedFeatureDifferencesTwoWay(match, (EStructuralFeature)reference, checkOrdering);
            }
        } else if (comparison.isThreeWay()) {
            this.computeSingleValuedReferenceDifferencesThreeWay(match, reference);
        } else {
            this.computeSingleValuedReferenceDifferencesTwoWay(match, reference);
        }
    }

    protected void computeMultiValuedFeatureDifferencesThreeWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        IEqualityHelper equality = comparison.getEqualityHelper();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), feature);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), feature);
        List<Object> originValues = ReferenceUtil.getAsList(match.getOrigin(), feature);
        List<Object> lcsOriginLeft = DiffUtil.longestCommonSubsequence(comparison, originValues, leftValues);
        List<Object> lcsOriginRight = DiffUtil.longestCommonSubsequence(comparison, originValues, rightValues);
        int lcsCursor = 0;
        Optional<Object> lcsCurrent = DefaultDiffEngine.getIfPresent(lcsOriginLeft, lcsCursor);
        for (Object diffCandidate : leftValues) {
            if (equality.matchingValues(diffCandidate, lcsCurrent.orNull())) {
                lcsCurrent = DefaultDiffEngine.getIfPresent(lcsOriginLeft, ++lcsCursor);
                continue;
            }
            if (this.contains(comparison, originValues, diffCandidate)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && diffCandidate instanceof FeatureMap.Entry) {
                if (this.isFeatureMapEntryKeyChange(equality, (FeatureMap.Entry)diffCandidate, originValues)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    continue;
                }
                if (this.isFeatureMapValueMove(comparison, (FeatureMap.Entry)diffCandidate, DifferenceSource.LEFT)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.LEFT);
                    continue;
                }
                this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        lcsCursor = 0;
        lcsCurrent = DefaultDiffEngine.getIfPresent(lcsOriginRight, lcsCursor);
        for (Object diffCandidate : rightValues) {
            if (equality.matchingValues(diffCandidate, lcsCurrent.orNull())) {
                lcsCurrent = DefaultDiffEngine.getIfPresent(lcsOriginRight, ++lcsCursor);
                continue;
            }
            if (this.contains(comparison, originValues, diffCandidate)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                continue;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && diffCandidate instanceof FeatureMap.Entry) {
                if (this.isFeatureMapEntryKeyChange(equality, (FeatureMap.Entry)diffCandidate, originValues)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                    continue;
                }
                if (this.isFeatureMapValueMove(comparison, (FeatureMap.Entry)diffCandidate, DifferenceSource.RIGHT)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.RIGHT);
                    continue;
                }
                this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.RIGHT);
                continue;
            }
            this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.RIGHT);
        }
        for (Object diffCandidate : originValues) {
            if (!(this.contains(comparison, leftValues, diffCandidate) || !(feature instanceof EReference) && match.getLeft() == null || this.isFeatureMapChangeOrMove(comparison, feature, diffCandidate, leftValues, DifferenceSource.LEFT))) {
                this.featureChange(match, feature, diffCandidate, DifferenceKind.DELETE, DifferenceSource.LEFT);
            }
            if (this.contains(comparison, rightValues, diffCandidate) || !(feature instanceof EReference) && match.getRight() == null || this.isFeatureMapChangeOrMove(comparison, feature, diffCandidate, rightValues, DifferenceSource.RIGHT)) continue;
            this.featureChange(match, feature, diffCandidate, DifferenceKind.DELETE, DifferenceSource.RIGHT);
        }
    }

    protected void computeMultiValuedFeatureDifferencesTwoWay(Match match, EStructuralFeature feature, boolean checkOrdering) {
        Comparison comparison = match.getComparison();
        IEqualityHelper equality = comparison.getEqualityHelper();
        List<Object> leftValues = ReferenceUtil.getAsList(match.getLeft(), feature);
        List<Object> rightValues = ReferenceUtil.getAsList(match.getRight(), feature);
        List<Object> lcs = DiffUtil.longestCommonSubsequence(comparison, rightValues, leftValues);
        int lcsCursor = 0;
        Optional<Object> lcsCurrent = DefaultDiffEngine.getIfPresent(lcs, lcsCursor);
        for (Object diffCandidate : leftValues) {
            if (equality.matchingValues(diffCandidate, lcsCurrent.orNull())) {
                lcsCurrent = DefaultDiffEngine.getIfPresent(lcs, ++lcsCursor);
                continue;
            }
            if (this.contains(comparison, rightValues, diffCandidate)) {
                if (!checkOrdering) continue;
                this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && diffCandidate instanceof FeatureMap.Entry) {
                if (this.isFeatureMapEntryKeyChange(equality, (FeatureMap.Entry)diffCandidate, rightValues)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    continue;
                }
                if (this.isFeatureMapValueMove(comparison, (FeatureMap.Entry)diffCandidate, DifferenceSource.LEFT)) {
                    this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.LEFT);
                    continue;
                }
                this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.LEFT);
                continue;
            }
            this.featureChange(match, feature, diffCandidate, DifferenceKind.ADD, DifferenceSource.LEFT);
        }
        for (Object diffCandidate : rightValues) {
            if (this.contains(comparison, leftValues, diffCandidate)) continue;
            if (this.isFeatureMapMoveFromNonFeatureMapContainment(comparison, feature, diffCandidate, leftValues, DifferenceSource.LEFT)) {
                this.featureChange(match, feature, diffCandidate, DifferenceKind.MOVE, DifferenceSource.LEFT);
                continue;
            }
            if (this.isFeatureMapChangeOrMove(comparison, feature, diffCandidate, leftValues, DifferenceSource.LEFT)) continue;
            this.featureChange(match, feature, diffCandidate, DifferenceKind.DELETE, DifferenceSource.LEFT);
        }
    }

    private boolean isFeatureMapChange(Comparison comparison, EStructuralFeature feature, Object diffCandidate, List<Object> values, DifferenceSource source) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && this.isFeatureMapEntryKeyChange(comparison.getEqualityHelper(), (FeatureMap.Entry)diffCandidate, values);
    }

    private boolean isFeatureMapMove(Comparison comparison, EStructuralFeature feature, Object diffCandidate, List<Object> values, DifferenceSource source) {
        return FeatureMapUtil.isFeatureMap((EStructuralFeature)feature) && this.isFeatureMapValueMove(comparison, (FeatureMap.Entry)diffCandidate, source);
    }

    private boolean isFeatureMapMoveFromNonFeatureMapContainment(Comparison comparison, EStructuralFeature feature, Object diffCandidate, List<Object> values, DifferenceSource source) {
        Object entryValue;
        if (this.isFeatureMapMove(comparison, feature, diffCandidate, values, source) && (entryValue = ((FeatureMap.Entry)diffCandidate).getValue()) instanceof EObject) {
            EObject leftObject = comparison.getMatch((EObject)entryValue).getLeft();
            return !ComparisonUtil.isContainedInFeatureMap(leftObject);
        }
        return false;
    }

    private boolean isFeatureMapChangeOrMove(Comparison comparison, EStructuralFeature feature, Object diffCandidate, List<Object> values, DifferenceSource source) {
        return this.isFeatureMapChange(comparison, feature, diffCandidate, values, source) || this.isFeatureMapMove(comparison, feature, diffCandidate, values, source);
    }

    private boolean isFeatureMapEntryKeyChange(IEqualityHelper equality, FeatureMap.Entry entry, List<Object> entries) {
        Object entryValue = entry.getValue();
        EStructuralFeature entryKey = entry.getEStructuralFeature();
        if (entryKey instanceof EReference && ((EReference)entryKey).isContainment()) {
            for (Object object : entries) {
                if (!(object instanceof FeatureMap.Entry) || !equality.matchingValues(entryValue, ((FeatureMap.Entry)object).getValue())) continue;
                return !entryKey.equals(((FeatureMap.Entry)object).getEStructuralFeature());
            }
        }
        return false;
    }

    private boolean isFeatureMapValueMove(Comparison comparison, FeatureMap.Entry entry, DifferenceSource side) {
        boolean move;
        Object entryValue = entry.getValue();
        EStructuralFeature structuralFeature = entry.getEStructuralFeature();
        if (entryValue instanceof EObject && structuralFeature instanceof EReference && ((EReference)structuralFeature).isContainment()) {
            Match candidateMatch = comparison.getMatch((EObject)entryValue);
            if (candidateMatch == null) {
                move = false;
            } else {
                EObject value = side == DifferenceSource.LEFT ? candidateMatch.getLeft() : candidateMatch.getRight();
                EObject oppositeValue = comparison.isThreeWay() ? candidateMatch.getOrigin() : candidateMatch.getRight();
                move = value != null && oppositeValue != null ? !comparison.getEqualityHelper().matchingValues(value.eContainer(), oppositeValue.eContainer()) : false;
            }
        } else {
            move = false;
        }
        return move;
    }

    protected void computeSingleValuedAttributeDifferences(Match match, EAttribute attribute) {
        IEqualityHelper helper;
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)attribute);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)attribute);
        }
        if ((helper = comparison.getEqualityHelper()).matchingValues(leftValue, rightValue)) {
            if (leftValue != UNMATCHED_VALUE && comparison.isThreeWay()) {
                Object originValue = match.getOrigin() == null ? null : ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)attribute);
                boolean matchingLO = helper.matchingValues(leftValue, originValue);
                if (!matchingLO && this.isNullOrEmptyString(originValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                } else if (!matchingLO) {
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                    this.getDiffProcessor().attributeChange(match, attribute, originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else if (match.getOrigin() != null) {
            Object originValue = ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)attribute);
            if (helper.matchingValues(leftValue, originValue)) {
                Object changedValue = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    changedValue = originValue;
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            } else if (helper.matchingValues(rightValue, originValue)) {
                Object changedValue = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    changedValue = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, changedValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            } else {
                Object leftChange = leftValue;
                if (this.isNullOrEmptyString(leftValue)) {
                    leftChange = originValue;
                }
                Object rightChange = rightValue;
                if (this.isNullOrEmptyString(rightValue)) {
                    rightChange = originValue;
                }
                if (leftValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftChange, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
                if (rightValue != UNMATCHED_VALUE) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightChange, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        } else {
            if (leftValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(leftValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
                }
            }
            if (comparison.isThreeWay() && rightValue != UNMATCHED_VALUE) {
                if (this.isNullOrEmptyString(rightValue)) {
                    this.getDiffProcessor().attributeChange(match, attribute, leftValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                } else {
                    this.getDiffProcessor().attributeChange(match, attribute, rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
                }
            }
        }
    }

    private boolean isNullOrEmptyString(Object object) {
        return object == null || object instanceof String && ((String)object).length() == 0;
    }

    private boolean isNullOrUnmatched(Object object) {
        return object == null || object == UNMATCHED_VALUE;
    }

    protected void computeSingleValuedReferenceDifferencesThreeWay(Match match, EReference reference) {
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)reference);
        }
        Object originValue = UNMATCHED_VALUE;
        if (match.getOrigin() != null) {
            originValue = ReferenceUtil.safeEGet(match.getOrigin(), (EStructuralFeature)reference);
        }
        boolean distinctValueLO = !comparison.getEqualityHelper().matchingValues(leftValue, originValue);
        boolean bl = distinctValueLO = distinctValueLO && (!this.isNullOrUnmatched(leftValue) || !this.isNullOrUnmatched(originValue));
        if (distinctValueLO) {
            if (leftValue == null || leftValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
        boolean distinctValueRO = !comparison.getEqualityHelper().matchingValues(rightValue, originValue);
        boolean bl2 = distinctValueRO = distinctValueRO && (!this.isNullOrUnmatched(rightValue) || !this.isNullOrUnmatched(originValue));
        if (distinctValueRO) {
            if (rightValue == null || rightValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)originValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.RIGHT);
            }
        }
    }

    protected void computeSingleValuedReferenceDifferencesTwoWay(Match match, EReference reference) {
        Comparison comparison = match.getComparison();
        Object leftValue = UNMATCHED_VALUE;
        if (match.getLeft() != null) {
            leftValue = ReferenceUtil.safeEGet(match.getLeft(), (EStructuralFeature)reference);
        }
        Object rightValue = UNMATCHED_VALUE;
        if (match.getRight() != null) {
            rightValue = ReferenceUtil.safeEGet(match.getRight(), (EStructuralFeature)reference);
        }
        boolean distinctValue = !comparison.getEqualityHelper().matchingValues(leftValue, rightValue);
        boolean bl = distinctValue = distinctValue && (!this.isNullOrUnmatched(leftValue) || !this.isNullOrUnmatched(rightValue));
        if (distinctValue) {
            if (leftValue == null || leftValue == UNMATCHED_VALUE) {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)rightValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            } else {
                this.getDiffProcessor().referenceChange(match, reference, (EObject)leftValue, DifferenceKind.CHANGE, DifferenceSource.LEFT);
            }
        }
    }

    protected FeatureFilter createFeatureFilter() {
        return new FeatureFilter();
    }

    protected void featureChange(Match match, EStructuralFeature feature, Object value, DifferenceKind kind, DifferenceSource source) {
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)feature)) {
            this.getDiffProcessor().featureMapChange(match, (EAttribute)feature, value, kind, source);
        } else if (feature instanceof EAttribute) {
            this.getDiffProcessor().attributeChange(match, (EAttribute)feature, value, kind, source);
        } else if (value instanceof EObject) {
            this.getDiffProcessor().referenceChange(match, (EReference)feature, (EObject)value, kind, source);
        }
    }

    protected final IDiffProcessor getDiffProcessor() {
        return this.diffProcessor;
    }
}

