/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.EMFCompareStructureMergeViewer;
import org.eclipse.emf.compare.internal.merge.MergeDependenciesUtil;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IMerger;
import org.eclipse.emf.compare.rcp.ui.internal.configuration.IEMFCompareConfiguration;
import org.eclipse.emf.compare.rcp.ui.structuremergeviewer.groups.IDifferenceGroupProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.tree.TreeNode;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public class DependencyData {
    private final IEMFCompareConfiguration compareConfiguration;
    private Set<Diff> requires;
    private Set<Diff> rejectedDiffs;
    private static final Function<Object, EObject> ADAPTER__TARGET__DATA = new Function<Object, EObject>(){

        public EObject apply(Object object) {
            return EMFCompareStructureMergeViewer.getDataOfTreeNodeOfAdapter(object);
        }
    };

    public DependencyData(IEMFCompareConfiguration compareConfiguration) {
        this.compareConfiguration = compareConfiguration;
        this.requires = Sets.newHashSet();
        this.rejectedDiffs = Sets.newHashSet();
    }

    public void updateDependencies(ISelection selection, IMerger.Registry mergerRegistry) {
        boolean leftEditable = this.compareConfiguration.isLeftEditable();
        boolean rightEditable = this.compareConfiguration.isRightEditable();
        if (leftEditable || rightEditable) {
            Iterable selectedDiffs = Iterables.filter(DependencyData.getSelectedComparisonObjects(selection), Diff.class);
            MergeMode mergePreviewMode = this.compareConfiguration.getMergePreviewMode();
            this.requires = Sets.newHashSet();
            this.rejectedDiffs = Sets.newHashSet();
            Iterator iterator = selectedDiffs.iterator();
            while (iterator.hasNext()) {
                Diff diff;
                boolean leftToRight = mergePreviewMode.isLeftToRight(diff = (Diff)iterator.next(), leftEditable, rightEditable);
                this.requires.addAll(MergeDependenciesUtil.getAllResultingMerges((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0));
                this.requires.remove(diff);
                this.rejectedDiffs.addAll(MergeDependenciesUtil.getAllResultingRejections((Diff)diff, (IMerger.Registry)mergerRegistry, (!leftToRight ? 1 : 0) != 0));
                this.rejectedDiffs.remove(diff);
                this.requires.removeAll(this.rejectedDiffs);
            }
        }
    }

    private static List<EObject> getSelectedComparisonObjects(ISelection selection) {
        ArrayList ret = Lists.newArrayList();
        if (selection instanceof IStructuredSelection) {
            List selectedObjects = ((IStructuredSelection)selection).toList();
            Iterable data = Iterables.transform((Iterable)selectedObjects, ADAPTER__TARGET__DATA);
            Iterable notNullData = Iterables.filter((Iterable)data, (Predicate)Predicates.notNull());
            Iterables.addAll((Collection)ret, (Iterable)notNullData);
        }
        return ret;
    }

    public Set<Diff> getRequires() {
        return this.requires;
    }

    public Set<Diff> getRejections() {
        return this.rejectedDiffs;
    }

    public Collection<TreeNode> getTreeNodes(Diff diff) {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        IDifferenceGroupProvider groupProvider = this.compareConfiguration.getStructureMergeViewerGrouper().getProvider();
        nodes.addAll(groupProvider.getTreeNodes((EObject)diff));
        return nodes;
    }
}

