/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.internal.spec;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.impl.MatchImpl;
import org.eclipse.emf.compare.internal.SubMatchIterable;
import org.eclipse.emf.compare.internal.spec.EObjectUtil;
import org.eclipse.emf.ecore.EObject;

public class MatchSpec
extends MatchImpl {
    private static final Function<Match, List<Diff>> DIFFERENCES = new Function<Match, List<Diff>>(){

        public List<Diff> apply(Match match) {
            if (match == null) {
                return Lists.newArrayList();
            }
            return match.getDifferences();
        }
    };

    @Override
    public Comparison getComparison() {
        Comparison ret = null;
        EObject eContainer = this.eContainer();
        while (!(eContainer instanceof Comparison) && eContainer != null) {
            eContainer = eContainer.eContainer();
        }
        if (eContainer != null) {
            ret = (Comparison)eContainer;
        }
        return ret;
    }

    @Override
    public Iterable<Match> getAllSubmatches() {
        return new SubMatchIterable(this);
    }

    @Override
    public Iterable<Diff> getAllDifferences() {
        Iterable allSubDifferences = Iterables.concat((Iterable)Iterables.transform(this.getAllSubmatches(), DIFFERENCES));
        return Iterables.concat(this.getDifferences(), (Iterable)allSubDifferences);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("left", (Object)EObjectUtil.getLabel(this.getLeft())).add("right", (Object)EObjectUtil.getLabel(this.getRight())).add("origin", (Object)EObjectUtil.getLabel(this.getOrigin())).add("#differences", this.getDifferences().size()).add("#submatches", this.getSubmatches().size()).toString();
    }
}

