/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.emf.compare.rcp.extension.AbstractRegistryEventListener;
import org.eclipse.emf.compare.rcp.ui.internal.EMFCompareRCPUIMessages;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization.ContentMergeViewerCustomizationDescriptor;
import org.eclipse.emf.compare.rcp.ui.internal.contentmergeviewer.customization.ContentMergeViewerCustomizationRegistry;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemContentProvider;
import org.eclipse.emf.compare.rcp.ui.mergeviewer.item.provider.IMergeViewerItemProvider;

public class ContentMergeViewerCustomizationRegistryListener
extends AbstractRegistryEventListener {
    private static final String TAG_CONTENT_CUSTOMIZATION = "contentCustomization";
    private static final String TAG_TREE_CONTENT_CUSTOMIZATION = "treeContentCustomization";
    private static final String ATTRIBUTE_CONTENTPROVIDER = "contentProvider";
    private static final String ATTRIBUTE_MERGEVIEWERITEMPROVIDER = "mergeViewerItemProvider";
    private static final String ATTRIBUTE_CONTEXT = "context";
    private static final String ATTRIBUTE_RANKING = "ranking";
    private final ContentMergeViewerCustomizationRegistry registry;

    public ContentMergeViewerCustomizationRegistryListener(String pluginID, String extensionPointID, ILog log, ContentMergeViewerCustomizationRegistry contentMergeViewerCustomizationRegistry) {
        super(pluginID, extensionPointID, log);
        this.registry = contentMergeViewerCustomizationRegistry;
    }

    protected boolean addedValid(IConfigurationElement element) {
        if (element.getName().equals(TAG_CONTENT_CUSTOMIZATION)) {
            String mergeViewerItemProvider = element.getAttribute(ATTRIBUTE_MERGEVIEWERITEMPROVIDER);
            String context = element.getAttribute(ATTRIBUTE_CONTEXT);
            String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
            int ranking = -1;
            try {
                ranking = Integer.parseInt(rankingStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(4, element, EMFCompareRCPUIMessages.getString("ContentCustomizationRegistry.invalidRanking", mergeViewerItemProvider, rankingStr));
            }
            ContentMergeViewerCustomizationDescriptor<IMergeViewerItemProvider> descriptor = new ContentMergeViewerCustomizationDescriptor<IMergeViewerItemProvider>(element, mergeViewerItemProvider, ATTRIBUTE_MERGEVIEWERITEMPROVIDER, context, ATTRIBUTE_CONTEXT, ranking);
            this.registry.addCustomization(mergeViewerItemProvider, descriptor);
            return true;
        }
        if (element.getName().equals(TAG_TREE_CONTENT_CUSTOMIZATION)) {
            String contentProvider = element.getAttribute(ATTRIBUTE_CONTENTPROVIDER);
            String context = element.getAttribute(ATTRIBUTE_CONTEXT);
            String rankingStr = element.getAttribute(ATTRIBUTE_RANKING);
            int ranking = -1;
            try {
                ranking = Integer.parseInt(rankingStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.log(4, element, EMFCompareRCPUIMessages.getString("ContentCustomizationRegistry.invalidRanking", contentProvider, rankingStr));
            }
            ContentMergeViewerCustomizationDescriptor<IMergeViewerItemContentProvider> descriptor = new ContentMergeViewerCustomizationDescriptor<IMergeViewerItemContentProvider>(element, contentProvider, ATTRIBUTE_CONTENTPROVIDER, context, ATTRIBUTE_CONTEXT, ranking);
            this.registry.addTreeCustomization(contentProvider, descriptor);
            return true;
        }
        return false;
    }

    protected String getAttribute(IConfigurationElement element, String attributeName, String defaultResult) {
        String attribute = element.getAttribute(attributeName);
        if (attribute != null) {
            return attribute;
        }
        return defaultResult;
    }

    protected boolean removedValid(IConfigurationElement element) {
        String className = element.getName().equals(TAG_CONTENT_CUSTOMIZATION) ? element.getAttribute(ATTRIBUTE_MERGEVIEWERITEMPROVIDER) : element.getAttribute(ATTRIBUTE_CONTENTPROVIDER);
        this.registry.removeDescriptor(className);
        return true;
    }

    protected boolean validateExtensionElement(IConfigurationElement element) {
        return true;
    }
}

