/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.runtime.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.eef.runtime.ui.utils.EEFRuntimeUIMessages;
import org.eclipse.emf.eef.runtime.ui.utils.EditingUtils;
import org.eclipse.emf.eef.runtime.ui.widgets.ButtonsModeEnum;
import org.eclipse.emf.eef.runtime.ui.widgets.EMFModelViewerDialog;
import org.eclipse.emf.eef.runtime.ui.widgets.IPropertiesFilteredWidget;
import org.eclipse.emf.eef.runtime.ui.widgets.eobjflatcombo.EObjectFlatComboSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EObjectFlatComboViewer
extends Composite
implements ISelectionProvider,
IPropertiesFilteredWidget {
    private Text selection;
    protected Button editer;
    protected List<ViewerFilter> filters;
    private List<ISelectionChangedListener> listeners;
    protected List<ViewerFilter> bpFilters;
    protected Object selectedElement;
    protected ILabelProvider labelProvider;
    protected Object input;
    private ButtonsModeEnum button_mode = ButtonsModeEnum.BROWSE;

    public EObjectFlatComboViewer(Composite parent, boolean nullable) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.selection = new Text((Composite)this, 2048);
        GridData selectionData = new GridData(768);
        this.selection.setLayoutData((Object)selectionData);
        this.selection.setEditable(false);
        EditingUtils.setEEFtype((Control)this.selection, "eef::EObjectFlatComboViewer::field");
        this.editer = new Button((Composite)this, 8);
        this.editer.setText(EEFRuntimeUIMessages.EObjectFlatComboViewer_add_button);
        this.filters = new ArrayList<ViewerFilter>();
        this.bpFilters = new ArrayList<ViewerFilter>();
        this.listeners = new ArrayList<ISelectionChangedListener>();
        this.editer.addSelectionListener((SelectionListener)this.getSelectionAdapter(nullable));
        EditingUtils.setEEFtype((Control)this.editer, "eef::EObjectFlatComboViewer::editbutton");
    }

    protected SelectionAdapter getSelectionAdapter(final boolean nullable) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (EObjectFlatComboViewer.this.button_mode) {
                    case BROWSE: {
                        if (!(EObjectFlatComboViewer.this.input instanceof EObjectFlatComboSettings)) break;
                        EMFModelViewerDialog dialog = new EMFModelViewerDialog(EObjectFlatComboViewer.this.labelProvider, EObjectFlatComboViewer.this.input, EObjectFlatComboViewer.this.filters.isEmpty() ? null : EObjectFlatComboViewer.this.filters, EObjectFlatComboViewer.this.bpFilters.isEmpty() ? null : EObjectFlatComboViewer.this.bpFilters, nullable, false){

                            public void process(IStructuredSelection selection) {
                                if (selection == null) {
                                    (this).EObjectFlatComboViewer.this.selectedElement = null;
                                    EObjectFlatComboViewer.this.initComponent();
                                    EObjectFlatComboViewer.this.selectionChanged((ISelection)new StructuredSelection(Collections.EMPTY_LIST));
                                } else {
                                    (this).EObjectFlatComboViewer.this.selectedElement = selection.getFirstElement();
                                    EObjectFlatComboViewer.this.initComponent();
                                    if ((this).EObjectFlatComboViewer.this.selectedElement != null) {
                                        EObjectFlatComboViewer.this.selectionChanged((ISelection)new StructuredSelection((this).EObjectFlatComboViewer.this.selectedElement));
                                    } else {
                                        EObjectFlatComboViewer.this.selectionChanged((ISelection)new StructuredSelection(Collections.EMPTY_LIST));
                                    }
                                }
                            }
                        };
                        dialog.open();
                        break;
                    }
                }
            }
        };
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public ISelection getSelection() {
        if (this.selectedElement != null) {
            return new StructuredSelection(this.selectedElement);
        }
        return new StructuredSelection(Collections.EMPTY_LIST);
    }

    public void setLabelProvider(ILabelProvider provider) {
        this.labelProvider = provider;
    }

    public void setInput(Object input) {
        if (this.input != input) {
            this.input = input;
            this.selectedElement = null;
            this.selection.setText("");
        }
    }

    public void setID(Object id) {
        EditingUtils.setID((Control)this.selection, id);
        EditingUtils.setID((Control)this.editer, id);
    }

    public Object getID() {
        return EditingUtils.getID((Control)this.selection);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof StructuredSelection) {
            this.selectedElement = ((StructuredSelection)selection).getFirstElement();
            this.initComponent();
        }
    }

    public void addFilter(ViewerFilter filter) {
        this.filters.add(filter);
    }

    public void addBusinessRuleFilter(ViewerFilter filter) {
        this.bpFilters.add(filter);
    }

    public void resetFilters() {
        this.filters.clear();
    }

    protected void initComponent() {
        if (this.selectedElement != null && this.selection != null) {
            if (this.labelProvider != null) {
                this.selection.setText(this.labelProvider.getText(this.selectedElement));
            } else {
                this.selection.setText(this.selectedElement.toString());
            }
        } else {
            this.selection.setText("");
        }
    }

    protected void selectionChanged(ISelection selection) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (ISelectionChangedListener nextListener : this.listeners) {
                nextListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            }
        }
    }

    public void removeBusinessRuleFilter(ViewerFilter filter) {
        this.bpFilters.remove(filter);
    }

    public void removeFilter(ViewerFilter filter) {
        this.filters.remove(filter);
    }

    public void setButtonMode(ButtonsModeEnum button_mode) {
        this.button_mode = button_mode;
    }
}

