/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.ecore2rdb;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.interpreter.util.InterpreterUtil;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class Ecore2Rdb {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/ecore2rdb";
    public static final String EXAMPLE_ECORE_MODEL = "CarRental.ecore";
    public static final String EXAMPLE_PACKAGE_NAME = "CarRentalModel";
    public static final String EXAMPLE_RDB_MODEL = "CarRental-reference-result.xmi";

    public static void run(String path, String ecoreModel, String packageName, String referenceRdbModel, boolean saveResult) {
        System.out.println("Generating Rdb model for '" + ecoreModel + "'...");
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("ecore2rdb.henshin", false);
        Resource carRental = resourceSet.getResource(ecoreModel);
        EGraphImpl graph = new EGraphImpl(carRental);
        EngineImpl engine = new EngineImpl();
        Unit unit = module.getUnit("main");
        UnitApplicationImpl unitApp = new UnitApplicationImpl((Engine)engine, (EGraph)graph, unit, null);
        unitApp.setParameterValue("packageName", (Object)packageName);
        InterpreterUtil.executeOrDie((UnitApplication)unitApp);
        EObject result = (EObject)unitApp.getResultParameterValue("schema");
        System.out.println("Generated Rdb model.");
        if (saveResult) {
            String resultFile = ecoreModel.replaceFirst(".ecore", "-generated-result.xmi");
            resourceSet.saveEObject(result, resultFile);
            System.out.println("Saved result in '" + resultFile + "'");
        }
        if (referenceRdbModel != null) {
            Resource reference = resourceSet.getResource(referenceRdbModel);
            ResourceImpl generated = new ResourceImpl();
            generated.getContents().add((Object)result);
            if (!InterpreterUtil.areIsomorphic((Resource)reference, (Resource)generated)) {
                throw new AssertionError((Object)("Unexpected result for '" + ecoreModel + "'"));
            }
            System.out.println("Generated result is correct.");
        }
    }

    public static void main(String[] args) {
        Ecore2Rdb.run(PATH, EXAMPLE_ECORE_MODEL, EXAMPLE_PACKAGE_NAME, EXAMPLE_RDB_MODEL, true);
    }
}

