/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.external.prism;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpaceIndex;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.emf.henshin.statespace.external.AbstractFileBasedValidator;
import org.eclipse.emf.henshin.statespace.external.prism.MDPStateSpaceExporter;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMExperiment;
import org.eclipse.emf.henshin.statespace.external.prism.PRISMUtil;

public class MDPStateSpaceValidator
extends AbstractFileBasedValidator {
    public static final String VALIDATOR_ID = "org.eclipse.emf.henshin.statespace.validator.prism.mdp";

    public static void register() {
        StateSpacePlugin.INSTANCE.getValidators().put(VALIDATOR_ID, new MDPStateSpaceValidator());
    }

    public MDPStateSpaceValidator() {
    }

    public MDPStateSpaceValidator(StateSpaceIndex stateSpaceIndex) {
        this.setStateSpaceIndex(stateSpaceIndex);
    }

    public ValidationResult validate(StateSpace stateSpace, IProgressMonitor monitor) throws Exception {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Checking PCTL property...", 4);
        MDPStateSpaceExporter exporter = new MDPStateSpaceExporter();
        File modelFile = this.export(stateSpace, exporter, null, "nm", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.index.clearCache();
        String expanded = PRISMUtil.expandLabels(this.property, this.index, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        File propertyFile = this.createTempFile("property", ".pctl", expanded);
        this.index.clearCache();
        monitor.subTask("Running PRISM...");
        Map<String, String> constants = PRISMUtil.getAllProbs(stateSpace, true);
        Process process = PRISMUtil.invokePRISM(stateSpace, modelFile, propertyFile, new String[]{"-fixdl", "-gaussseidel"}, constants, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        ValidationResult result = PRISMExperiment.parseValidationResult(stateSpace, process, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        process.waitFor();
        return result;
    }

    public boolean usesProperty() {
        return true;
    }

    public String getName() {
        return "PRISM MDP/PTA";
    }
}

