/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.examples.bank;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class BankExample {
    public static final String PATH = "src/org/eclipse/emf/henshin/examples/bank";

    public static void run(String path, boolean saveResult) {
        HenshinResourceSet resourceSet = new HenshinResourceSet(path);
        Module module = resourceSet.getModule("bank.henshin", false);
        EGraphImpl graph = new EGraphImpl(resourceSet.getResource("example-bank.xmi"));
        EngineImpl engine = new EngineImpl(new String[0]);
        UnitApplicationImpl app = new UnitApplicationImpl((Engine)engine);
        app.setEGraph((EGraph)graph);
        app.setUnit(module.getUnit("createAccount"));
        app.setParameterValue("client", (Object)"Alice");
        app.setParameterValue("accountId", (Object)5);
        if (!app.execute(null)) {
            throw new RuntimeException("Error creating account for Alice");
        }
        app.setUnit(module.getUnit("transferMoney"));
        app.setParameterValue("client", (Object)"Alice");
        app.setParameterValue("fromId", (Object)1);
        app.setParameterValue("toId", (Object)2);
        app.setParameterValue("amount", (Object)50.0);
        if (!app.execute(null)) {
            throw new RuntimeException("Error transferring money");
        }
        app.setUnit(module.getUnit("deleteAllAccounts"));
        app.setParameterValue("client", (Object)"Charles");
        if (!app.execute(null)) {
            throw new RuntimeException("Error deleting Charles' accounts");
        }
        if (saveResult) {
            resourceSet.saveEObject((EObject)graph.getRoots().get(0), "example-result.xmi");
        }
    }

    public static void main(String[] args) {
        BankExample.run(PATH, true);
    }
}

