/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.impl;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.actions.ActionElementFinder;
import org.eclipse.emf.henshin.model.actions.AttributeActionHelper;
import org.eclipse.emf.henshin.model.impl.ModelElementImpl;

public class AttributeImpl
extends ModelElementImpl
implements Attribute {
    protected static final Action ACTION_EDEFAULT = null;
    private Adapter derivedFieldsUpdater = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            int featureID = msg.getFeatureID(Attribute.class);
            if (featureID == 2 || featureID == 3) {
                AttributeImpl.this.updateDerivedFields();
            }
        }
    };
    protected EAttribute type;
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final Object CONSTANT_EDEFAULT = null;
    protected Object constant = CONSTANT_EDEFAULT;
    protected static final boolean NULL_EDEFAULT = false;
    protected boolean null_ = false;

    protected AttributeImpl() {
        this.eAdapters().add((Object)this.derivedFieldsUpdater);
    }

    protected void updateDerivedFields() {
        this.constant = null;
        if (AttributeImpl.isNull(this.value)) {
            this.null_ = true;
            return;
        }
        this.null_ = false;
        if (this.value == null || this.type == null) {
            return;
        }
        if (this.type.getEType() == null) {
            EcoreUtil.resolveAll((EObject)this);
        }
        if (this.type.getEType() == null || this.type.getEType().getEPackage() == null || this.type.getEType().getEPackage().getEFactoryInstance() == null) {
            return;
        }
        String v = this.value.trim();
        if (this.type.isMany()) {
            if (v.startsWith("[") && v.endsWith("]")) {
                v = v.substring(1, v.length() - 1);
                BasicEList list = new BasicEList();
                String[] stringArray = v.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String e = stringArray[n2];
                    if (AttributeImpl.isNull(e)) {
                        list.add(null);
                    } else {
                        Object c = AttributeImpl.getConstant(e, this.type);
                        if (c != null) {
                            list.add(c);
                        } else {
                            list = null;
                            break;
                        }
                    }
                    ++n2;
                }
                this.constant = list;
            }
        } else {
            this.constant = AttributeImpl.getConstant(v, this.type);
        }
    }

    private static boolean isNull(String value) {
        return value != null && value.trim().equalsIgnoreCase("null");
    }

    private static Object getConstant(String value, EAttribute type) {
        if (type.getEType() instanceof EEnum) {
            try {
                return ((EEnum)type.getEType()).getEEnumLiteral(value);
            }
            catch (Throwable throwable) {}
        }
        if (type.getEType().getInstanceClass() == String.class) {
            String v = value.trim();
            if (v.startsWith("\"") && v.endsWith("\"") && (v = v.substring(1, v.length() - 1)).indexOf("\"") < 0) {
                return v;
            }
            if (v.startsWith("'") && v.endsWith("'") && (v = v.substring(1, v.length() - 1)).indexOf("'") < 0) {
                return v;
            }
            return null;
        }
        try {
            EFactory factory = type.getEType().getEPackage().getEFactoryInstance();
            return factory.createFromString(type.getEAttributeType(), value);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    @Override
    protected EClass eStaticClass() {
        return HenshinPackage.Literals.ATTRIBUTE;
    }

    @Override
    public Action getAction() {
        return AttributeActionHelper.INSTANCE.getAction(this);
    }

    @Override
    public void setAction(Action action) {
        AttributeActionHelper.INSTANCE.setAction(this, action);
    }

    @Override
    public EAttribute getType() {
        if (this.type != null && this.type.eIsProxy()) {
            InternalEObject oldType = (InternalEObject)this.type;
            this.type = (EAttribute)this.eResolveProxy(oldType);
            if (this.type != oldType && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldType, (Object)this.type));
            }
        }
        return this.type;
    }

    public EAttribute basicGetType() {
        return this.type;
    }

    @Override
    public void setType(EAttribute newType) {
        EAttribute oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String newValue) {
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public Node getNode() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Node)this.eContainer();
    }

    public Node basicGetNode() {
        if (this.eContainerFeatureID() != 4) {
            return null;
        }
        return (Node)this.eInternalContainer();
    }

    public NotificationChain basicSetNode(Node newNode, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newNode, 4, msgs);
        return msgs;
    }

    @Override
    public void setNode(Node newNode) {
        if (newNode != this.eInternalContainer() || this.eContainerFeatureID() != 4 && newNode != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newNode)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newNode != null) {
                msgs = ((InternalEObject)newNode).eInverseAdd((InternalEObject)this, 5, Node.class, msgs);
            }
            if ((msgs = this.basicSetNode(newNode, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newNode, (Object)newNode));
        }
    }

    @Override
    public Object getConstant() {
        return this.constant;
    }

    @Override
    public boolean isNull() {
        return this.null_;
    }

    @Override
    public Attribute getActionAttribute() {
        return ActionElementFinder.getActionElement(this, AttributeActionHelper.INSTANCE);
    }

    @Override
    public Graph getGraph() {
        Node node = this.getNode();
        return node != null ? node.getGraph() : null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetNode((Node)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetNode(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 5, Node.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getAction();
            }
            case 2: {
                if (resolve) {
                    return this.getType();
                }
                return this.basicGetType();
            }
            case 3: {
                return this.getValue();
            }
            case 4: {
                if (resolve) {
                    return this.getNode();
                }
                return this.basicGetNode();
            }
            case 5: {
                return this.getConstant();
            }
            case 6: {
                return this.isNull();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setAction((Action)newValue);
                return;
            }
            case 2: {
                this.setType((EAttribute)newValue);
                return;
            }
            case 3: {
                this.setValue((String)newValue);
                return;
            }
            case 4: {
                this.setNode((Node)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setAction(ACTION_EDEFAULT);
                return;
            }
            case 2: {
                this.setType(null);
                return;
            }
            case 3: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 4: {
                this.setNode(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSetGen(int featureID) {
        switch (featureID) {
            case 1: {
                return ACTION_EDEFAULT == null ? this.getAction() != null : !ACTION_EDEFAULT.equals(this.getAction());
            }
            case 2: {
                return this.type != null;
            }
            case 3: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 4: {
                return this.basicGetNode() != null;
            }
            case 5: {
                return CONSTANT_EDEFAULT == null ? this.constant != null : !CONSTANT_EDEFAULT.equals(this.constant);
            }
            case 6: {
                return this.null_;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        if (featureID == 1) {
            return false;
        }
        return this.eIsSetGen(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == GraphElement.class) {
            switch (derivedFeatureID) {
                case 1: {
                    return 0;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == GraphElement.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 1;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        String type = this.type != null ? this.type.getName() : null;
        return "Attribute (type: " + type + ", value: " + this.value + ")";
    }
}

