/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.emf.henshin.statespace.State;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.Transition;

public class StateDistanceMonitor {
    private StateSpace stateSpace;
    private int[] distances;

    public StateDistanceMonitor(StateSpace stateSpace) {
        this.stateSpace = stateSpace;
        this.distances = new int[0];
        this.updateDistances((Collection<State>)stateSpace.getInitialStates());
    }

    private void checkDistanceArraySize() {
        if (this.distances.length < this.stateSpace.getStates().size()) {
            int newSize = this.stateSpace.getStates().size() * 2 + 4;
            int[] newDistances = Arrays.copyOf(this.distances, newSize);
            Arrays.fill(newDistances, this.distances.length, newDistances.length, -1);
            this.distances = newDistances;
        }
    }

    public void updateDistance(State state) {
        this.updateDistances(Collections.singletonList(state));
    }

    public void updateDistances(Collection<State> states) {
        this.checkDistanceArraySize();
        HashSet<State> visited = new HashSet<State>();
        HashSet<State> current = new HashSet<State>();
        for (State state : states) {
            if (state == null) continue;
            current.add(state);
        }
        while (!current.isEmpty()) {
            for (State state : current) {
                int d = -1;
                if (state.isInitial()) {
                    d = 0;
                } else {
                    for (Transition incoming : state.getIncoming()) {
                        int c = this.distances[incoming.getSource().getIndex()];
                        if (c < 0 || d >= 0 && d <= c + 1) continue;
                        d = c + 1;
                    }
                }
                this.distances[state.getIndex()] = d;
                visited.add(state);
            }
            HashSet<State> successors = new HashSet<State>();
            for (State state : current) {
                for (Transition outgoing : state.getOutgoing()) {
                    State target = outgoing.getTarget();
                    if (visited.contains(target)) continue;
                    successors.add(target);
                }
            }
            current = successors;
        }
    }

    public int getDistance(State state) {
        int index = state.getIndex();
        if (index >= this.distances.length) {
            this.distances = new int[0];
            this.updateDistances((Collection<State>)this.stateSpace.getInitialStates());
        }
        return this.distances[index];
    }
}

