/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.diagram.edit.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.diagram.edit.helpers.HenshinBaseEditHelper;
import org.eclipse.emf.henshin.diagram.part.HenshinVisualIDRegistry;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.MultiUnit;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.UnaryUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.View;

public class UnitEditHelper
extends HenshinBaseEditHelper {
    public static List<View> getInvocationViews(View unitView, boolean withNulls) {
        if (String.valueOf(7003).equals(unitView.getType())) {
            unitView = (View)unitView.eContainer();
        }
        View unitCompartment = ViewUtil.getChildBySemanticHint((View)unitView, (String)String.valueOf(7003));
        Unit unit = (Unit)unitView.getElement();
        List<Unit> subunits = UnitEditHelper.getSubUnitsWithNulls(unit);
        ArrayList<View> invocations = new ArrayList<View>(subunits.size());
        for (Unit subunit : subunits) {
            invocations.add(UnitEditHelper.getInvocationView(unitCompartment, subunit, invocations));
        }
        return invocations;
    }

    public static View getInvocationView(View unitView, InvocationViewKey key) {
        return UnitEditHelper.getInvocationViews(unitView, true).get(key.index);
    }

    private static List<Unit> getSubUnitsWithNulls(Unit unit) {
        ArrayList<Unit> subUnits = new ArrayList<Unit>();
        if (unit instanceof ConditionalUnit) {
            subUnits.add(((ConditionalUnit)unit).getIf());
            subUnits.add(((ConditionalUnit)unit).getThen());
            subUnits.add(((ConditionalUnit)unit).getElse());
        } else if (unit instanceof UnaryUnit) {
            subUnits.add(((UnaryUnit)unit).getSubUnit());
        } else if (unit instanceof MultiUnit) {
            subUnits.addAll((Collection<Unit>)((MultiUnit)unit).getSubUnits());
        }
        return subUnits;
    }

    private static View getInvocationView(View unitCompartment, Unit target, Collection<View> exclude) {
        if (unitCompartment == null || target == null) {
            return null;
        }
        for (Object obj : unitCompartment.getChildren()) {
            View view = (View)obj;
            if (view.getElement() != target || !String.valueOf(3003).equals(view.getType()) || exclude.contains(view)) continue;
            return view;
        }
        return null;
    }

    public static View getUnitCompartment(View view) {
        String type = HenshinVisualIDRegistry.getType(7003);
        if (type.equals(view.getType())) {
            return view;
        }
        return ViewUtil.getChildBySemanticHint((View)view, (String)type);
    }

    public static void removeParameterMappingsToInvocation(Unit unit, Unit invocation) {
        EList invocationParams = invocation.getParameters();
        Iterator mappings = unit.getParameterMappings().iterator();
        while (mappings.hasNext()) {
            ParameterMapping mapping = (ParameterMapping)mappings.next();
            Parameter srcParam = mapping.getSource();
            Parameter tarParam = mapping.getTarget();
            if (!invocationParams.contains(srcParam) && !invocationParams.contains(tarParam)) continue;
            mappings.remove();
        }
    }

    public static enum InvocationViewKey {
        IF(0),
        THEN(1),
        ELSE(2),
        LOOP(0),
        ITERATE(0);

        private int index;

        private InvocationViewKey(int index) {
            this.index = index;
        }
    }
}

