/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.MappingList;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class CopySubgraphCommand
extends CompoundCommand {
    private EditingDomain domain;
    private Collection<Node> subgraphNodes;
    private Collection<Mapping> mappings;
    private Graph targetGraph;
    private Graph sourceGraph;
    private Collection<Node> newNodes;
    private Collection<Mapping> newMappings;
    private Map<Collection<Mapping>, Collection<Mapping>> orthoMappings;
    private Collection<Edge> newEdges;
    private Map<Node, Node> map = new HashMap<Node, Node>();
    private boolean isMappingOrigin = true;

    public void setDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void setNodes(Collection<Node> nodes) {
        this.subgraphNodes = nodes;
    }

    public void setMappings(Collection<Mapping> mappings) {
        this.mappings = mappings;
    }

    public void setTargetGraph(Graph targetGraph) {
        this.targetGraph = targetGraph;
    }

    public void setSourceGraph(Graph sourceGraph) {
        this.sourceGraph = sourceGraph;
    }

    public void setMappingOrigin(boolean isMappingOrigin) {
        this.isMappingOrigin = isMappingOrigin;
    }

    protected boolean prepare() {
        for (Node node : this.subgraphNodes) {
            if (node.getGraph().equals(this.sourceGraph)) continue;
            return false;
        }
        return true;
    }

    public void execute() {
        ArrayList<Node> nodesToCopy = new ArrayList<Node>();
        for (Node node : this.subgraphNodes) {
            if (this.isMapped(node)) continue;
            nodesToCopy.add(node);
        }
        Command copyCmd = CopyCommand.create((EditingDomain)this.domain, nodesToCopy);
        this.appendAndExecute(copyCmd);
        this.newNodes = copyCmd.getResult();
        this.newMappings = new ArrayList<Mapping>();
        this.orthoMappings = new IdentityHashMap<Collection<Mapping>, Collection<Mapping>>();
        Iterator origNodeIter = nodesToCopy.iterator();
        Iterator<Node> newNodeIter = this.newNodes.iterator();
        while (origNodeIter.hasNext() && newNodeIter.hasNext()) {
            Node origNode = (Node)origNodeIter.next();
            Node newNode = newNodeIter.next();
            Mapping m = this.isMappingOrigin ? HenshinFactory.eINSTANCE.createMapping(origNode, newNode) : HenshinFactory.eINSTANCE.createMapping(newNode, origNode);
            this.map.put(origNode, newNode);
            this.newMappings.add(m);
            this.collectOrthoMappings(origNode, newNode);
        }
        this.newEdges = new ArrayList<Edge>();
        for (Edge origEdge : this.sourceGraph.getEdges()) {
            if (!this.subgraphNodes.contains(origEdge.getSource()) || !this.subgraphNodes.contains(origEdge.getTarget())) continue;
            if (nodesToCopy.contains(origEdge.getSource()) || nodesToCopy.contains(origEdge.getTarget())) {
                Node sourceNode = this.map.containsKey(origEdge.getSource()) ? this.map.get(origEdge.getSource()) : this.getMappedNode(origEdge.getSource());
                Node targetNode = this.map.containsKey(origEdge.getTarget()) ? this.map.get(origEdge.getTarget()) : this.getMappedNode(origEdge.getTarget());
                this.newEdges.add(HenshinFactory.eINSTANCE.createEdge(sourceNode, targetNode, origEdge.getType()));
                continue;
            }
            boolean edgeFound = false;
            Node sourceNode = this.getMappedNode(origEdge.getSource());
            Node targetNode = this.getMappedNode(origEdge.getTarget());
            for (Edge targetEdge : this.targetGraph.getEdges()) {
                if (targetEdge.getSource() != sourceNode || targetEdge.getTarget() != targetNode) continue;
                edgeFound = true;
                break;
            }
            if (edgeFound) continue;
            this.newEdges.add(HenshinFactory.eINSTANCE.createEdge(sourceNode, targetNode, origEdge.getType()));
        }
        this.redo();
    }

    private void collectOrthoMappings(Node origNode, Node newNode) {
        Rule rule;
        if (this.sourceGraph.getRule() == this.targetGraph.getRule() && (rule = this.sourceGraph.getRule()).getKernelRule() != null) {
            Rule kernelRule = rule.getKernelRule();
            Node kernelOrig = rule.getMultiMappings().getOrigin(origNode);
            if (kernelOrig != null) {
                Mapping m;
                if (this.sourceGraph.isLhs()) {
                    Node kernelImage = kernelRule.getMappings().getImage(kernelOrig, kernelRule.getRhs());
                    if (kernelImage != null) {
                        m = HenshinFactory.eINSTANCE.createMapping(kernelImage, newNode);
                        if (!this.orthoMappings.containsKey(rule.getMultiMappings())) {
                            this.orthoMappings.put((Collection<Mapping>)rule.getMultiMappings(), new ArrayList());
                        }
                        this.orthoMappings.get(rule.getMultiMappings()).add(m);
                    }
                } else {
                    Node kernelOrigin = kernelRule.getMappings().getOrigin(kernelOrig);
                    if (kernelOrigin != null) {
                        m = HenshinFactory.eINSTANCE.createMapping(kernelOrigin, newNode);
                        if (!this.orthoMappings.containsKey(rule.getMultiMappings())) {
                            this.orthoMappings.put((Collection<Mapping>)rule.getMultiMappings(), new ArrayList());
                        }
                        this.orthoMappings.get(rule.getMultiMappings()).add(m);
                    }
                }
            }
        }
        if (this.sourceGraph.getRule() == this.targetGraph.getRule().getKernelRule()) {
            MappingList mTarget;
            rule = this.sourceGraph.getRule();
            Rule multiRule = this.targetGraph.getRule();
            if (this.sourceGraph.isLhs()) {
                Node multiImage;
                Node kernelImage = rule.getMappings().getImage(origNode, rule.getRhs());
                if (kernelImage != null && (multiImage = multiRule.getMultiMappings().getImage(kernelImage, multiRule.getRhs())) != null) {
                    mTarget = multiRule.getMappings();
                    Mapping m = HenshinFactory.eINSTANCE.createMapping(newNode, multiImage);
                    if (!this.orthoMappings.containsKey(mTarget)) {
                        this.orthoMappings.put((Collection<Mapping>)mTarget, new ArrayList());
                    }
                    this.orthoMappings.get(mTarget).add(m);
                }
            } else {
                Node multiOrigin;
                Node kernelOrigin = rule.getMappings().getOrigin(origNode);
                if (kernelOrigin != null && (multiOrigin = multiRule.getMultiMappings().getImage(kernelOrigin, multiRule.getLhs())) != null) {
                    mTarget = multiRule.getMappings();
                    Mapping m = HenshinFactory.eINSTANCE.createMapping(multiOrigin, newNode);
                    if (!this.orthoMappings.containsKey(mTarget)) {
                        this.orthoMappings.put((Collection<Mapping>)mTarget, new ArrayList());
                    }
                    this.orthoMappings.get(mTarget).add(m);
                }
            }
        }
    }

    public void redo() {
        this.targetGraph.getNodes().addAll(this.newNodes);
        this.targetGraph.getEdges().addAll(this.newEdges);
        this.mappings.addAll(this.newMappings);
        for (Collection<Mapping> target : this.orthoMappings.keySet()) {
            target.addAll(this.orthoMappings.get(target));
        }
    }

    public void undo() {
        this.targetGraph.getNodes().removeAll(this.newNodes);
        this.targetGraph.getEdges().removeAll(this.newEdges);
        this.mappings.removeAll(this.newMappings);
        for (Collection<Mapping> target : this.orthoMappings.keySet()) {
            target.removeAll(this.orthoMappings.get(target));
        }
    }

    public boolean canUndo() {
        return true;
    }

    private boolean isMapped(Node node) {
        for (Mapping m : this.mappings) {
            if (!(this.isMappingOrigin ? m.getOrigin() == node : m.getImage() == node)) continue;
            return true;
        }
        return false;
    }

    private Node getMappedNode(Node sourceGraphNode) {
        for (Mapping m : this.mappings) {
            if (this.isMappingOrigin) {
                if (m.getOrigin() != sourceGraphNode) continue;
                return m.getImage();
            }
            if (m.getImage() != sourceGraphNode) continue;
            return m.getOrigin();
        }
        return null;
    }
}

