/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.multicda.cda;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.Mapping;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.multicda.cda.Utils;
import org.eclipse.emf.henshin.multicda.cda.units.Span;
import org.eclipse.emf.henshin.multicda.cda.units.SpanMappings;

public class Pushout {
    HenshinFactory henshinFactory = HenshinFactory.eINSTANCE;
    Graph graph;
    Graph graphNoneDeletion;
    private HashMap<Node, Node> rule1toPOmap = new HashMap();
    private HashMap<Node, Node> rule2toPOmap = new HashMap();
    private Graph shadowGraph;

    public List<Mapping> getRule1Mappings() {
        return this.toMappingList(this.rule1toPOmap);
    }

    public List<Mapping> getRule2Mappings() {
        return this.toMappingList(this.rule2toPOmap);
    }

    private List<Mapping> toMappingList(HashMap<Node, Node> map) {
        LinkedList<Mapping> result = new LinkedList<Mapping>();
        for (Node node : map.keySet()) {
            result.add(this.henshinFactory.createMapping(node, map.get(node)));
        }
        return result;
    }

    public Graph getResultGraph() {
        return this.graph;
    }

    public Pushout(Rule rule1, Span l1Sl2, Rule rule2) {
        this(rule1.getLhs(), l1Sl2, rule2.getLhs(), true);
    }

    public Pushout(Graph l1, Span s1span, Graph l2, boolean validate) {
        Utils.checkNull(l1);
        Utils.checkNull(s1span);
        Utils.checkNull(l2);
        if (!s1span.validate(l1, l2)) {
            throw new IllegalArgumentException("Span is in invalide state.");
        }
        this.graph = this.preparePushoutGraph(l1);
        Map<EObject, EObject> shadow2Rule2 = this.prepareShadowPushoutGraph(l2);
        Graph s1 = s1span.getGraph();
        for (Node node : s1.getNodes()) {
            this.glue(s1span, new SpanMappings(s1span), node, shadow2Rule2, validate);
        }
        this.moveShadowContentsToPushout(this.graph, this.shadowGraph);
        if (validate) {
            this.validatePushout(l1, l2, s1);
        }
        this.graph.setName("Pushout");
    }

    private void glue(Span s1span, SpanMappings spanMappings, Node node, Map<EObject, EObject> shadow2Rule2, boolean validate) {
        Graph graphOfNodeL2;
        Node l1node = s1span.getMappingIntoRule1(node).getImage();
        Node l2node = s1span.getMappingIntoRule2(node).getImage();
        if (l1node == null || l2node == null) {
            throw new RuntimeException("Did not find a L1 or L2 counterpart for one of the nodes in S1!");
        }
        Node glueNode = this.rule1toPOmap.get(l1node);
        Node discardNode = this.rule2toPOmap.get(l2node);
        glueNode.setName(String.valueOf(glueNode.getName()) + "," + discardNode.getName());
        LinkedList l2nodesIncoming = new LinkedList(discardNode.getIncoming());
        for (Edge eIn : l2nodesIncoming) {
            if (spanMappings.getEdgeMappingsRule2S1().get(shadow2Rule2.get(eIn)) == null) {
                eIn.setTarget(glueNode);
                continue;
            }
            eIn.getGraph().removeEdge(eIn);
        }
        LinkedList l2nodesOutgoing = new LinkedList(discardNode.getOutgoing());
        for (Edge eOut : l2nodesOutgoing) {
            if (spanMappings.getEdgeMappingsRule2S1().get(shadow2Rule2.get(eOut)) == null) {
                eOut.setSource(glueNode);
                continue;
            }
            eOut.getGraph().removeEdge(eOut);
        }
        this.rule2toPOmap.put(l2node, glueNode);
        if (validate && discardNode.getAllEdges().size() > 0) {
            System.err.println("All Edges of should have been removed, but still " + l2node.getAllEdges().size() + " are remaining!");
        }
        if ((graphOfNodeL2 = discardNode.getGraph()) != null) {
            graphOfNodeL2.removeNode(discardNode);
        } else if (validate) {
            System.err.println(discardNode + " has no Graph");
        }
    }

    private void moveShadowContentsToPushout(Graph pushout, Graph shadowpushout) {
        LinkedList nodesInCopyOfLhsOfRule2 = new LinkedList(shadowpushout.getNodes());
        for (Node nodeInCopyOfLhsOfRule2 : nodesInCopyOfLhsOfRule2) {
            nodeInCopyOfLhsOfRule2.setGraph(pushout);
        }
        LinkedList edgesInCopyOfLhsOfRule2 = new LinkedList(shadowpushout.getEdges());
        for (Edge edgeInCopyOfLhsOfRule2 : edgesInCopyOfLhsOfRule2) {
            edgeInCopyOfLhsOfRule2.setGraph(pushout);
        }
        if (shadowpushout.getEdges().size() > 0) {
            System.err.println(String.valueOf(shadowpushout.getEdges().size()) + " edges remaining in " + shadowpushout + ", but should be 0");
        }
        if (shadowpushout.getNodes().size() > 0) {
            System.err.println(String.valueOf(shadowpushout.getNodes().size()) + " nodes remaining in " + shadowpushout + ", but should be 0");
        }
    }

    private Map<EObject, EObject> prepareShadowPushoutGraph(Graph l2) {
        EcoreUtil.Copier copierForRule2 = new EcoreUtil.Copier();
        this.shadowGraph = (Graph)copierForRule2.copy((EObject)l2);
        copierForRule2.copyReferences();
        for (Node node : l2.getNodes()) {
            Node copyResultNode = (Node)copierForRule2.get((Object)node);
            this.rule2toPOmap.put(node, copyResultNode);
        }
        HashMap<EObject, EObject> shadow2Rule2 = new HashMap<EObject, EObject>();
        for (EObject o : copierForRule2.keySet()) {
            shadow2Rule2.put((EObject)copierForRule2.get((Object)o), o);
        }
        return shadow2Rule2;
    }

    private Graph preparePushoutGraph(Graph l1) {
        EcoreUtil.Copier copierForRule1Map = new EcoreUtil.Copier();
        Graph pushout = (Graph)copierForRule1Map.copy((EObject)l1);
        copierForRule1Map.copyReferences();
        for (Node node : l1.getNodes()) {
            Node copyResultNode = (Node)copierForRule1Map.get((Object)node);
            this.rule1toPOmap.put(node, copyResultNode);
        }
        return pushout;
    }

    private void validatePushout(Graph l1, Graph l2, Graph s1) {
        int numberOfExpectedNodes = l1.getNodes().size() + l2.getNodes().size() - s1.getNodes().size();
        if (this.graph.getNodes().size() != numberOfExpectedNodes) {
            System.err.println("Number of nodes in created result graph (" + this.graph.getNodes().size() + ") not as expected (" + numberOfExpectedNodes + "). Difference: " + (this.graph.getNodes().size() - numberOfExpectedNodes));
        }
        int numberOfExpectedEdges = l1.getEdges().size() + l2.getEdges().size() - s1.getEdges().size();
        if (this.graph.getEdges().size() != numberOfExpectedEdges) {
            System.err.println("Number of edges in created result graph (" + this.graph.getEdges().size() + ") not as expected (" + numberOfExpectedEdges + "). Difference: " + (this.graph.getEdges().size() - numberOfExpectedEdges));
        }
    }

    public String toString() {
        return "Pushout: " + this.graph + "\nShadow graph: " + this.shadowGraph;
    }
}

