/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.configuration.ui.helpers;

import aima.core.logic.propositional.parsing.ast.Sentence;
import configuration.Configuration;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.emf.henshin.diagram.edit.parts.AttributeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.EdgeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.GraphElement;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.AbstractConcealingStrategy;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.FigureVisibilityConcealingStrategy;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.VariabilityModelHelper;
import org.eclipse.emf.henshin.variability.matcher.FeatureExpression;
import org.eclipse.emf.henshin.variability.wrapper.TransactionalVariabilityFactory;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class RuleEditPartVisibilityHelper {
    private static boolean CONCEAL = true;
    private static boolean REVEAL = false;
    private static AbstractConcealingStrategy fadingStrategy = new FigureVisibilityConcealingStrategy();

    public static AbstractConcealingStrategy getFadingStrategy() {
        return fadingStrategy;
    }

    public static void setFadingStrategy(AbstractConcealingStrategy fadingStrategy) {
        RuleEditPartVisibilityHelper.fadingStrategy = fadingStrategy;
    }

    private static RuleCompartmentEditPart getRuleCompartmentEditPart(RuleEditPart ruleEditPart) {
        if (ruleEditPart == null) {
            return null;
        }
        RuleCompartmentEditPart ruleCompEditPart = null;
        for (Object child : ruleEditPart.getChildren()) {
            if (!(child instanceof RuleCompartmentEditPart)) continue;
            ruleCompEditPart = (RuleCompartmentEditPart)child;
        }
        return ruleCompEditPart;
    }

    private static void toggleNode(NodeEditPart nodeEditPart, boolean shouldConceal) {
        EdgeEditPart edgeEditPart;
        fadingStrategy.apply((AbstractGraphicalEditPart)nodeEditPart, shouldConceal);
        for (Object sourceConnection : nodeEditPart.getSourceConnections()) {
            if (!(sourceConnection instanceof EdgeEditPart)) continue;
            edgeEditPart = (EdgeEditPart)sourceConnection;
            fadingStrategy.apply((AbstractGraphicalEditPart)edgeEditPart, shouldConceal);
        }
        for (Object targetConnection : nodeEditPart.getTargetConnections()) {
            if (!(targetConnection instanceof EdgeEditPart)) continue;
            edgeEditPart = (EdgeEditPart)targetConnection;
            fadingStrategy.apply((AbstractGraphicalEditPart)edgeEditPart, shouldConceal);
        }
    }

    private static void toggleNode(NodeEditPart nodeEditPart, GraphElementConcealingCondition condition) {
        boolean shouldConceal = condition.shouldConceal((GraphElement)nodeEditPart.getNode());
        RuleEditPartVisibilityHelper.toggleNode(nodeEditPart, shouldConceal);
    }

    private static void toggleRuleParts(RuleEditPart ruleEditPart, GraphElementConcealingCondition condition) {
        RuleCompartmentEditPart ruleCompEditPart = RuleEditPartVisibilityHelper.getRuleCompartmentEditPart(ruleEditPart);
        for (Object child : ruleCompEditPart.getChildren()) {
            if (!(child instanceof NodeEditPart)) continue;
            NodeEditPart nodeEditPart = (NodeEditPart)child;
            RuleEditPartVisibilityHelper.toggleNode(nodeEditPart, condition);
            RuleEditPartVisibilityHelper.toggleEdges(nodeEditPart, condition);
            RuleEditPartVisibilityHelper.toggleAttributes(nodeEditPart, condition);
        }
    }

    private static void toggleEdges(NodeEditPart nodeEditPart, GraphElementConcealingCondition condition) {
        boolean shouldConceal;
        EdgeEditPart edgeEditPart;
        for (Object sourceConnection : nodeEditPart.getSourceConnections()) {
            if (!(sourceConnection instanceof EdgeEditPart)) continue;
            edgeEditPart = (EdgeEditPart)sourceConnection;
            shouldConceal = condition.shouldConceal((GraphElement)((Edge)edgeEditPart.getNotationView().getElement()));
            fadingStrategy.apply((AbstractGraphicalEditPart)edgeEditPart, shouldConceal);
        }
        for (Object targetConnection : nodeEditPart.getTargetConnections()) {
            if (!(targetConnection instanceof EdgeEditPart)) continue;
            edgeEditPart = (EdgeEditPart)targetConnection;
            shouldConceal = condition.shouldConceal((GraphElement)((Edge)edgeEditPart.getNotationView().getElement()));
            fadingStrategy.apply((AbstractGraphicalEditPart)edgeEditPart, shouldConceal);
        }
    }

    private static void toggleAttributes(NodeEditPart nodeEditPart, GraphElementConcealingCondition condition) {
        for (Object nodeChild : nodeEditPart.getChildren()) {
            if (!(nodeChild instanceof NodeCompartmentEditPart)) continue;
            NodeCompartmentEditPart compartmentEditPart = (NodeCompartmentEditPart)nodeChild;
            for (Object compartmentChild : compartmentEditPart.getChildren()) {
                if (!(compartmentChild instanceof AttributeEditPart)) continue;
                AttributeEditPart attributeEditPart = (AttributeEditPart)compartmentChild;
                Attribute attribute = (Attribute)Adapters.adapt((Object)attributeEditPart, Attribute.class, (boolean)true);
                boolean shouldConceal = condition.shouldConceal((GraphElement)attribute);
                fadingStrategy.apply((AbstractGraphicalEditPart)attributeEditPart, shouldConceal);
            }
        }
    }

    public static void showBaseRule(RuleEditPart ruleEditPart) {
        if (ruleEditPart == null) {
            return;
        }
        RuleEditPartVisibilityHelper.toggleRuleParts(ruleEditPart, new BaseRuleConcealingCondition());
    }

    public static void showConfiguredRule(RuleEditPart ruleEditPart, Configuration configuration, String featureConstraint) {
        if (featureConstraint == null || configuration == null || ruleEditPart == null) {
            return;
        }
        RuleEditPartVisibilityHelper.toggleRuleParts(ruleEditPart, new ConfiguredRuleConcealingCondition(configuration));
    }

    public static void showFullRule(RuleEditPart ruleEditPart) {
        if (ruleEditPart == null) {
            return;
        }
        RuleCompartmentEditPart ruleCompEditPart = RuleEditPartVisibilityHelper.getRuleCompartmentEditPart(ruleEditPart);
        for (Object child : ruleCompEditPart.getChildren()) {
            if (!(child instanceof NodeEditPart)) continue;
            NodeEditPart nodeEditPart = (NodeEditPart)child;
            RuleEditPartVisibilityHelper.toggleNode(nodeEditPart, REVEAL);
            for (Object nodeChild : nodeEditPart.getChildren()) {
                if (!(nodeChild instanceof NodeCompartmentEditPart)) continue;
                NodeCompartmentEditPart compartmentEditPart = (NodeCompartmentEditPart)nodeChild;
                for (Object compartmentChild : compartmentEditPart.getChildren()) {
                    if (!(compartmentChild instanceof AttributeEditPart)) continue;
                    AttributeEditPart attributeEditPart = (AttributeEditPart)compartmentChild;
                    fadingStrategy.apply((AbstractGraphicalEditPart)attributeEditPart, REVEAL);
                }
            }
        }
    }

    private static class BaseRuleConcealingCondition
    implements GraphElementConcealingCondition {
        private BaseRuleConcealingCondition() {
        }

        @Override
        public boolean shouldConceal(GraphElement graphElement) {
            String pc = TransactionalVariabilityFactory.INSTANCE.createVariabilityGraphElement(graphElement).getPresenceCondition();
            return pc != null && !pc.isEmpty();
        }
    }

    private static class ConfiguredRuleConcealingCondition
    implements GraphElementConcealingCondition {
        final Sentence configurationExpr;

        public ConfiguredRuleConcealingCondition(Configuration configuration) {
            this.configurationExpr = VariabilityModelHelper.getFeatureExpression(configuration);
        }

        @Override
        public boolean shouldConceal(GraphElement graphElement) {
            boolean result = REVEAL;
            String pc = TransactionalVariabilityFactory.INSTANCE.createVariabilityGraphElement(graphElement).getPresenceCondition();
            if (pc != null && !pc.isEmpty()) {
                Sentence expr = FeatureExpression.getExpr((String)pc);
                result = FeatureExpression.contradicts((Sentence)expr, (Sentence)this.configurationExpr);
            }
            return result;
        }
    }

    private static interface GraphElementConcealingCondition {
        public boolean shouldConceal(GraphElement var1);
    }
}

