/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.ui.views;

import configuration.Configuration;
import configuration.ConfigurationFactory;
import configuration.Favorite;
import configuration.Feature;
import configuration.FeatureBinding;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.henshin.diagram.edit.parts.NodeCompartmentEditPart;
import org.eclipse.emf.henshin.diagram.edit.parts.RuleEditPart;
import org.eclipse.emf.henshin.diagram.edit.policies.NodeCompartmentItemSemanticEditPolicy;
import org.eclipse.emf.henshin.diagram.edit.policies.NodeItemSemanticEditPolicy;
import org.eclipse.emf.henshin.diagram.edit.policies.RuleCompartmentItemSemanticEditPolicy;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.configuration.ui.actions.LoadFavoriteConfigurationAction;
import org.eclipse.emf.henshin.variability.configuration.ui.controls.DropDownMenuAction;
import org.eclipse.emf.henshin.variability.configuration.ui.dialogs.NameDialog;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.CreationMode;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.FigureVisibilityConcealingStrategy;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.ImageHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.RuleEditPartVisibilityHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.ShapeAlphaConcealingStrategy;
import org.eclipse.emf.henshin.variability.configuration.ui.helpers.VariabilityModelHelper;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.IContentView;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.ILinkedWithEditorView;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.ITableViewerSynchronizedPart;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.LinkWithEditorSelectionListener;
import org.eclipse.emf.henshin.variability.configuration.ui.parts.SynchronizedTableViewer;
import org.eclipse.emf.henshin.variability.configuration.ui.policies.NodeVariabilityEditPolicy;
import org.eclipse.emf.henshin.variability.configuration.ui.policies.NodeVariabilityItemSemanticEditPolicy;
import org.eclipse.emf.henshin.variability.configuration.ui.policies.RuleVariabilityEditPolicy;
import org.eclipse.emf.henshin.variability.configuration.ui.providers.ConfigurationProvider;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerBindingEditingSupport;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerComparator;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerContentProvider;
import org.eclipse.emf.henshin.variability.ui.viewer.util.FeatureViewerNameEditingSupport;
import org.eclipse.emf.henshin.variability.ui.views.ObservableFeatureConstraintValue;
import org.eclipse.emf.henshin.variability.wrapper.TransactionalVariabilityFactory;
import org.eclipse.emf.henshin.variability.wrapper.VariabilityRule;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class VariabilityView
extends ViewPart
implements ILinkedWithEditorView,
IContentView<Configuration>,
ITableViewerSynchronizedPart {
    public static final String ID = "org.eclipse.emf.henshin.variability.ui.views.VariabilityView";
    private SynchronizedTableViewer viewer;
    private Action showBaseRuleAction;
    private Action showConfiguredRuleAction;
    private Action showFullRuleAction;
    private Action linkWithEditorAction;
    private Action fadeConcealingAction;
    private Action visibilityConcealingAction;
    private Action linkToViewingMode;
    private Action createInBase;
    private Action createInConfiguration;
    private DropDownMenuAction loadFavoritesMenu;
    private DropDownMenuAction elementCreationMenu;
    private LinkWithEditorSelectionListener linkWithEditorSelectionListener = new LinkWithEditorSelectionListener(this);
    private boolean linkingActive;
    private Text variabilityModelText;
    private DataBindingContext variabilityModelTextBindingContext;
    private ObservableFeatureConstraintValue<?> observableFeatureConstraintValue;
    private FeatureViewerComparator comparator;
    private ConfigurationProvider configurationProvider = ConfigurationProvider.getInstance();
    private WritableValue<Rule> writableValue;
    private CreationMode creationMode = CreationMode.SELECTION;
    private Configuration config;
    private RuleEditPart selectedRuleEditPart;
    private Label ruleNameLabel;
    private ToolItem add;
    private ToolItem delete;
    private ToolItem clear;
    private ToolItem refresh;
    private ToolItem selectedFavorite;
    private ToolItem deleteFavorite;
    private ToolBar favoriteToolBar;
    private ToolBar featureConstraintToolbar;

    public RuleEditPart getSelectedRuleEditPart() {
        return this.selectedRuleEditPart;
    }

    public void setSelectedRuleEditPart(RuleEditPart selectedRuleEditPart) {
        this.selectedRuleEditPart = selectedRuleEditPart;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    private Composite createViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout grid = new GridLayout(2, false);
        grid.marginLeft = -5;
        grid.marginRight = -5;
        grid.marginTop = -5;
        grid.marginBottom = -5;
        grid.horizontalSpacing = 0;
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 2, 1));
        composite.setLayout((Layout)grid);
        this.favoriteToolBar = new ToolBar(composite, 0x800000);
        this.favoriteToolBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.selectedFavorite = new ToolItem(this.favoriteToolBar, 0x800000);
        this.selectedFavorite.setText("Configuration");
        ToolBar buttonToolBar = new ToolBar(composite, 0x800000);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)buttonToolBar);
        buttonToolBar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        new ToolItem(buttonToolBar, 2);
        this.add = new ToolItem(buttonToolBar, 8);
        this.add.setImage(ImageHelper.getImage("/icons/add.png"));
        this.add.setToolTipText("Create feature");
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Rule rule = VariabilityModelHelper.getRuleForEditPart(VariabilityView.this.selectedRuleEditPart);
                NameDialog dialog = new NameDialog(VariabilityView.this.getViewSite().getShell(), "Feature", TransactionalVariabilityFactory.INSTANCE.createVariabilityRule(rule).getFeatures());
                if (dialog.open() == 0) {
                    String featureName = dialog.getName().trim();
                    Feature feature = ConfigurationFactory.eINSTANCE.createFeature();
                    feature.setName(featureName);
                    VariabilityView.this.config.addFeature(feature);
                    VariabilityView.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.add.setEnabled(false);
        this.delete = new ToolItem(buttonToolBar, 8);
        this.delete.setImage(ImageHelper.getImage("/icons/delete.png"));
        this.delete.setToolTipText("Delete selected features");
        this.delete.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Rule rule = VariabilityModelHelper.getRuleForEditPart(VariabilityView.this.selectedRuleEditPart);
                StructuredSelection selection = (StructuredSelection)VariabilityView.this.viewer.getSelection();
                ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
                for (Object obj : selection) {
                    if (!(obj instanceof Feature)) continue;
                    selectedFeatures.add((Feature)obj);
                }
                MessageDialog messageDialog = new MessageDialog(VariabilityView.this.getViewSite().getShell(), "Delete features", null, "Do you really want to delete the selected features?\nDoing so may render the rule's feature model invalid.", 4, new String[]{"Yes", "No"}, 0);
                if (messageDialog.open() == 0) {
                    for (Feature feature : selectedFeatures) {
                        VariabilityView.this.config.removeFeature(feature);
                    }
                    VariabilityView.this.configurationProvider.clearFavorites(VariabilityView.this.config);
                    VariabilityView.this.refreshFavorites(rule);
                    VariabilityView.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.delete.setEnabled(false);
        this.clear = new ToolItem(buttonToolBar, 8);
        this.clear.setImage(ImageHelper.getImage("/icons/clear.png"));
        this.clear.setToolTipText("Clear feature bindings");
        this.clear.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (VariabilityView.this.config != null) {
                    VariabilityView.this.clearFavorite();
                    for (Feature feature : VariabilityView.this.config.getFeatures()) {
                        feature.setBinding(FeatureBinding.UNBOUND);
                    }
                    VariabilityView.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.clear.setEnabled(false);
        this.refresh = new ToolItem(buttonToolBar, 8);
        this.refresh.setImage(ImageHelper.getImage("/icons/refresh.png"));
        this.refresh.setToolTipText("Refresh");
        this.refresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                VariabilityView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.clear.setEnabled(false);
        Composite tableComposite = new Composite(parent, 0);
        tableComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, true, 1, 1));
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.viewer = new SynchronizedTableViewer(tableComposite, 68354, this);
        this.createColumns(tableComposite, tableColumnLayout, this.viewer);
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new FeatureViewerContentProvider());
        this.viewer.setInput(this.config);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.comparator = new FeatureViewerComparator();
        this.viewer.setComparator(this.comparator);
        return tableComposite;
    }

    private void createColumns(Composite parent, TableColumnLayout tableColumnLayout, TableViewer viewer) {
        String[] titles = new String[]{"Feature", "Binding"};
        TableViewerColumn col = this.createTableViewerColumn(titles[0], 0);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Feature vp = (Feature)element;
                return vp.getName();
            }

            public Image getImage(Object element) {
                return ImageHelper.getImage("/icons/table_default.png");
            }
        });
        col.setEditingSupport((EditingSupport)new FeatureViewerNameEditingSupport(viewer));
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(60, false));
        col = this.createTableViewerColumn(titles[1], 1);
        col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                Feature vp = (Feature)element;
                return vp.getBinding().getName();
            }

            public Image getImage(Object element) {
                return ImageHelper.getImage("/icons/table_default.png");
            }
        });
        col.setEditingSupport((EditingSupport)new FeatureViewerBindingEditingSupport(viewer));
        tableColumnLayout.setColumnData((Widget)col.getColumn(), (ColumnLayoutData)new ColumnWeightData(40, false));
    }

    private TableViewerColumn createTableViewerColumn(String title, int index) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.viewer, 0, index);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setResizable(false);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, index));
        return viewerColumn;
    }

    public void createPartControl(Composite parent) {
        GridLayout gl_parent = new GridLayout(1, false);
        gl_parent.verticalSpacing = 0;
        parent.setLayout((Layout)gl_parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.ruleNameLabel = new Label(composite, 0);
        this.ruleNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.resetRuleNameLabel();
        Label separatorName = new Label(composite, 258);
        separatorName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label variabilityModelLabel = new Label(composite, 0);
        variabilityModelLabel.setImage(ImageHelper.getImage("/icons/variability.gif"));
        variabilityModelLabel.setText("Feature Constraint");
        variabilityModelLabel.setLayoutData((Object)new GridData(4, 16384, false, false, 1, 1));
        this.featureConstraintToolbar = new ToolBar(composite, 0x800000);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).grab(true, false).applyTo((Control)this.featureConstraintToolbar);
        this.featureConstraintToolbar.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        ToolItem createFeatures = new ToolItem(this.featureConstraintToolbar, 8);
        createFeatures.setImage(ImageHelper.getImage("/icons/create_features.png"));
        createFeatures.setToolTipText("Create all undefined features");
        createFeatures.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String[] missingFeatures;
                VariabilityModelHelper.getRuleForEditPart(VariabilityView.this.selectedRuleEditPart);
                String[] stringArray = missingFeatures = VariabilityView.this.config.getRule().getMissingFeatures();
                int n = missingFeatures.length;
                int n2 = 0;
                while (n2 < n) {
                    String featureName = stringArray[n2];
                    Feature feature = ConfigurationFactory.eINSTANCE.createFeature();
                    feature.setName(featureName);
                    VariabilityView.this.config.addFeature(feature);
                    ++n2;
                }
                VariabilityView.this.featureConstraintToolbar.setVisible(false);
                VariabilityView.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.featureConstraintToolbar.setVisible(false);
        this.variabilityModelText = new Text(composite, 2048);
        this.variabilityModelText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.variabilityModelText);
        this.variabilityModelTextBindingContext = new DataBindingContext();
        this.writableValue = new WritableValue();
        IObservableValue model = EMFProperties.value((EStructuralFeature)HenshinPackage.Literals.MODEL_ELEMENT__ANNOTATIONS).observeDetail(this.writableValue);
        this.observableFeatureConstraintValue = new ObservableFeatureConstraintValue((IObservableValue<String>)model);
        this.variabilityModelTextBindingContext.bindValue((IObservableValue)target, this.observableFeatureConstraintValue);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        GridData tableCompositeGridData = new GridData();
        tableCompositeGridData.grabExcessHorizontalSpace = true;
        tableCompositeGridData.grabExcessVerticalSpace = true;
        tableCompositeGridData.horizontalAlignment = 4;
        tableCompositeGridData.verticalAlignment = 4;
        tableCompositeGridData.horizontalSpan = 2;
        Composite tableComposite = this.createViewer(parent);
        tableComposite.setLayoutData((Object)tableCompositeGridData);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.viewer.getControl(), "org.eclipse.emf.henshin.variability.ui.viewer");
        this.createActions(parent);
        this.createMenu();
        this.createToolbar();
        this.toggleLinking(true);
    }

    private void updateEditPolicy(RuleEditPart ruleEditPart) {
        if (ruleEditPart == null) {
            return;
        }
        AbstractEditPart parent = (AbstractEditPart)ruleEditPart.getChildren().get(1);
        if (this.creationMode == CreationMode.CONFIGURATION || this.creationMode == CreationMode.SELECTION && !this.showBaseRuleAction.isChecked()) {
            this.installConfigurationEditPolicy(parent);
        } else {
            this.installBasePolicy(parent);
        }
    }

    protected void installBasePolicy(AbstractEditPart editPart) {
        editPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new RuleCompartmentItemSemanticEditPolicy());
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof NodeEditPart)) continue;
            NodeEditPart nodeEditPart = (NodeEditPart)child;
            nodeEditPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new NodeItemSemanticEditPolicy());
            NodeCompartmentEditPart nodeCompartmentEditPart = (NodeCompartmentEditPart)nodeEditPart.getChildren().get(2);
            nodeCompartmentEditPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new NodeCompartmentItemSemanticEditPolicy());
        }
    }

    private void installConfigurationEditPolicy(AbstractEditPart editPart) {
        editPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new RuleVariabilityEditPolicy(this.config));
        for (Object child : editPart.getChildren()) {
            if (!(child instanceof NodeEditPart)) continue;
            NodeEditPart nodeEditPart = (NodeEditPart)child;
            nodeEditPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new NodeVariabilityItemSemanticEditPolicy(this.config));
            NodeCompartmentEditPart nodeCompartmentEditPart = (NodeCompartmentEditPart)nodeEditPart.getChildren().get(2);
            nodeCompartmentEditPart.installEditPolicy((Object)"SemanticPolicy", (EditPolicy)new NodeVariabilityEditPolicy(this.config));
        }
    }

    private void createActions(Composite parent) {
        this.elementCreationMenu = new DropDownMenuAction("Element creation mode", (Control)parent);
        this.elementCreationMenu.setImageDescriptor(ImageHelper.getImageDescriptor("icons/creation_mode.gif"));
        this.linkToViewingMode = new Action("Link to viewing mode", 8){

            public void run() {
                VariabilityView.this.creationMode = CreationMode.SELECTION;
                VariabilityView.this.updateEditPolicy(VariabilityView.this.selectedRuleEditPart);
            }
        };
        this.linkToViewingMode.setImageDescriptor(ImageHelper.getImageDescriptor("icons/add_to_selection.gif"));
        this.createInBase = new Action("Create in base rule", 8){

            public void run() {
                VariabilityView.this.creationMode = CreationMode.BASE;
                VariabilityView.this.updateEditPolicy(VariabilityView.this.selectedRuleEditPart);
            }
        };
        this.createInBase.setImageDescriptor(ImageHelper.getImageDescriptor("icons/add_to_base.gif"));
        this.createInConfiguration = new Action("Create in configuration", 8){

            public void run() {
                VariabilityView.this.creationMode = CreationMode.CONFIGURATION;
                VariabilityView.this.updateEditPolicy(VariabilityView.this.selectedRuleEditPart);
            }
        };
        this.createInConfiguration.setImageDescriptor(ImageHelper.getImageDescriptor("icons/add_to_configuration.gif"));
        this.elementCreationMenu.addActionToMenu(this.linkToViewingMode);
        this.elementCreationMenu.addActionToMenu(this.createInBase);
        this.elementCreationMenu.addActionToMenu(this.createInConfiguration);
        this.visibilityConcealingAction = new Action("Visibility", 8){

            public void run() {
                RuleEditPartVisibilityHelper.showFullRule(VariabilityView.this.selectedRuleEditPart);
                RuleEditPartVisibilityHelper.setFadingStrategy(new FigureVisibilityConcealingStrategy());
                VariabilityView.this.runSelectedVisibilityAction();
            }
        };
        this.visibilityConcealingAction.setChecked(true);
        this.fadeConcealingAction = new Action("Fading", 8){

            public void run() {
                RuleEditPartVisibilityHelper.showFullRule(VariabilityView.this.selectedRuleEditPart);
                RuleEditPartVisibilityHelper.setFadingStrategy(new ShapeAlphaConcealingStrategy());
                VariabilityView.this.runSelectedVisibilityAction();
            }
        };
        this.showBaseRuleAction = new Action("Show base rule", 8){

            public void run() {
                if (this.isChecked()) {
                    super.run();
                    RuleEditPartVisibilityHelper.showBaseRule(VariabilityView.this.selectedRuleEditPart);
                    if (VariabilityView.this.creationMode == CreationMode.SELECTION) {
                        VariabilityView.this.updateEditPolicy(VariabilityView.this.selectedRuleEditPart);
                    }
                }
            }
        };
        this.showBaseRuleAction.setImageDescriptor(ImageHelper.getImageDescriptor("icons/rule_base.gif"));
        this.showConfiguredRuleAction = new Action("Show current configuration", 8){

            public void run() {
                if (this.isChecked() && VariabilityView.this.selectedRuleEditPart != null) {
                    super.run();
                    RuleEditPartVisibilityHelper.showConfiguredRule(VariabilityView.this.selectedRuleEditPart, VariabilityView.this.config, TransactionalVariabilityFactory.INSTANCE.createVariabilityRule((Rule)VariabilityView.this.config.getRule()).getFeatureConstraint());
                    if (VariabilityView.this.creationMode == CreationMode.SELECTION) {
                        VariabilityView.this.updateEditPolicy(VariabilityView.this.selectedRuleEditPart);
                    }
                }
            }
        };
        this.showConfiguredRuleAction.setImageDescriptor(ImageHelper.getImageDescriptor("icons/rule_configured.gif"));
        this.showFullRuleAction = new Action("Show full rule", 8){

            public void run() {
                if (this.isChecked()) {
                    super.run();
                    RuleEditPartVisibilityHelper.showFullRule(VariabilityView.this.selectedRuleEditPart);
                }
            }
        };
        this.showFullRuleAction.setImageDescriptor(ImageHelper.getImageDescriptor("icons/rule_full.gif"));
        this.showFullRuleAction.setChecked(true);
        this.loadFavoritesMenu = new DropDownMenuAction("Manage favorites", (Control)parent){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void runWithEvent(Event event) {
                if (VariabilityView.this.config == null) {
                    return;
                }
                if (event.detail != 0) return;
                if (!VariabilityView.this.configurationProvider.isFavorite(VariabilityView.this.config)) {
                    NameDialog dialog;
                    Rule rule = VariabilityModelHelper.getRuleForEditPart(VariabilityView.this.selectedRuleEditPart);
                    ArrayList<String> favoriteNames = new ArrayList<String>();
                    Set<Favorite> favorites = VariabilityView.this.configurationProvider.getFavorites(rule);
                    if (favorites != null) {
                        for (Favorite fav : favorites) {
                            favoriteNames.add(fav.getName());
                        }
                    }
                    if ((dialog = new NameDialog(VariabilityView.this.getViewSite().getShell(), "Favorite", favoriteNames)).open() != 0) return;
                    String name = dialog.getName();
                    Favorite favorite = VariabilityView.this.configurationProvider.addConfigurationToFavorites(rule, name, VariabilityView.this.config);
                    LoadFavoriteConfigurationAction loadConfigurationAction = new LoadFavoriteConfigurationAction(favorite, VariabilityView.this);
                    this.addActionToMenu(loadConfigurationAction);
                    this.uncheckAll();
                    VariabilityView.this.selectFavorite(VariabilityView.this.config);
                    loadConfigurationAction.setChecked(true);
                } else {
                    VariabilityView.this.configurationProvider.removeConfigurationFromFavorites(VariabilityView.this.config);
                    VariabilityView.this.refreshFavorites((Rule)VariabilityView.this.config.getRule());
                }
                this.setChecked(VariabilityView.this.configurationProvider.isFavorite(VariabilityView.this.config));
            }

            public void setChecked(boolean favorite) {
                String imagePath = favorite ? "icons/star.png" : "icons/star_grey.png";
                this.setImageDescriptor(ImageHelper.getImageDescriptor(imagePath));
                this.firePropertyChange("checked", !favorite, favorite);
            }
        };
        this.loadFavoritesMenu.setToolTipText("Manage favorites");
        this.loadFavoritesMenu.setImageDescriptor(ImageHelper.getImageDescriptor("icons/star_grey.png"));
        this.linkWithEditorAction = new Action("Link with editor", 2){

            public void run() {
                VariabilityView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setImageDescriptor(ImageHelper.getImageDescriptor("icons/synchronize.gif"));
    }

    private void createMenu() {
        IMenuManager mgr = this.getViewSite().getActionBars().getMenuManager();
        MenuManager subMgr = new MenuManager("Concealing strategies", ImageHelper.getImageDescriptor("icons/concealing.gif"), null);
        mgr.add((IAction)this.linkWithEditorAction);
        mgr.add((IContributionItem)subMgr);
        subMgr.add((IAction)this.fadeConcealingAction);
        subMgr.add((IAction)this.visibilityConcealingAction);
    }

    private void createToolbar() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add((IAction)this.elementCreationMenu);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.showBaseRuleAction);
        mgr.add((IAction)this.showConfiguredRuleAction);
        mgr.add((IAction)this.showFullRuleAction);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.loadFavoritesMenu);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.linkWithEditorAction);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    @Override
    public void setContent(Configuration config) {
        VariabilityRule rule = config.getRule();
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)rule);
        domain.addResourceSetListener((ResourceSetListener)new ConfigurationListener());
        this.viewer.setInput(config);
        this.updateRuleNameLabel(rule);
        this.writableValue.setValue((Object)rule);
        this.refreshFavorites((Rule)rule);
        if (this.showConfiguredRuleAction.isChecked()) {
            this.showConfiguredRuleAction.run();
        }
        if (rule.getMissingFeatures().length > 0) {
            this.featureConstraintToolbar.setVisible(true);
        } else {
            this.featureConstraintToolbar.setVisible(false);
        }
        this.add.setEnabled(true);
        this.delete.setEnabled(true);
        this.clear.setEnabled(true);
        this.refresh.setEnabled(true);
    }

    private void resetRuleNameLabel() {
        this.ruleNameLabel.setText("No rule selected");
    }

    private void updateRuleNameLabel(VariabilityRule rule) {
        if (rule != null) {
            String ruleName = rule.getName();
            if (ruleName != null && !ruleName.isEmpty()) {
                this.ruleNameLabel.setText("Selected rule: " + rule.getName());
            } else {
                this.ruleNameLabel.setText("Selected rule is unnamed");
            }
        } else {
            this.resetRuleNameLabel();
        }
    }

    @Override
    public Configuration getContent() {
        return this.config;
    }

    public void refresh() {
        this.viewer.refresh();
        this.variabilityModelTextBindingContext.updateModels();
        this.variabilityModelTextBindingContext.updateTargets();
        this.updateRuleNameLabel(this.config.getRule());
    }

    @Override
    public void editorSelectionChanged(IEditorPart activeEditor) {
        if (!this.linkingActive || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this) || activeEditor == null) {
            return;
        }
        StructuredSelection selection = (StructuredSelection)activeEditor.getEditorSite().getSelectionProvider().getSelection();
        if (selection.size() == 1 && selection.getFirstElement() instanceof RuleEditPart) {
            RuleEditPart ruleEditPart = (RuleEditPart)selection.getFirstElement();
            Rule rule = VariabilityModelHelper.getRuleForEditPart(ruleEditPart);
            this.config = this.configurationProvider.getConfiguration(rule);
            this.setContent(this.config);
            this.refresh();
        } else if (selection.size() == 1) {
            this.refresh();
        }
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            this.getSite().getPage().addSelectionListener((ISelectionListener)this.linkWithEditorSelectionListener);
            this.editorSelectionChanged(this.getSite().getPage().getActiveEditor());
        } else {
            this.getSite().getPage().removeSelectionListener((ISelectionListener)this.linkWithEditorSelectionListener);
        }
        if (this.linkWithEditorAction != null) {
            this.linkWithEditorAction.setChecked(checked);
        }
    }

    private void refreshFavorites(Rule rule) {
        this.loadFavoritesMenu.clearMenu();
        Set<Favorite> favorites = this.configurationProvider.getFavorites(rule);
        if (favorites != null) {
            for (Favorite favorite : favorites) {
                LoadFavoriteConfigurationAction loadConfigurationAction = new LoadFavoriteConfigurationAction(favorite, this);
                this.loadFavoritesMenu.addActionToMenu(loadConfigurationAction);
            }
        }
        this.selectFavorite(this.config);
    }

    @Override
    public void selectedRuleChanged(RuleEditPart ruleEditPart) {
        if (ruleEditPart != null) {
            Rule rule = VariabilityModelHelper.getRuleForEditPart(ruleEditPart);
            this.config = this.configurationProvider.getConfiguration(rule);
            this.selectedRuleEditPart = ruleEditPart;
            this.setContent(this.config);
            this.updateEditPolicy(ruleEditPart);
            this.refresh();
        }
    }

    private void runSelectedVisibilityAction() {
        if (this.showBaseRuleAction.isChecked()) {
            this.showBaseRuleAction.run();
        } else if (this.showConfiguredRuleAction.isChecked()) {
            this.showConfiguredRuleAction.run();
        }
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VariabilityView.this.comparator.setColumn(index);
                int sortDirection = VariabilityView.this.comparator.getDirection();
                VariabilityView.this.viewer.getTable().setSortDirection(sortDirection);
                VariabilityView.this.viewer.getTable().setSortColumn(column);
                VariabilityView.this.refresh();
            }
        };
        return selectionAdapter;
    }

    @Override
    public void tableViewerUpdated() {
        this.selectFavorite(this.config);
        if (this.showConfiguredRuleAction.isChecked()) {
            this.showConfiguredRuleAction.run();
        }
    }

    private void selectFavorite(Configuration config) {
        Favorite favorite = this.configurationProvider.findFavorite(config);
        if (favorite != null) {
            this.selectedFavorite.setText(favorite.getName());
            this.loadFavoritesMenu.setImageDescriptor(ImageHelper.getImageDescriptor("icons/star.png"));
        } else {
            this.clearFavorite();
        }
    }

    private void clearFavorite() {
        this.selectedFavorite.setText("Configuration");
        this.loadFavoritesMenu.uncheckAll();
        this.loadFavoritesMenu.setImageDescriptor(ImageHelper.getImageDescriptor("icons/star_grey.png"));
    }

    private class ConfigurationListener
    extends ResourceSetListenerImpl {
        private ConfigurationListener() {
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            Annotation annotation = this.findModifiedAnnotation(event.getNotifications());
            if (annotation != null) {
                String value = annotation.getValue();
                if ((annotation.getKey().equals("featureConstraint") || annotation.getKey().equals("features")) && value != null && !value.isEmpty()) {
                    if (VariabilityView.this.config.getRule().hasMissingFeatures()) {
                        VariabilityView.this.featureConstraintToolbar.setVisible(true);
                    } else {
                        VariabilityView.this.featureConstraintToolbar.setVisible(false);
                    }
                }
            }
            if (VariabilityView.this.observableFeatureConstraintValue.shouldUpdate()) {
                VariabilityView.this.refresh();
            } else {
                VariabilityView.this.viewer.refresh();
            }
        }

        private Annotation findModifiedAnnotation(List<Notification> notifications) {
            for (Notification notification : notifications) {
                if (!(notification.getNotifier() instanceof Annotation)) continue;
                return (Annotation)notification.getNotifier();
            }
            return null;
        }
    }
}

