/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.core.ast.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.mwe.core.customizer.CustomizationException;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.internal.core.ast.AbstractASTBase;
import org.eclipse.emf.mwe.internal.core.ast.ComponentAST;
import org.eclipse.emf.mwe.internal.core.ast.InclusionAST;
import org.eclipse.emf.mwe.internal.core.ast.ReferenceAST;
import org.eclipse.emf.mwe.internal.core.ast.SimpleParamAST;
import org.eclipse.emf.mwe.internal.core.ast.util.Injector;
import org.eclipse.emf.mwe.internal.core.ast.util.InjectorFactory;
import org.eclipse.emf.mwe.internal.core.ast.util.VisitorBase;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowContainer;
import org.eclipse.emf.mwe.internal.core.ast.util.converter.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorAnalyzer
extends VisitorBase {
    private Map<Class<?>, Converter> converter = new HashMap();
    private Class<?> currentComponentClass = null;
    private Issues issues = new IssuesImpl();

    private VisitorAnalyzer cloneWithCurrentClass(Class<?> c) {
        VisitorAnalyzer ana = new VisitorAnalyzer(this.issues, this.converter, c);
        return ana;
    }

    public VisitorAnalyzer(Issues issues, Map<Class<?>, Converter> converter, Class<?> currentComponentClass) {
        if (currentComponentClass == null) {
            throw new NullPointerException("currentComponentClass");
        }
        this.issues = issues;
        this.converter = converter;
        this.currentComponentClass = currentComponentClass;
    }

    @Override
    public Object visitComponentAST(ComponentAST componentAST) {
        String elementName = componentAST.getName();
        Class<?> expected = null;
        try {
            expected = this.getTypeForProperty(elementName);
        }
        catch (CustomizationException ex) {
            this.issues.addError(ex.getMessage(), componentAST);
            return null;
        }
        if (expected == null) {
            this.issues.addError("No getter or adder method for property '" + elementName + "' in clazz '" + this.currentComponentClass.getName() + "' found. Forgot to customize?", componentAST);
        } else {
            if (componentAST.getClazz() != null) {
                Class<?> actual = this.loader.loadClass(componentAST.getClazz());
                if (actual == null) {
                    this.issues.addError("Class not found: '" + componentAST.getClazz() + "'", componentAST);
                } else if (!expected.isAssignableFrom(actual)) {
                    this.issues.addError("Incompatible Classes: '" + componentAST.getClazz() + "' is not a subclass of the expected class '" + expected.getName() + "'.", componentAST);
                } else {
                    expected = actual;
                }
            }
            componentAST.setAnalyzedType(expected);
            VisitorAnalyzer v = this.cloneWithCurrentClass(expected);
            Iterator<AbstractASTBase> iter = componentAST.getChildren().iterator();
            while (iter.hasNext()) {
                iter.next().accept(v);
            }
        }
        return expected;
    }

    @Override
    public Object visitReferenceAST(ReferenceAST ele) {
        Class<?> expected = null;
        try {
            expected = this.getTypeForProperty(ele.getName());
        }
        catch (CustomizationException ex) {
            this.issues.addError(ex.getMessage(), ele);
            return null;
        }
        if (expected == null) {
            this.issues.addError("No setter or adder method for property '" + ele.getName() + "' in clazz '" + this.currentComponentClass.getName() + "' found", ele);
            return ele;
        }
        if (ele.getReference() != null) {
            Class c = (Class)ele.getReference().getAnalyzedType();
            if (c != null && !expected.isAssignableFrom(c)) {
                this.issues.addWarning("The type of the referred bean (" + c.getName() + ") is not assignable to " + expected.getName());
            }
            return c;
        }
        this.issues.addError("Reference to bean with id " + ele.getIdRef() + " not resolved!", ele);
        return expected;
    }

    @Override
    public Object visitSimpleParamAST(SimpleParamAST ele) {
        Class<?> expected = null;
        try {
            expected = this.getTypeForProperty(ele.getName());
        }
        catch (CustomizationException ex) {
            this.issues.addError(ex.getMessage(), ele);
            return null;
        }
        if (expected == null) {
            this.issues.addError("No getter or adder method for property '" + ele.getName() + "' in clazz '" + this.getCurrClassName() + "' found.", ele);
        } else if (!this.converter.containsKey(expected)) {
            this.issues.addError("Cannot convert from String to '" + expected.getName() + "'. You need to register a corresponding Converter.", ele);
        }
        return expected;
    }

    private String getCurrClassName() {
        return this.currentComponentClass != null ? this.currentComponentClass.getName() : "unknown";
    }

    private Class<?> getTypeForProperty(String name) {
        Injector inj;
        if (this.currentComponentClass != null && (inj = InjectorFactory.getInjector(this.currentComponentClass, name)) != null) {
            return inj.getRequiredType();
        }
        return null;
    }

    @Override
    public Object visitInclusionAST(InclusionAST ele) {
        if (ele.getImportedElement() != null) {
            return ele.getImportedElement().accept(this.cloneWithCurrentClass(WorkflowContainer.class));
        }
        this.issues.addError("Cartridge " + ele.getFile() + " not resolved!", ele);
        return Object.class;
    }
}

