/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.common.ui.services.dnd.drop;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.DragDropListenerService;
import org.eclipse.gmf.runtime.common.ui.services.dnd.core.ITransferAgent;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.DropTargetEvent;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetContext;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.IDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.drop.ITransferDropTargetListener;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDDebugOptions;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.CommonUIServicesDNDPlugin;
import org.eclipse.gmf.runtime.common.ui.services.dnd.internal.core.DropListenerContext;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;

public class TransferDropTargetAdapter
implements ITransferDropTargetListener {
    private IDropTargetListener listener;
    private final ITransferAgent transferAgent;
    private IDropTargetContext context;
    private final DropTargetEvent currentEvent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.runtime.common.ui.services.dnd.drop.TransferDropTargetAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TransferDropTargetAdapter(ITransferAgent aTransferAgent) {
        if (!$assertionsDisabled && aTransferAgent == null) {
            throw new AssertionError((Object)"aTransferAgent cannot be null");
        }
        this.listener = null;
        this.transferAgent = aTransferAgent;
        this.context = null;
        this.currentEvent = new DropTargetEvent();
    }

    public void dragEnter(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.setFeedback(event);
            this.listener.dragEnter(event);
        }
    }

    public void dragLeave(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.dragLeave(event);
        }
        this.listener = null;
    }

    public void dragOperationChanged(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.dragOperationChanged(event);
        }
    }

    public void dragOver(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.setFeedback(event);
            this.listener.dragOver(event);
        }
    }

    public final void drop(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.drop(event);
        }
        this.listener = null;
    }

    public void dropAccept(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (this.listener != null) {
            this.listener.dropAccept(event);
        }
    }

    protected final IDropTargetListener getListener() {
        return this.listener;
    }

    protected final IDropTargetContext getContext() {
        return this.context;
    }

    public final void init(IDropTargetContext initialContext) {
        if (!$assertionsDisabled && initialContext == null) {
            throw new AssertionError((Object)"initialContext cannot be null");
        }
        this.context = initialContext;
    }

    public final ITransferAgent getTransferAgent() {
        return this.transferAgent;
    }

    public boolean canSupport(org.eclipse.swt.dnd.DropTargetEvent event) {
        if (Trace.shouldTrace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND)) {
            Trace.trace((Plugin)CommonUIServicesDNDPlugin.getDefault(), (String)CommonUIServicesDNDDebugOptions.DND, (String)("canSupport::Adapter is " + this.getClass().getName()));
        }
        return this.canSupportTransferData(event) && this.isSupportingListenerAvailable();
    }

    protected final boolean isSupportingListenerAvailable() {
        IDropTargetListener[] listeners = this.getListeners(false);
        if (listeners == null || listeners.length == 0) {
            listeners = this.getListeners(true);
        }
        if (listeners != null) {
            CommonUIServicesDNDPlugin plugin = CommonUIServicesDNDPlugin.getDefault();
            boolean shouldTrace = Trace.shouldTrace((Plugin)plugin, (String)CommonUIServicesDNDDebugOptions.DND);
            int i = 0;
            while (i < listeners.length) {
                try {
                    this.listener = listeners[i];
                    if (this.listener.canSupport(this.context, this.currentEvent, this.transferAgent)) {
                        if (shouldTrace) {
                            Trace.trace((Plugin)plugin, (String)CommonUIServicesDNDDebugOptions.DND, (String)("isSupportingListenerAvailable::Chosen listener is " + this.listener.getClass().getName()));
                        }
                        return true;
                    }
                }
                catch (RuntimeException e) {
                    if (shouldTrace) {
                        Trace.catching((Plugin)plugin, (String)CommonUIServicesDNDDebugOptions.DND, this.getClass(), (String)"isSupportingListenerAvailable", (Throwable)e);
                    }
                    Log.warning((Plugin)plugin, (int)4, (String)("Drop Listener " + listeners[i].getClass().getName()), (Throwable)e);
                }
                ++i;
            }
        }
        this.listener = null;
        return false;
    }

    protected final boolean canSupportTransferData(org.eclipse.swt.dnd.DropTargetEvent event) {
        this.currentEvent.setEvent(event);
        Transfer transfer = this.transferAgent.getTransfer();
        int i = 0;
        while (i < event.dataTypes.length) {
            TransferData dataType = event.dataTypes[i];
            if (transfer.isSupportedType(dataType)) {
                event.currentDataType = dataType;
                return true;
            }
            ++i;
        }
        return false;
    }

    private final IDropTargetListener[] getListeners(boolean isCompatible) {
        IDropTargetListener[] listeners = DragDropListenerService.getInstance().getDropTargetListeners(new DropListenerContext(this.context.getActivePart(), this.context.getCurrentTarget().getClass(), this.transferAgent.getTransferId(), isCompatible));
        return listeners;
    }
}

