/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editparts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gef.requests.TargetRequest;
import org.eclipse.gmf.runtime.common.core.util.IAdaptableSelection;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.services.action.filter.ActionFilterService;
import org.eclipse.gmf.runtime.diagram.core.listener.DiagramEventBroker;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IDiagramPreferenceSupport;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.TopGraphicEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DecorationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PropertyHandlerEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.ToggleCanonicalModeCommand;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DummyEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.IEditableEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.services.editpolicy.EditPolicyService;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.gmf.runtime.diagram.ui.util.EditPartUtil;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public abstract class GraphicalEditPart
extends AbstractGraphicalEditPart
implements IGraphicalEditPart,
IAdaptableSelection,
NotificationListener {
    private Map listenerFilters;
    protected AccessibleEditPart accessibleEP;
    protected String elementGuid;
    private boolean isEditable = true;
    private TransactionalEditingDomain editingDomain;
    private FontData cachedFontData;
    private static volatile int GETCOMMAND_RECURSIVE_COUNT = 0;
    private static Set _disableCanonicalEditPolicyList = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public GraphicalEditPart(EObject model) {
        this.setModel(model);
    }

    public void activate() {
        EObject semanticProxy;
        if (this.isActive()) {
            return;
        }
        this.addNotationalListeners();
        Object semanticElement = this.hasNotationView() ? ((semanticProxy = ((View)super.getModel()).getElement()) == null || semanticProxy.eIsProxy() ? null : semanticProxy) : ((semanticProxy = (EObject)this.basicGetModel()) != null && semanticProxy.eIsProxy() ? EMFCoreUtil.resolve((TransactionalEditingDomain)this.getEditingDomain(), (EObject)semanticProxy) : semanticProxy);
        if (semanticElement != null) {
            this.addSemanticListeners();
        } else if (semanticProxy != null) {
            this.addListenerFilter("SemanticProxy", this, semanticProxy);
        }
        GraphicalEditPart.super.activate();
    }

    protected void addListenerFilter(String filterId, NotificationListener listener, EObject element) {
        if (element == null) {
            return;
        }
        DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
        if (diagramEventBroker != null) {
            Assert.isNotNull((Object)filterId);
            Assert.isNotNull((Object)listener);
            if (this.listenerFilters == null) {
                this.listenerFilters = new HashMap();
            }
            diagramEventBroker.addNotificationListener(element, listener);
            this.listenerFilters.put(filterId.intern(), new Object[]{element, listener});
        }
    }

    protected void addListenerFilter(String filterId, NotificationListener listener, EObject element, EStructuralFeature feature) {
        if (element == null) {
            return;
        }
        DiagramEventBroker diagramEventBroker = this.getDiagramEventBroker();
        if (diagramEventBroker != null) {
            Assert.isNotNull((Object)filterId);
            Assert.isNotNull((Object)listener);
            if (this.listenerFilters == null) {
                this.listenerFilters = new HashMap();
            }
            diagramEventBroker.addNotificationListener(element, feature, listener);
            this.listenerFilters.put(filterId.intern(), new Object[]{element, feature, listener});
        }
    }

    protected final org.eclipse.gef.ConnectionEditPart createConnection(Object connectionView) {
        return (org.eclipse.gef.ConnectionEditPart)this.createChild(connectionView);
    }

    protected final void createEditPolicies() {
        this.createDefaultEditPolicies();
        EditPolicyService.getInstance().createEditPolicies((EditPart)this);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SemanticEditPolicy());
        this.installEditPolicy("PropertyHandlerPolicy", (EditPolicy)new PropertyHandlerEditPolicy());
        this.installEditPolicy("DecorationPolicy", (EditPolicy)new DecorationEditPolicy());
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeNotationalListeners();
        this.removeSemanticListeners();
        if (this.listenerFilters != null) {
            Iterator i = this.listenerFilters.keySet().iterator();
            while (i.hasNext()) {
                Object[] obj = (Object[])this.listenerFilters.get(i.next());
                if (obj.length > 2) {
                    this.getDiagramEventBroker().removeNotificationListener((EObject)obj[0], (Object)((EStructuralFeature)obj[1]), (NotificationListener)obj[2]);
                    continue;
                }
                this.getDiagramEventBroker().removeNotificationListener((EObject)obj[0], (NotificationListener)obj[1]);
            }
        }
        super.deactivate();
    }

    public void removeNotify() {
        super.removeNotify();
        if (this.cachedFontData != null) {
            this.getResourceManager().destroyFont(FontDescriptor.createFrom((FontData)this.cachedFontData));
            this.cachedFontData = null;
        }
    }

    protected void executeCommand(Command command) {
        this.getViewer().getEditDomain().getCommandStack().execute(command);
    }

    protected final Object basicGetModel() {
        return super.getModel();
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.IActionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return ActionFilterService.getInstance();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(key)) {
            Object _model = this.getModel();
            if (key.isInstance(_model)) {
                return _model;
            }
            return null;
        }
        Object model = this.basicGetModel();
        if (model != null) {
            Class<?> clazz3 = class$2;
            if (clazz3 == null) {
                try {
                    clazz3 = class$2 = Class.forName("org.eclipse.emf.ecore.EObject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz3.isAssignableFrom(key)) {
                EObject semanticObject = null;
                if (this.hasNotationView()) {
                    semanticObject = ViewUtil.resolveSemanticElement((View)((View)model));
                } else {
                    EObject element = (EObject)model;
                    if (element.eIsProxy()) {
                        semanticObject = EMFCoreUtil.resolve((TransactionalEditingDomain)this.getEditingDomain(), (EObject)element);
                    }
                }
                if (semanticObject != null && key.isInstance(semanticObject)) {
                    return semanticObject;
                }
                if (key.isInstance(model)) {
                    return model;
                }
            }
        }
        return super.getAdapter(key);
    }

    public IGraphicalEditPart getChildBySemanticHintOnPrimaryView(String semanticHint) {
        View primaryView = this.getPrimaryView();
        View childView = ViewUtil.getChildBySemanticHint((View)primaryView, (String)semanticHint);
        if (childView != null) {
            return (IGraphicalEditPart)this.getViewer().getEditPartRegistry().get(childView);
        }
        return null;
    }

    public IGraphicalEditPart getChildBySemanticHint(String semanticHint) {
        View view;
        if (this.hasNotationView() && (view = (View)super.getModel()) != null && (view = ViewUtil.getChildBySemanticHint((View)view, (String)semanticHint)) != null) {
            IGraphicalEditPart ep = (IGraphicalEditPart)this.getViewer().getEditPartRegistry().get(view);
            if (ep == null) {
                ep = new DummyEditPart((EObject)view);
            }
            return ep;
        }
        return null;
    }

    public View getChildViewBySemanticHint(String semanticHint) {
        View view;
        if (this.hasNotationView() && (view = (View)super.getModel()) != null) {
            return ViewUtil.getChildBySemanticHint((View)view, (String)semanticHint);
        }
        return null;
    }

    public Command getCommand(Request _request) {
        if (!this.isEditModeEnabled() && !"open".equals(_request.getType())) {
            return UnexecutableCommand.INSTANCE;
        }
        Command cmd = null;
        try {
            ++GETCOMMAND_RECURSIVE_COUNT;
            final Request request = _request;
            try {
                cmd = (Command)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                    public void run() {
                        this.setResult(GraphicalEditPart.super.getCommand(request));
                    }
                });
            }
            catch (InterruptedException e) {
                Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"getCommand", (Throwable)e);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"getCommand", (Throwable)e);
            }
            if (cmd != null) {
                _disableCanonicalEditPolicyList.addAll(this.disableCanonicalFor(_request));
            }
            if (--GETCOMMAND_RECURSIVE_COUNT == 0 && cmd != null && !_disableCanonicalEditPolicyList.isEmpty()) {
                CompoundCommand cc = new CompoundCommand();
                cc.setLabel(cmd.getLabel());
                ToggleCanonicalModeCommand tcmd = ToggleCanonicalModeCommand.getToggleCanonicalModeCommand(_disableCanonicalEditPolicyList, false);
                cc.add((Command)tcmd);
                cc.add(cmd);
                ToggleCanonicalModeCommand tcmd2 = ToggleCanonicalModeCommand.getToggleCanonicalModeCommand(tcmd, true);
                if (tcmd2 != null) {
                    tcmd2.setDomain(this.getEditingDomain());
                }
                cc.add((Command)tcmd2);
                _disableCanonicalEditPolicyList.clear();
                return cc.unwrap();
            }
        }
        catch (RuntimeException t) {
            GETCOMMAND_RECURSIVE_COUNT = 0;
            throw t;
        }
        return cmd;
    }

    Collection disableCanonicalFor(Request request) {
        CreateConnectionRequest ccvr;
        HashSet<GraphicalEditPart> hosts = new HashSet<GraphicalEditPart>();
        if (request instanceof EditCommandRequestWrapper || request instanceof TargetRequest || request instanceof DropRequest) {
            hosts.add(this);
            hosts.add((GraphicalEditPart)this.getParent());
        }
        if (request instanceof ReconnectRequest) {
            ReconnectRequest reconnect = (ReconnectRequest)request;
            hosts.add(this);
            hosts.add((GraphicalEditPart)this.getParent());
            if (reconnect.getTarget() != null) {
                EditPart target = reconnect.getTarget();
                this.addEditPartAndParent(hosts, target);
            }
            if (reconnect.getConnectionEditPart() != null) {
                org.eclipse.gef.ConnectionEditPart connectionEditPart = reconnect.getConnectionEditPart();
                if (connectionEditPart.getSource() != null) {
                    EditPart srcEP = connectionEditPart.getSource();
                    this.addEditPartAndParent(hosts, srcEP);
                }
                if (connectionEditPart.getTarget() != null) {
                    EditPart trgEP = connectionEditPart.getTarget();
                    this.addEditPartAndParent(hosts, trgEP);
                }
            }
        }
        if (request instanceof CreateConnectionRequest) {
            ccvr = (CreateConnectionRequest)request;
            hosts.add(this);
            hosts.add((GraphicalEditPart)this.getParent());
            if (ccvr.getSourceEditPart() != null) {
                hosts.add((GraphicalEditPart)ccvr.getSourceEditPart());
                hosts.add((GraphicalEditPart)ccvr.getSourceEditPart().getParent());
            }
            if (ccvr.getTargetEditPart() != null) {
                hosts.add((GraphicalEditPart)ccvr.getTargetEditPart());
                hosts.add((GraphicalEditPart)ccvr.getTargetEditPart().getParent());
            }
        }
        if (request instanceof GroupRequest) {
            List parts = ((GroupRequest)request).getEditParts();
            hosts.add(this);
            hosts.add((GraphicalEditPart)this.getParent());
            Iterator editparts = parts == null ? Collections.EMPTY_LIST.iterator() : parts.iterator();
            while (editparts.hasNext()) {
                EditPart ep = (EditPart)editparts.next();
                this.addEditPartAndParent(hosts, ep);
            }
        }
        if (this instanceof IBorderItemEditPart && request instanceof CreateConnectionViewRequest) {
            ccvr = (CreateConnectionViewRequest)request;
            if (ccvr.getSourceEditPart() instanceof IBorderItemEditPart) {
                hosts.add((GraphicalEditPart)ccvr.getSourceEditPart().getParent().getParent());
            }
            if (ccvr.getTargetEditPart() instanceof IBorderItemEditPart) {
                hosts.add((GraphicalEditPart)ccvr.getTargetEditPart().getParent().getParent());
            }
        }
        return hosts;
    }

    private void addEditPartAndParent(Set hosts, EditPart editPart) {
        hosts.add(editPart);
        hosts.add(editPart.getParent());
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        return this.getContentPane();
    }

    protected Diagram getDiagramView() {
        return (Diagram)this.getRoot().getContents().getModel();
    }

    public final View getPrimaryView() {
        GraphicalEditPart parent = this;
        while (parent != null) {
            if (parent instanceof IPrimaryEditPart && parent.getModel() instanceof View) {
                return (View)parent.getModel();
            }
            parent = parent.getParent();
        }
        return null;
    }

    protected EditDomain getEditDomain() {
        EditDomain result = null;
        try {
            result = this.getRoot().getViewer().getEditDomain();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        return result;
    }

    public IDiagramEditDomain getDiagramEditDomain() {
        return (IDiagramEditDomain)this.getEditDomain();
    }

    protected List getModelChildren() {
        Object model = this.getModel();
        if (model != null && model instanceof View) {
            return new ArrayList(((View)model).getVisibleChildren());
        }
        return Collections.EMPTY_LIST;
    }

    public Object getStructuralFeatureValue(EStructuralFeature feature) {
        if (this.hasNotationView()) {
            return ViewUtil.getPropertyValue((View)((View)super.getModel()), (EStructuralFeature)feature, (EClass)feature.getEContainingClass());
        }
        return null;
    }

    public EObject resolveSemanticElement() {
        EObject semanticElement = null;
        Object basicModel = this.basicGetModel();
        if (this.hasNotationView()) {
            semanticElement = ((View)basicModel).getElement();
        } else if (basicModel instanceof EObject) {
            semanticElement = (EObject)basicModel;
        }
        if (semanticElement == null) {
            return null;
        }
        if (!semanticElement.eIsProxy()) {
            return semanticElement;
        }
        try {
            return (EObject)this.getEditingDomain().runExclusive((Runnable)new RunnableWithResult.Impl(){

                public void run() {
                    Object model = GraphicalEditPart.this.getModel();
                    if (model instanceof View) {
                        this.setResult(ViewUtil.resolveSemanticElement((View)((View)GraphicalEditPart.this.getModel())));
                    } else if (model instanceof EObject) {
                        EObject element = (EObject)model;
                        if (element.eIsProxy()) {
                            this.setResult(EMFCoreUtil.resolve((TransactionalEditingDomain)GraphicalEditPart.this.getEditingDomain(), (EObject)element));
                        } else {
                            this.setResult(element);
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"resolveSemanticElement", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"resolveSemanticElement", (Throwable)e);
            return null;
        }
    }

    public TopGraphicEditPart getTopGraphicEditPart() {
        GraphicalEditPart editPart = this;
        while (editPart instanceof IGraphicalEditPart) {
            if (editPart instanceof TopGraphicEditPart) {
                return (TopGraphicEditPart)editPart;
            }
            editPart = editPart.getParent();
        }
        return null;
    }

    public View getNotationView() {
        Object model = this.getModel();
        if (model instanceof View) {
            return (View)model;
        }
        return null;
    }

    protected void reactivateSemanticModel() {
        this.removeSemanticListeners();
        if (this.resolveSemanticElement() != null) {
            this.addSemanticListeners();
        }
    }

    public EditPart findEditPart(EditPart epBegin, EObject theElement) {
        EObject el;
        View view;
        if (theElement == null) {
            return null;
        }
        GraphicalEditPart epStart = null;
        epStart = epBegin == null ? this : epBegin;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.runtime.notation.View");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((view = (View)epStart.getAdapter(clazz)) != null && (el = ViewUtil.resolveSemanticElement((View)view)) != null && el.equals(theElement)) {
            return epStart;
        }
        ListIterator childLI = epStart.getChildren().listIterator();
        while (childLI.hasNext()) {
            EditPart epChild = (EditPart)childLI.next();
            EditPart elementEP = this.findEditPart(epChild, theElement);
            if (elementEP == null) continue;
            return elementEP;
        }
        return null;
    }

    public void refresh() {
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                public void run() {
                    AbstractEditPart.EditPolicyIterator i = GraphicalEditPart.this.getEditPolicyIterator();
                    while (i.hasNext()) {
                        EditPolicy policy = i.next();
                        if (!(policy instanceof GraphicalEditPolicyEx)) continue;
                        ((GraphicalEditPolicyEx)policy).refresh();
                    }
                    GraphicalEditPart.super.refresh();
                }
            });
        }
        catch (InterruptedException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"refresh", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"refresh", (Throwable)e);
        }
    }

    protected void refreshBackgroundColor() {
        FillStyle style = (FillStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
        if (style != null) {
            this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFillColor())));
        }
    }

    protected void refreshFont() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            this.setFont(new FontData(style.getFontName(), style.getFontHeight(), (style.isBold() ? 1 : 0) | (style.isItalic() ? 2 : 0)));
        }
    }

    protected void refreshFontColor() {
        FontStyle style = (FontStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.FONT_STYLE);
        if (style != null) {
            this.setFontColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFontColor())));
        }
    }

    protected void refreshForegroundColor() {
        LineStyle style = (LineStyle)this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
        if (style != null) {
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getLineColor())));
        }
    }

    protected void refreshVisibility() {
        Object model = null;
        GraphicalEditPart ep = this;
        while (!(model instanceof View) && ep != null) {
            model = ep.getModel();
            ep = ep.getParent();
        }
        if (model instanceof View) {
            this.setVisibility(((View)model).isVisible());
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshVisibility();
    }

    protected void removeListenerFilter(String filterId) {
        if (this.listenerFilters == null) {
            return;
        }
        Object[] objects = (Object[])this.listenerFilters.remove(filterId);
        if (objects == null) {
            return;
        }
        if (objects.length > 2) {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (Object)((EStructuralFeature)objects[1]), (NotificationListener)objects[2]);
        } else {
            this.getDiagramEventBroker().removeNotificationListener((EObject)objects[0], (NotificationListener)objects[1]);
        }
    }

    protected void setBackgroundColor(Color color) {
        this.getFigure().setBackgroundColor(color);
    }

    protected void setFont(FontData fontData) {
        if (this.cachedFontData != null && this.cachedFontData.equals((Object)fontData)) {
            return;
        }
        try {
            Font newFont = this.getResourceManager().createFont(FontDescriptor.createFrom((FontData)fontData));
            this.getFigure().setFont(newFont);
            this.getFigure().repaint();
            if (this.cachedFontData != null) {
                this.getResourceManager().destroyFont(FontDescriptor.createFrom((FontData)this.cachedFontData));
            }
            this.cachedFontData = fontData;
        }
        catch (DeviceResourceException e) {
            Trace.catching((Plugin)DiagramUIPlugin.getInstance(), (String)DiagramUIDebugOptions.EXCEPTIONS_CATCHING, this.getClass(), (String)"setFont", (Throwable)e);
            Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)9, (String)"setFont", (Throwable)e);
        }
    }

    protected void setFontColor(Color color) {
    }

    protected void setForegroundColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    public void setStructuralFeatureValue(EStructuralFeature feature, Object value) {
        if (this.hasNotationView() && feature != null) {
            ViewUtil.setPropertyValue((View)((View)super.getModel()), (EStructuralFeature)feature, (EClass)feature.getEContainingClass(), (Object)value);
        }
    }

    protected void setVisibility(boolean vis) {
        if (!vis && this.getSelected() != 0) {
            this.getViewer().deselect((EditPart)this);
        }
        this.getFigure().setVisible(vis);
        this.getFigure().revalidate();
    }

    protected void addNotationalListeners() {
        if (this.hasNotationView()) {
            this.addListenerFilter("View", this, (EObject)((View)this.getModel()));
        }
    }

    protected void addSemanticListeners() {
        this.addListenerFilter("SemanticElement", this, this.resolveSemanticElement());
    }

    protected void removeNotationalListeners() {
        this.removeListenerFilter("View");
    }

    protected void removeSemanticListeners() {
        this.removeListenerFilter("SemanticElement");
    }

    public void performRequest(Request request) {
        if (!this.isEditModeEnabled() && !"open".equals(request.getType())) {
            return;
        }
        if ("direct edit" == request.getType()) {
            this.performDirectEditRequest(request);
        } else {
            Command command;
            EditPart targetEditPart = this.getTargetEditPart(request);
            if (targetEditPart != null && (command = targetEditPart.getCommand(request)) != null) {
                this.getDiagramEditDomain().getDiagramCommandStack().execute(command);
                return;
            }
        }
    }

    protected void performDirectEditRequest(Request request) {
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accessibleEP == null) {
            this.accessibleEP = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

                private String getSemanticName() {
                    EObject semanticElement = GraphicalEditPart.this.resolveSemanticElement();
                    if (semanticElement != null) {
                        String name = semanticElement.getClass().getName();
                        int startIndex = name.lastIndexOf(46) + 1;
                        int endIndex = name.lastIndexOf("Impl");
                        return name.substring(startIndex, endIndex);
                    }
                    return null;
                }

                public void getName(AccessibleEvent e) {
                    IGraphicalEditPart childEP = GraphicalEditPart.this.getChildBySemanticHint("Name");
                    if (childEP == null) {
                        childEP = GraphicalEditPart.this.getChildBySemanticHint("Description");
                    }
                    if (childEP != null) {
                        IFigure fig = childEP.getFigure();
                        if (fig instanceof WrapLabel) {
                            e.result = ((WrapLabel)fig).getText();
                        }
                    } else {
                        e.result = this.getSemanticName();
                    }
                }
            };
        }
        return this.accessibleEP;
    }

    protected void registerModel() {
        EditPartViewer viewer = this.getViewer();
        if (this.hasNotationView()) {
            super.registerModel();
        } else {
            viewer.getEditPartRegistry().put(this.basicGetModel(), this);
        }
        EObject ref = null;
        ref = this.hasNotationView() ? this.getNotationView().getElement() : (EObject)this.basicGetModel();
        if (ref == null) {
            return;
        }
        this.elementGuid = EMFCoreUtil.getProxyID((EObject)ref);
        ((IDiagramGraphicalViewer)viewer).registerEditPartForElement(this.elementGuid, (EditPart)this);
    }

    protected void unregisterModel() {
        EditPartViewer viewer = this.getViewer();
        if (this.hasNotationView()) {
            super.unregisterModel();
        } else {
            Map registry = viewer.getEditPartRegistry();
            if (registry.get(this.basicGetModel()) == this) {
                registry.remove(this.basicGetModel());
            }
        }
        if (this.elementGuid == null) {
            return;
        }
        ((IDiagramGraphicalViewer)viewer).unregisterEditPartForElement(this.elementGuid, (EditPart)this);
    }

    protected final void refreshChild(GraphicalEditPart child) {
        this.removeChild((EditPart)child);
        this.refreshChildren();
    }

    protected final void refreshSourceConnection(ConnectionEditPart conn) {
        this.removeSourceConnection((org.eclipse.gef.ConnectionEditPart)conn);
        this.refreshSourceConnections();
    }

    protected final void refreshTargetConnection(ConnectionEditPart conn) {
        this.removeTargetConnection((org.eclipse.gef.ConnectionEditPart)conn);
        this.refreshTargetConnections();
    }

    protected final void handleMajorSemanticChange() {
        if (this.getParent() instanceof GraphicalEditPart) {
            ((GraphicalEditPart)this.getParent()).refreshChild(this);
        } else if (this.getParent() instanceof ConnectionEditPart) {
            ((ConnectionEditPart)this.getParent()).refreshChild(this);
        }
    }

    public DragTracker getDragTracker(Request request) {
        return new DragEditPartsTrackerEx((EditPart)this);
    }

    public boolean isCanonical() {
        CanonicalEditPolicy policy = (CanonicalEditPolicy)this.getEditPolicy("Canonical");
        return policy == null ? false : policy.isActive();
    }

    public boolean isSelectable() {
        return this.getFigure().isShowing();
    }

    public void disableEditMode() {
        if (!this.isEditModeEnabled()) {
            return;
        }
        List l = this.getSourceConnections();
        int size = l.size();
        int i = 0;
        while (i < size) {
            Object obj = l.get(i);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).disableEditMode();
            }
            ++i;
        }
        List c = this.getChildren();
        size = c.size();
        int i2 = 0;
        while (i2 < size) {
            Object obj = c.get(i2);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).disableEditMode();
            }
            ++i2;
        }
        this.isEditable = false;
    }

    protected void addChild(EditPart child, int index) {
        super.addChild(child, index);
        if (child instanceof GraphicalEditPart) {
            GraphicalEditPart gEP = (GraphicalEditPart)child;
            boolean editMode = this.isEditModeEnabled();
            if (editMode != gEP.isEditModeEnabled()) {
                if (editMode) {
                    gEP.enableEditMode();
                } else {
                    gEP.disableEditMode();
                }
            }
        }
    }

    public void enableEditMode() {
        if (this.isEditModeEnabled()) {
            return;
        }
        this.isEditable = true;
        List c = this.getChildren();
        int size = c.size();
        int i = 0;
        while (i < size) {
            Object obj = c.get(i);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).enableEditMode();
            }
            ++i;
        }
        List l = this.getSourceConnections();
        size = l.size();
        int i2 = 0;
        while (i2 < size) {
            Object obj = l.get(i2);
            if (obj instanceof IEditableEditPart) {
                ((IEditableEditPart)obj).enableEditMode();
            }
            ++i2;
        }
    }

    public boolean isEditModeEnabled() {
        if (EditPartUtil.isWriteTransactionInProgress(this, true, true)) {
            return false;
        }
        return this.isEditable;
    }

    public void showSourceFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.showSourceFeedback(request);
    }

    public void showTargetFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.showTargetFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.eraseSourceFeedback(request);
    }

    public void eraseTargetFeedback(Request request) {
        if (!this.isEditModeEnabled()) {
            return;
        }
        super.eraseTargetFeedback(request);
    }

    public EditPart getPrimaryChildEditPart() {
        if (this.getChildren().size() > 0) {
            return (EditPart)this.getChildren().get(0);
        }
        return null;
    }

    public PreferencesHint getDiagramPreferencesHint() {
        RootEditPart root = this.getRoot();
        if (root instanceof IDiagramPreferenceSupport) {
            return ((IDiagramPreferenceSupport)root).getPreferencesHint();
        }
        return PreferencesHint.USE_DEFAULTS;
    }

    public void notifyChanged(Notification notification) {
        if (this.isActive()) {
            this.handleNotificationEvent(notification);
        }
    }

    public Command transactionAboutToCommit(Notification notification) {
        return null;
    }

    protected void handleNotificationEvent(Notification event) {
        if (NotationPackage.Literals.VIEW__PERSISTED_CHILDREN.equals(event.getFeature()) || NotationPackage.Literals.VIEW__TRANSIENT_CHILDREN.equals(event.getFeature())) {
            this.refreshChildren();
        } else if (NotationPackage.Literals.VIEW__VISIBLE.equals(event.getFeature())) {
            Object notifier = event.getNotifier();
            if (notifier == this.getModel()) {
                this.refreshVisibility();
            } else {
                this.refreshChildren();
            }
        } else if (NotationPackage.Literals.VIEW__ELEMENT.equals(event.getFeature())) {
            this.handleMajorSemanticChange();
        }
    }

    protected IMapMode getMapMode() {
        RootEditPart root = this.getRoot();
        if (root instanceof DiagramRootEditPart) {
            DiagramRootEditPart dgrmRoot = (DiagramRootEditPart)root;
            return dgrmRoot.getMapMode();
        }
        return MapModeUtil.getMapMode();
    }

    public boolean hasNotationView() {
        return true;
    }

    public Object getModel() {
        if (this.hasNotationView()) {
            return super.getModel();
        }
        Object _model = this.basicGetModel();
        Node node = NotationFactory.eINSTANCE.createNode();
        node.setElement((EObject)_model);
        return node;
    }

    public TransactionalEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = TransactionUtil.getEditingDomain((Object)this.getModel());
            if (this.editingDomain == null) {
                this.editingDomain = TransactionUtil.getEditingDomain((EObject)this.getDiagramView());
            }
        }
        return this.editingDomain;
    }

    protected IFigure createFigure() {
        return null;
    }

    public void setModel(Object model) {
        this.editingDomain = null;
        super.setModel(model);
    }

    private DiagramEventBroker getDiagramEventBroker() {
        TransactionalEditingDomain theEditingDomain = this.getEditingDomain();
        if (theEditingDomain != null) {
            return DiagramEventBroker.getInstance((TransactionalEditingDomain)theEditingDomain);
        }
        return null;
    }

    public RootEditPart getRoot() {
        if (this.getParent() != null) {
            return super.getRoot();
        }
        return null;
    }

    public Object getPreferredValue(EStructuralFeature feature) {
        Object preferenceStore = this.getDiagramPreferencesHint().getPreferenceStore();
        if (preferenceStore instanceof IPreferenceStore) {
            if (feature == NotationPackage.eINSTANCE.getLineStyle_LineColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.lineColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFontStyle_FontColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.fontColor"));
            }
            if (feature == NotationPackage.eINSTANCE.getFillStyle_FillColor()) {
                return FigureUtilities.RGBToInteger((RGB)PreferenceConverter.getColor((IPreferenceStore)((IPreferenceStore)preferenceStore), (String)"Appearance.fillColor"));
            }
        }
        return this.getStructuralFeatureValue(feature);
    }

    protected ResourceManager getResourceManager() {
        EditPartViewer viewer = this.getViewer();
        if (viewer instanceof DiagramGraphicalViewer) {
            return ((DiagramGraphicalViewer)viewer).getResourceManager();
        }
        return JFaceResources.getResources();
    }
}

