/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.diagram.ui.commands;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandUtilities;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;

public class CommandUtilitiesTest
extends TestCase {
    public CommandUtilitiesTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CommandUtilitiesTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CommandUtilitiesTest.class, "CommandUtilities tests");
    }

    public void test_getAffectedFiles_nullCommand_161668() {
        Collection affectedFiles = CommandUtilities.getAffectedFiles(null);
        CommandUtilitiesTest.assertTrue((boolean)affectedFiles.isEmpty());
    }

    public void test_getAffectedFiles_ICommand_161668() {
        List files = this.getFiles("CommandUtilitiesTest/test_getAffectedFiles_ICommand_161668");
        CommandImplementingICommand command = new CommandImplementingICommand(files);
        Collection affectedFiles = CommandUtilities.getAffectedFiles((Command)command);
        CommandUtilitiesTest.assertEquals((Object)files, (Object)affectedFiles);
    }

    public void test_getAffectedFiles_ICommandProxy_161668() {
        List files = this.getFiles("CommandUtilitiesTest/test_getAffectedFiles_ICommandProxy_161668");
        AbstractCommand iCommand = new AbstractCommand("test_getAffectedFiles_ICommandProxy_161668()", files){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }
        };
        ICommandProxy commandProxy = new ICommandProxy((ICommand)iCommand);
        Collection affectedFiles = CommandUtilities.getAffectedFiles((Command)commandProxy);
        CommandUtilitiesTest.assertEquals((Object)files, (Object)affectedFiles);
    }

    public void test_getAffectedFiles_CompoundCommand_161668() {
        List iCommandFiles = this.getFiles("CommandUtilitiesTest/getAffectedFiles_CompoundCommand_161668_ICommand");
        CommandImplementingICommand iCommand = new CommandImplementingICommand(iCommandFiles);
        List iCommandProxyFiles = this.getFiles("CommandUtilitiesTest/getAffectedFiles_CompoundCommand_161668_ICommandProxy");
        ICommandProxy iCommandProxy = new ICommandProxy((ICommand)new AbstractCommand("test_getAffectedFiles_ICommandProxy_161668()", iCommandProxyFiles){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }

            protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }

            protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                return CommandResult.newOKCommandResult();
            }
        });
        CompoundCommand command = new CompoundCommand("getAffectedFiles_CompoundCommand_161668");
        command.add((Command)iCommand);
        command.add((Command)iCommandProxy);
        Collection affectedFiles = CommandUtilities.getAffectedFiles((Command)command);
        CommandUtilitiesTest.assertEquals((int)(iCommandFiles.size() + iCommandProxyFiles.size()), (int)affectedFiles.size());
        CommandUtilitiesTest.assertTrue((boolean)affectedFiles.containsAll(iCommandFiles));
        CommandUtilitiesTest.assertTrue((boolean)affectedFiles.containsAll(iCommandProxyFiles));
    }

    private List getFiles(String path) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IFile file = workspaceRoot.getFile((IPath)new Path(path));
        return Collections.singletonList(file);
    }

    private class CommandImplementingICommand
    extends Command
    implements ICommand {
        private List affectedFiles;
        private ICommand delegate;

        public CommandImplementingICommand(List affectedFiles) {
            this.affectedFiles = affectedFiles;
        }

        protected ICommand getDelegate() {
            if (this.delegate == null) {
                this.delegate = new AbstractCommand("CommandImplementingICommand", this.affectedFiles){

                    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        return CommandResult.newOKCommandResult();
                    }

                    protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        return CommandResult.newOKCommandResult();
                    }

                    protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                        return CommandResult.newOKCommandResult();
                    }
                };
            }
            return this.delegate;
        }

        public ICommand compose(IUndoableOperation operation) {
            return this.getDelegate().compose(operation);
        }

        public List getAffectedFiles() {
            return this.getDelegate().getAffectedFiles();
        }

        public CommandResult getCommandResult() {
            return this.getDelegate().getCommandResult();
        }

        public ICommand reduce() {
            return this.getDelegate().reduce();
        }

        public void addContext(IUndoContext context) {
            this.getDelegate().addContext(context);
        }

        public boolean canRedo() {
            return this.getDelegate().canRedo();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.getDelegate().execute(monitor, info);
        }

        public IUndoContext[] getContexts() {
            return this.getDelegate().getContexts();
        }

        public boolean hasContext(IUndoContext context) {
            return this.getDelegate().hasContext(context);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.getDelegate().redo(monitor, info);
        }

        public void removeContext(IUndoContext context) {
            this.getDelegate().removeContext(context);
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.getDelegate().undo(monitor, info);
        }
    }
}

