/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.handles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;

public class ConnectionHandleLocator
implements Locator {
    private static int HANDLE_SPACING = 20;
    private static int MARGIN = 2;
    private static Dimension HANDLE_MARGIN = new Dimension(25, 25);
    private List<ConnectionHandle> handles = new ArrayList<ConnectionHandle>();
    private Point cursorPosition = null;
    private IFigure reference = null;
    private int side = 8;
    private Point borderPoint = new Point(0, 0);
    private boolean bEastWestSouth = false;

    public ConnectionHandleLocator(IFigure reference, Point cursorPosition) {
        this.reference = reference;
        this.cursorPosition = cursorPosition;
    }

    public void addHandle(ConnectionHandle handle) {
        this.handles.add(handle);
    }

    private Rectangle getViewportArea() {
        IFigure fig = this.getReference();
        while (fig != null) {
            if (fig instanceof Viewport) {
                return fig.getClientArea();
            }
            fig = fig.getParent();
        }
        return new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    private void resetBorderPointAndSide() {
        boolean bUp;
        Rectangle bounds = this.getReferenceFigureBounds();
        int westDiff = this.cursorPosition.x - bounds.x;
        int eastDiff = bounds.getRight().x - this.cursorPosition.x;
        int southDiff = bounds.getBottom().y - this.cursorPosition.y;
        int northDiff = this.isEastWestSouth() ? Integer.MAX_VALUE : this.cursorPosition.y - bounds.y;
        Rectangle viewportRect = this.getViewportArea();
        Rectangle absBounds = bounds.getCopy();
        this.getReference().translateToAbsolute((Translatable)absBounds);
        absBounds.translate(viewportRect.getLocation());
        Dimension handleMargin = this.getHandleMargin();
        if (absBounds.right() + handleMargin.width > viewportRect.right()) {
            eastDiff = Integer.MAX_VALUE;
        } else if (absBounds.x - handleMargin.width < viewportRect.x) {
            westDiff = Integer.MAX_VALUE;
        }
        if (absBounds.bottom() + handleMargin.height > viewportRect.bottom()) {
            southDiff = Integer.MAX_VALUE;
        } else if (absBounds.y - handleMargin.height < viewportRect.y) {
            northDiff = Integer.MAX_VALUE;
        }
        double minLR = Math.min(eastDiff, westDiff);
        double minUD = Math.min(southDiff, northDiff);
        boolean bl = bUp = minUD < minLR;
        if (bUp) {
            if (northDiff < southDiff) {
                if (eastDiff < westDiff && (double)eastDiff < this.cursorPosition.getDistance(bounds.getTopLeft())) {
                    this.borderPoint.setLocation(bounds.x + bounds.width, this.cursorPosition.y);
                    this.side = 16;
                } else {
                    this.borderPoint.setLocation(bounds.x, bounds.y);
                    this.side = 1;
                }
            } else {
                this.borderPoint.setLocation(this.cursorPosition.x, bounds.y + bounds.height);
                this.side = 4;
            }
        } else if (westDiff < eastDiff) {
            this.borderPoint.setLocation(bounds.x, this.cursorPosition.y);
            this.side = 8;
        } else {
            this.borderPoint.setLocation(bounds.x + bounds.width, this.cursorPosition.y);
            this.side = 16;
        }
    }

    public int getBorderSide() {
        this.resetBorderPointAndSide();
        return this.side;
    }

    public void relocate(IFigure target) {
        Rectangle bounds = this.getReferenceFigureBounds();
        this.resetBorderPointAndSide();
        Point borderPointTranslated = this.borderPoint.getCopy();
        this.reference.translateToAbsolute((Translatable)bounds);
        target.translateToRelative((Translatable)bounds);
        this.reference.translateToAbsolute((Translatable)borderPointTranslated);
        target.translateToRelative((Translatable)borderPointTranslated);
        int width = target.getBounds().width;
        int halfWidth = width / 2;
        int height = target.getBounds().height;
        int halfHeight = height / 2;
        if (this.side == 8 || this.side == 16) {
            int halfTotalHeight = (height * this.handles.size() + HANDLE_SPACING * (this.handles.size() - 1)) / 2;
            if (borderPointTranslated.y - halfTotalHeight < bounds.getTop().y) {
                borderPointTranslated.y = bounds.getTop().y + halfTotalHeight;
            } else if (borderPointTranslated.y + halfTotalHeight > bounds.getBottom().y) {
                borderPointTranslated.y = bounds.getBottom().y - halfTotalHeight;
            }
        } else {
            int halfTotalWidth = (width * this.handles.size() + HANDLE_SPACING * (this.handles.size() - 1)) / 2;
            if (borderPointTranslated.x - halfTotalWidth < bounds.getLeft().x) {
                borderPointTranslated.x = bounds.getLeft().x + halfTotalWidth;
            } else if (borderPointTranslated.x + halfTotalWidth > bounds.getRight().x) {
                borderPointTranslated.x = bounds.getRight().x - halfTotalWidth;
            }
        }
        if (this.side == 8) {
            target.setLocation(borderPointTranslated.getTranslated(new Dimension(-(width + MARGIN), -halfHeight)));
        } else if (this.side == 16) {
            target.setLocation(borderPointTranslated.getTranslated(new Dimension(MARGIN, -halfHeight)));
        } else if (this.side == 4) {
            target.setLocation(borderPointTranslated.getTranslated(new Dimension(-halfWidth, MARGIN)));
        } else if (this.side == 1) {
            target.setLocation(borderPointTranslated.getTranslated(new Dimension(MARGIN, -height - MARGIN)));
        }
        int index = this.handles.indexOf(target);
        double centerOffset = (double)index - (double)this.handles.size() / 2.0 + 0.5;
        if (this.side == 8 || this.side == 16) {
            target.translate(0, (int)(centerOffset * (double)HANDLE_SPACING));
        } else {
            target.translate((int)(centerOffset * (double)HANDLE_SPACING), 0);
        }
    }

    private Rectangle getReferenceFigureBounds() {
        Rectangle bounds = this.reference instanceof HandleBounds ? ((HandleBounds)this.reference).getHandleBounds().getCopy() : this.reference.getBounds().getCopy();
        return bounds;
    }

    protected IFigure getReference() {
        return this.reference;
    }

    protected Point getCursorPosition() {
        return this.cursorPosition;
    }

    public boolean isEastWestSouth() {
        return this.bEastWestSouth;
    }

    public void setEastWestSouth(boolean eastWestSouth) {
        this.bEastWestSouth = eastWestSouth;
    }

    protected Dimension getHandleMargin() {
        return HANDLE_MARGIN;
    }
}

