/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GroupEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.ICanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.diagram.ui.internal.DiagramUIPlugin;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CanonicalConnectionEditPolicy
extends CanonicalEditPolicy {
    protected abstract List<EObject> getSemanticConnectionsList();

    protected abstract EObject getSourceElement(EObject var1);

    protected abstract EObject getTargetElement(EObject var1);

    @Override
    protected List<EObject> getSemanticChildrenList() {
        return Collections.emptyList();
    }

    @Override
    protected void refreshOnActivate() {
        List c = this.getHost().getChildren();
        int i = 0;
        while (i < c.size()) {
            ((EditPart)c.get(i)).activate();
            ++i;
        }
        this.refresh();
    }

    protected boolean canCreateConnection(EditPart sep, EditPart tep, EObject connection) {
        if (sep != null && sep.isActive() && tep != null && tep.isActive()) {
            View src = (View)sep.getAdapter(View.class);
            View tgt = (View)tep.getAdapter(View.class);
            if (src != null && tgt != null) {
                EditPart sourceParent = sep.getParent();
                while (sourceParent instanceof GroupEditPart) {
                    sourceParent = sourceParent.getParent();
                }
                EditPart targetParent = tep.getParent();
                while (targetParent instanceof GroupEditPart) {
                    targetParent = targetParent.getParent();
                }
                return sourceParent.getEditPolicy((Object)"Canonical") != null && targetParent.getEditPolicy((Object)"Canonical") != null;
            }
        }
        return false;
    }

    private EditPart getEditPartFor(EObject element, EObject context) {
        EditPartViewer viewer;
        if (element != null && !(element instanceof View) && (viewer = this.getHost().getViewer()) instanceof IDiagramGraphicalViewer) {
            EObject container;
            EditPart containerEP;
            List parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)element), INodeEditPart.class);
            if (parts.isEmpty() && (containerEP = this.getEditPartFor(container = element.eContainer(), null)) != null) {
                containerEP.refresh();
                parts = ((IDiagramGraphicalViewer)viewer).findEditPartsForElement(EMFCoreUtil.getProxyID((EObject)element), INodeEditPart.class);
            }
            return this.findEditPartForElement(element, context, parts);
        }
        return (EditPart)this.host().getViewer().getEditPartRegistry().get(element);
    }

    protected EditPart findEditPartForElement(EObject element, EObject context, List<EditPart> parts) {
        EditPart ancestor = this.getHost();
        while (ancestor != null) {
            EditPart ep = this.reachForEditPartWithAncestor(parts, ancestor);
            if (ep != null) {
                return ep;
            }
            ancestor = ancestor.getParent();
        }
        return null;
    }

    private EditPart reachForEditPartWithAncestor(List<EditPart> results, EditPart ancestor) {
        ListIterator<EditPart> li = results.listIterator();
        while (li.hasNext()) {
            EditPart ep = li.next();
            EditPart walker = ep.getParent();
            while (walker != null) {
                if (walker.equals(ancestor)) {
                    return ep;
                }
                walker = walker.getParent();
            }
        }
        return null;
    }

    @Override
    protected String getDefaultFactoryHint() {
        return "";
    }

    protected final Edge createConnectionView(EObject connection, int index) {
        EditPart tep;
        EditPart sep = this.getSourceEditPartFor(connection);
        if (!this.canCreateConnection(sep, tep = this.getTargetEditPartFor(connection), connection)) {
            return null;
        }
        View sView = (View)sep.getModel();
        View tView = (View)tep.getModel();
        Edge model = null;
        String factoryHint = this.getDefaultFactoryHint();
        CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(connection, factoryHint);
        CreateConnectionViewRequest ccr = this.getCreateConnectionViewRequest((IAdaptable)elementAdapter, this.getFactoryHint((IAdaptable)elementAdapter, factoryHint), index);
        ccr.setType("connection start");
        ccr.setSourceEditPart(sep);
        this.getCreateViewCommand((CreateRequest)ccr);
        ccr.setTargetEditPart(tep);
        ccr.setType("connection end");
        Command cmd = this.getCreateViewCommand((CreateRequest)ccr);
        if (cmd != null && cmd.canExecute()) {
            ArrayList<EObjectAdapter> viewAdapters = new ArrayList<EObjectAdapter>();
            viewAdapters.add(new EObjectAdapter((EObject)((View)this.host().getModel()).getDiagram()));
            viewAdapters.add(new EObjectAdapter((EObject)sView));
            viewAdapters.add(new EObjectAdapter((EObject)tView));
            SetViewMutabilityCommand.makeMutable(viewAdapters).execute();
            this.executeCommand(cmd);
            IAdaptable adapter = (IAdaptable)ccr.getNewObject();
            SetViewMutabilityCommand.makeMutable(adapter).execute();
            model = (Edge)adapter.getAdapter(Edge.class);
            if (model == null) {
                String eMsg = NLS.bind((String)DiagramUIMessages.CanonicalEditPolicy_create_view_failed_ERROR_, (Object)connection);
                IllegalStateException ise = new IllegalStateException(eMsg);
                Log.error((Plugin)DiagramUIPlugin.getInstance(), (int)4, (String)eMsg, (Throwable)ise);
                throw ise;
            }
        }
        return model;
    }

    protected EditPart getTargetEditPartFor(EObject connection) {
        EObject tel = this.getTargetElement(connection);
        EditPart tep = this.getEditPartFor(tel, connection);
        return tep;
    }

    protected EditPart getSourceEditPartFor(EObject connection) {
        EObject sel = this.getSourceElement(connection);
        EditPart sep = this.getEditPartFor(sel, connection);
        return sep;
    }

    @Override
    protected Command getCreateViewCommand(CreateRequest request) {
        if (request instanceof CreateConnectionViewRequest) {
            CreateConnectionViewRequest ccr = (CreateConnectionViewRequest)request;
            EditPart ep = ccr.getTargetEditPart() == null ? ccr.getSourceEditPart() : ccr.getTargetEditPart();
            return ep.getCommand((Request)request);
        }
        return super.getCreateViewCommand(request);
    }

    protected CreateViewRequest getCreateViewRequest(CreateViewRequest.ViewDescriptor descriptor) {
        return this.getCreateViewRequest(Collections.singletonList(descriptor));
    }

    @Override
    protected CreateViewRequest getCreateViewRequest(List<CreateViewRequest.ViewDescriptor> descriptors) {
        CreateViewRequest cvr = super.getCreateViewRequest(descriptors);
        Point loc = ICanonicalShapeCompartmentLayout.UNDEFINED.getLocation();
        cvr.setLocation(loc);
        return cvr;
    }

    private CreateConnectionViewRequest getCreateConnectionViewRequest(IAdaptable elementAdapter, String hint, int index) {
        return new CreateConnectionViewRequest(this.getConnectionViewDescriptor(elementAdapter, hint, index));
    }

    private CreateConnectionViewRequest.ConnectionViewDescriptor getConnectionViewDescriptor(IAdaptable elementAdapter, String hint, int index) {
        return new CreateConnectionViewRequest.ConnectionViewDescriptor(elementAdapter, hint, index, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
    }

    protected List<IAdaptable> refreshSemanticConnections() {
        Collection<Edge> viewChildren = this.getConnectionViews();
        HashSet<EObject> semanticChildren = new HashSet<EObject>();
        semanticChildren.addAll(this.getSemanticConnectionsList());
        List<View> orphaned = this.cleanCanonicalSemanticChildren(viewChildren, semanticChildren);
        this.deleteViews(orphaned.iterator());
        ArrayList<IAdaptable> viewDescriptors = new ArrayList<IAdaptable>();
        for (EObject semanticChild : semanticChildren) {
            Edge viewChild = this.createConnectionView(semanticChild, -1);
            if (viewChild == null) continue;
            viewDescriptors.add((IAdaptable)new EObjectAdapter((EObject)viewChild));
        }
        this.makeViewsMutable(viewDescriptors);
        HashSet<EditPart> ends = new HashSet<EditPart>();
        ListIterator li = viewDescriptors.listIterator();
        while (li.hasNext()) {
            EditPart targetEP;
            IAdaptable adaptable = (IAdaptable)li.next();
            Edge edge = (Edge)adaptable.getAdapter(Edge.class);
            EditPart sourceEP = this.getEditPartFor((EObject)edge.getSource(), (EObject)edge);
            if (sourceEP != null) {
                ends.add(sourceEP);
            }
            if ((targetEP = this.getEditPartFor((EObject)edge.getTarget(), (EObject)edge)) == null) continue;
            ends.add(targetEP);
        }
        for (EditPart end : ends) {
            end.refresh();
        }
        return viewDescriptors;
    }

    @Override
    protected boolean isOrphaned(Collection<EObject> semanticChildren, View view) {
        EObject element = view.getElement();
        if (semanticChildren.contains(element)) {
            Edge edge;
            return view instanceof Edge && ((edge = (Edge)view).getSource() == null || edge.getSource().getElement() != this.getSourceElement(element) || edge.getTarget() == null || edge.getTarget().getElement() != this.getTargetElement(element));
        }
        return true;
    }

    @Override
    protected void refreshSemantic() {
        List<IAdaptable> createdViews = super.refreshSemanticChildren();
        List<IAdaptable> createdConnectionViews = this.refreshSemanticConnections();
        DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
        if (!createdViews.isEmpty() && layoutCmd.canExecute()) {
            this.executeCommand(new ICommandProxy((ICommand)layoutCmd));
        }
        ArrayList<IAdaptable> allViews = new ArrayList<IAdaptable>(createdConnectionViews.size() + createdViews.size());
        allViews.addAll(createdViews);
        allViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(allViews);
    }

    @Override
    protected boolean shouldDeleteView(View view) {
        return ViewUtil.resolveSemanticElement((View)view) == null;
    }

    @Override
    protected void postProcessRefreshSemantic(List<IAdaptable> viewDescriptors) {
        this.makeViewsMutable(viewDescriptors);
        super.postProcessRefreshSemantic(viewDescriptors);
    }

    protected Collection<Edge> getConnectionViews() {
        List<View> children = this.getViewChildren();
        HashSet<Edge> connections = new HashSet<Edge>();
        if (this.getHost() instanceof IGraphicalEditPart) {
            IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
            this.getConnectionViews(connections, gep.getNotationView(), children);
        }
        return connections;
    }

    private void getConnectionViews(Set<Edge> connections, View view, Collection<View> viewChildren) {
        IGraphicalEditPart gep = (IGraphicalEditPart)this.getHost();
        View hostView = gep.getNotationView();
        if (hostView != view && !this.shouldCheckForConnections(view, viewChildren)) {
            return;
        }
        for (Edge sourceEdge : ViewUtil.getSourceConnections((View)view)) {
            if (!this.shouldIncludeConnection(sourceEdge, viewChildren)) continue;
            connections.add(sourceEdge);
        }
        for (Edge targetEdge : ViewUtil.getTargetConnections((View)view)) {
            if (!this.shouldIncludeConnection(targetEdge, viewChildren)) continue;
            connections.add(targetEdge);
        }
        for (View viewChild : view.getChildren()) {
            if (!(viewChild instanceof Node)) continue;
            this.getConnectionViews(connections, viewChild, viewChildren);
        }
    }

    protected boolean shouldCheckForConnections(View view, Collection<View> viewChildren) {
        return view != null && (viewChildren.contains(view) || viewChildren.contains(view.eContainer()));
    }

    protected boolean shouldIncludeConnection(Edge connection, Collection<View> children) {
        return this.shouldCheckForConnections(connection.getSource(), children) || this.shouldCheckForConnections(connection.getTarget(), children);
    }

    public Command getCommand(Request request) {
        if (this.understandsRequest(request) && this.isEnabled() && request instanceof DropObjectsRequest) {
            return this.getDropCommand((DropObjectsRequest)request);
        }
        return super.getCommand(request);
    }

    protected Command getDropCommand(DropObjectsRequest request) {
        boolean enabled = this.isEnabled();
        List<EObject> children = this.getSemanticChildrenList();
        for (Object dropElement : request.getObjects()) {
            if (this.allowDropElement(dropElement)) continue;
            if (dropElement instanceof EObject && this.preventDropElement(dropElement)) {
                return UnexecutableCommand.INSTANCE;
            }
            boolean containsElement = children.contains(dropElement);
            if (!enabled || !containsElement && !this.preventDropElement(dropElement)) continue;
            return UnexecutableCommand.INSTANCE;
        }
        return null;
    }

    protected boolean preventDropElement(Object dropElement) {
        return dropElement instanceof EObject ? !PackageUtil.canContain((EClass)this.getSemanticHost().eClass(), (EClass)((EObject)dropElement).eClass(), (boolean)false) : false;
    }

    protected boolean allowDropElement(Object dropElement) {
        return dropElement instanceof Diagram;
    }

    public boolean understandsRequest(Request req) {
        return "drop_objects".equals(req.getType()) || req instanceof DropObjectsRequest || "create child".equals(req.getType()) ? true : super.understandsRequest(req);
    }

    @Override
    public boolean canCreate(EObject eObject) {
        return super.canCreate(eObject) || this.getSemanticConnectionsList().contains(eObject);
    }
}

