/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.editpolicies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.LED;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ComponentEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;

public class LEDEditPolicy
extends ComponentEditPolicy {
    private static final String INCREMENT_REQUEST = "Increment";
    private static final String DECREMENT_REQUEST = "Decrement";

    public Command getCommand(Request request) {
        if (INCREMENT_REQUEST.equals(request.getType())) {
            return this.getIncrementDecrementCommand(true);
        }
        if (DECREMENT_REQUEST.equals(request.getType())) {
            return this.getIncrementDecrementCommand(false);
        }
        return super.getCommand(request);
    }

    protected Command getIncrementDecrementCommand(boolean type) {
        IncrementDecrementCommand command = new IncrementDecrementCommand(((IGraphicalEditPart)this.getHost()).getEditingDomain(), type);
        command.setChild(((View)this.getHost().getModel()).getElement());
        return new ICommandProxy((ICommand)command);
    }

    public EditPart getTargetEditPart(Request request) {
        if (INCREMENT_REQUEST.equals(request.getType()) || DECREMENT_REQUEST.equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    static class IncrementDecrementCommand
    extends AbstractTransactionalCommand {
        boolean isIncrement = true;
        LED child = null;

        public IncrementDecrementCommand(TransactionalEditingDomain editingDomain, boolean increment) {
            super(editingDomain, "Logic Value Change", null);
            this.isIncrement = increment;
        }

        public void setChild(EObject child) {
            this.child = (LED)child;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            int value = this.child.getValue();
            if (this.isIncrement) {
                if (value == 15) {
                    value = -1;
                }
                this.child.setValue(value + 1);
            } else {
                if (value == 0) {
                    value = 16;
                }
                this.child.setValue(value - 1);
            }
            return CommandResult.newOKCommandResult();
        }
    }
}

