/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.diagram.logic.internal.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.LogicDiagramDebugOptions;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.LogicDiagramPlugin;
import org.eclipse.gmf.examples.runtime.diagram.logic.internal.l10n.ExampleDiagramLogicMessages;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.Model;
import org.eclipse.gmf.examples.runtime.diagram.logic.semantic.SemanticFactory;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.util.IDEEditorUtil;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class LogicEditorUtil
extends IDEEditorUtil {
    public static final IFile createAndOpenDiagram(DiagramFileCreator diagramFileCreator, IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean openEditor, boolean saveDiagram, String semanticResourcePath) {
        IFile newFile = LogicEditorUtil.createNewDiagramFile(diagramFileCreator, containerPath, fileName, initialContents, kind, dWindow.getShell(), progressMonitor, semanticResourcePath);
        if (newFile != null && openEditor) {
            IDEEditorUtil.openDiagram((IFile)newFile, (IWorkbenchWindow)dWindow, (boolean)saveDiagram, (IProgressMonitor)progressMonitor);
        }
        return newFile;
    }

    public static final IFile createNewDiagramFile(DiagramFileCreator diagramFileCreator, IPath containerFullPath, String fileName, InputStream initialContents, final String kind, Shell shell, final IProgressMonitor progressMonitor, final String semanticResourcePath) {
        final IFile newDiagramFile = diagramFileCreator.createNewFile(containerFullPath, fileName, initialContents, shell, new IRunnableContext(){

            public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
                runnable.run(progressMonitor);
            }
        });
        TransactionalEditingDomain domain = GMFEditingDomainFactory.getInstance().createEditingDomain();
        final ResourceSet resourceSet = domain.getResourceSet();
        AbstractEMFOperation op = new AbstractEMFOperation(domain, ExampleDiagramLogicMessages.LogicWizardPage_Title){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                Diagram view;
                IFile semanticFile = null;
                boolean semanticFileIsNew = false;
                if (semanticResourcePath != null && semanticResourcePath.length() > 0) {
                    try {
                        semanticFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(semanticResourcePath));
                    }
                    catch (Exception exception) {}
                    if (!semanticFile.exists()) {
                        semanticFileIsNew = true;
                        try {
                            semanticFile.create((InputStream)new ByteArrayInputStream(new byte[0]), false, progressMonitor);
                        }
                        catch (CoreException e) {
                            Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)4, (String)e.getMessage(), (Throwable)e);
                            return null;
                        }
                    }
                }
                try {
                    newDiagramFile.refreshLocal(0, null);
                    if (semanticFile != null) {
                        semanticFile.refreshLocal(0, null);
                    }
                }
                catch (CoreException e) {
                    Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, LogicEditorUtil.class, (String)"createNewDiagramFile", (Throwable)e);
                }
                Model semanticModel = null;
                if (semanticFileIsNew) {
                    semanticModel = SemanticFactory.eINSTANCE.createModel();
                    Resource semanticResource = resourceSet.createResource(URI.createPlatformResourceURI((String)semanticResourcePath, (boolean)true));
                    semanticResource.getContents().add((Object)semanticModel);
                } else if (semanticFile != null) {
                    semanticModel = (Model)resourceSet.getResource(URI.createPlatformResourceURI((String)semanticResourcePath, (boolean)true), true).getContents().get(0);
                }
                String completeFileName = newDiagramFile.getLocation().toOSString();
                Resource notationModel = resourceSet.createResource(URI.createFileURI((String)completeFileName));
                if (semanticModel == null) {
                    semanticModel = SemanticFactory.eINSTANCE.createModel();
                    notationModel.getContents().add((Object)semanticModel);
                }
                if ((view = ViewService.createDiagram((EObject)semanticModel, (String)kind, (PreferencesHint)new PreferencesHint("LogicEditor"))) != null) {
                    notationModel.getContents().add(0, (Object)view);
                    view.getDiagram().setName(newDiagramFile.getName());
                }
                try {
                    notationModel.save(Collections.EMPTY_MAP);
                    semanticModel.eResource().save(Collections.EMPTY_MAP);
                }
                catch (IOException e) {
                    Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, LogicEditorUtil.class, (String)"createNewDiagramFile", (Throwable)e);
                    Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)9, (String)e.getLocalizedMessage());
                }
                return Status.OK_STATUS;
            }
        };
        try {
            op.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            Trace.catching((Plugin)LogicDiagramPlugin.getInstance(), (String)LogicDiagramDebugOptions.EXCEPTIONS_CATCHING, LogicEditorUtil.class, (String)"createNewDiagramFile", (Throwable)e);
            Log.error((Plugin)LogicDiagramPlugin.getInstance(), (int)9, (String)e.getLocalizedMessage());
        }
        return newDiagramFile;
    }
}

