/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.io.IOException;
import org.apache.batik.transcoder.TranscoderException;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiBrush;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.GdiPen;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IEmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IRenderToPath;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.IWmf2SvgConverter;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.Record;

public class RoundRect
implements IEmf2SvgConverter,
IWmf2SvgConverter,
IRenderToPath {
    private static final int EMF_RECT_OFFSET = 0;
    private static final int EMF_CORNER_OFFSET = 16;
    private static final int WMF_ELBOW_HEIGHT_OFFSET = 0;
    private static final int WMF_ELBOW_WIDTH_OFFSET = 2;
    private static final int WMF_BOTTOM_OFFSET = 4;
    private static final int WMF_RIGHT_OFFSET = 6;
    private static final int WMF_TOP_OFFSET = 8;
    private static final int WMF_LEFT_OFFSET = 10;
    private Rectangle m_rect = null;
    private Dimension m_corner = null;

    public void readWMFRecord(Record rec) throws IOException {
        short elbowHeight = rec.getShortAt(0);
        short elbowWidth = rec.getShortAt(2);
        short bottom = rec.getShortAt(4);
        short right = rec.getShortAt(6);
        short top = rec.getShortAt(8);
        short left = rec.getShortAt(10);
        this.m_rect = new Rectangle(left, top, right - left, bottom - top);
        this.m_corner = new Dimension(elbowWidth, elbowHeight);
    }

    public void readEMFRecord(Record rec) throws IOException {
        this.m_rect = rec.getRectangleLAt(0);
        this.m_corner = rec.getDimensionLAt(16);
    }

    public void render(Graphics2D g, DeviceContext context) throws TranscoderException {
        GdiPen pen;
        Shape s = this.getShape(context);
        GdiBrush brush = context.getCurBrush();
        if (brush != null) {
            brush.fill(s, g, context);
        }
        if ((pen = context.getCurPen()) != null) {
            pen.apply(g, context);
            g.draw(s);
        }
    }

    public void render(DeviceContext context) throws TranscoderException {
        Shape s = this.getShape(context);
        context.getGdiPath().appendFigure(s);
    }

    private Shape getShape(DeviceContext context) {
        int x = context.convertXToSVGLogicalUnits(this.m_rect.x);
        int y = context.convertYToSVGLogicalUnits(this.m_rect.y);
        int w = context.scaleX(this.m_rect.width);
        int h = context.scaleY(this.m_rect.height);
        int cornerWidth = context.scaleX(this.m_corner.width);
        int cornerHeight = context.scaleY(this.m_corner.height);
        return new RoundRectangle2D.Double(x, y, w, h, cornerWidth, cornerHeight);
    }
}

