/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.geometry;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;

public class PrecisionPointList
extends PointList {
    private double[] points = new double[0];
    private PrecisionRectangle bounds;
    private int size = 0;
    static final long serialVersionUID = 1L;

    public PrecisionPointList() {
    }

    public PrecisionPointList(double[] points) {
        this.points = points;
        this.size = points.length / 2;
    }

    public PrecisionPointList(int size) {
        this.points = new double[size * 2];
    }

    public PrecisionPointList(PointList pointList) {
        this();
        this.addAll(pointList);
    }

    public void addAll(PrecisionPointList source) {
        this.ensureCapacity(this.size + source.size);
        System.arraycopy(source.points, 0, this.points, this.size * 2, source.size * 2);
        this.size += source.size;
    }

    public void addAll(PointList source) {
        if (source instanceof PrecisionPointList) {
            this.addAll((PrecisionPointList)source);
        }
        this.ensureCapacity(this.size + source.size());
        int i = 0;
        while (i < source.size()) {
            this.addPoint(source.getPoint(i));
            ++i;
        }
    }

    public void addPoint(Point p) {
        if (p instanceof PrecisionPoint) {
            PrecisionPoint precisionPt = (PrecisionPoint)p;
            this.addPrecisionPoint(precisionPt.preciseX, precisionPt.preciseY);
        } else {
            this.addPrecisionPoint(p.preciseX(), p.preciseY());
        }
    }

    public void addPrecisionPoint(double x, double y) {
        this.bounds = null;
        int index = this.size * 2;
        this.ensureCapacity(this.size + 1);
        this.points[index] = x;
        this.points[index + 1] = y;
        ++this.size;
    }

    private void ensureCapacity(int newSize) {
        if (this.points.length < (newSize *= 2)) {
            double[] old = this.points;
            this.points = new double[Math.max(newSize, this.size * 4)];
            System.arraycopy(old, 0, this.points, 0, this.size * 2);
        }
    }

    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        this.bounds = new PrecisionRectangle();
        if (this.size > 0) {
            this.bounds.setLocation(this.getPoint(0));
            int i = 0;
            while (i < this.size) {
                PrecisionPoint p = (PrecisionPoint)this.getPoint(i);
                this.bounds.union((Point)p);
                ++i;
            }
        }
        return this.bounds;
    }

    public PrecisionPointList getCopy() {
        PrecisionPointList result = new PrecisionPointList(this.size);
        System.arraycopy(this.points, 0, result.points, 0, this.size * 2);
        result.size = this.size;
        result.bounds = null;
        return result;
    }

    public Point getLastPoint() {
        return this.getPoint(this.size - 1);
    }

    public Point getMidpoint() {
        if (this.size() % 2 == 0) {
            return this.getPoint(this.size() / 2 - 1).getTranslated(this.getPoint(this.size() / 2)).scale(0.5);
        }
        return this.getPoint(this.size() / 2);
    }

    public Point getPoint(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        return new PrecisionPoint(this.points[index *= 2], this.points[index + 1]);
    }

    public Point getPoint(Point p, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        index *= 2;
        if (p instanceof PrecisionPoint) {
            PrecisionPoint preciseP = (PrecisionPoint)p;
            preciseP.preciseX = this.points[index];
            preciseP.preciseY = this.points[index + 1];
            preciseP.updateInts();
        } else {
            p.x = (int)Math.floor(this.points[index] + 1.0E-9);
            p.y = (int)Math.floor(this.points[index + 1] + 1.0E-9);
        }
        return p;
    }

    public void insertPoint(Point p, int index) {
        if (this.bounds != null && !this.bounds.contains(p)) {
            this.bounds = null;
        }
        if (index > this.size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        int length = this.points.length;
        double[] old = this.points;
        this.points = new double[length + 2];
        System.arraycopy(old, 0, this.points, 0, index *= 2);
        System.arraycopy(old, index, this.points, index + 2, length - index);
        if (p instanceof PrecisionPoint) {
            PrecisionPoint precisionPt = (PrecisionPoint)p;
            this.points[index] = precisionPt.preciseX;
            this.points[index + 1] = precisionPt.preciseY;
        } else {
            this.points[index] = p.x;
            this.points[index + 1] = p.y;
        }
        ++this.size;
    }

    public void performScale(double factor) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = this.points[i] * factor;
            ++i;
        }
        this.bounds = null;
    }

    public void performTranslate(int dx, int dy) {
        int i = 0;
        while (i < this.size * 2) {
            int n = i;
            this.points[n] = this.points[n] + (double)dx;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + (double)dy;
            i += 2;
        }
        if (this.bounds != null) {
            this.bounds.translate(dx, dy);
        }
    }

    public void removeAllPoints() {
        this.bounds = null;
        this.size = 0;
    }

    public Point removePoint(int index) {
        this.bounds = null;
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        PrecisionPoint pt = new PrecisionPoint(this.points[index *= 2], this.points[index + 1]);
        if (index != this.size * 2 - 2) {
            System.arraycopy(this.points, index + 2, this.points, index, this.size * 2 - index - 2);
        }
        --this.size;
        return pt;
    }

    public void reverse() {
        int i = 0;
        int j = this.size * 2 - 2;
        while (i < this.size) {
            double temp = this.points[i];
            this.points[i] = this.points[j];
            this.points[j] = temp;
            temp = this.points[i + 1];
            this.points[i + 1] = this.points[j + 1];
            this.points[j + 1] = temp;
            i += 2;
            j -= 2;
        }
    }

    public void setPoint(Point pt, int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (this.bounds != null && !this.bounds.contains(pt)) {
            this.bounds = null;
        }
        if (pt instanceof PrecisionPoint) {
            PrecisionPoint precisionPt = (PrecisionPoint)pt;
            this.points[index * 2] = precisionPt.preciseX;
            this.points[index * 2 + 1] = precisionPt.preciseY;
        } else {
            this.points[index * 2] = pt.x;
            this.points[index * 2 + 1] = pt.y;
        }
    }

    public void setSize(int newSize) {
        if (this.points.length > newSize * 2) {
            this.size = newSize;
            return;
        }
        double[] newArray = new double[newSize * 2];
        System.arraycopy(this.points, 0, newArray, 0, this.points.length);
        this.points = newArray;
        this.size = newSize;
    }

    public int size() {
        return this.size;
    }

    public double[] toDoubleArray() {
        if (this.points.length != this.size * 2) {
            double[] old = this.points;
            this.points = new double[this.size * 2];
            System.arraycopy(old, 0, this.points, 0, this.size * 2);
        }
        return this.points;
    }

    public int[] toIntArray() {
        int[] intArray = new int[this.size * 2];
        int i = 0;
        while (i < this.size()) {
            Point p = this.getPoint(i);
            int idx = 2 * i;
            intArray[idx] = p.x;
            intArray[idx + 1] = p.y;
            ++i;
        }
        return intArray;
    }

    public void translate(int x, int y) {
        if (x == 0 && y == 0) {
            return;
        }
        if (this.bounds != null) {
            this.bounds.translate(x, y);
        }
        int i = 0;
        while (i < this.size * 2) {
            int n = i;
            this.points[n] = this.points[n] + (double)x;
            int n2 = i + 1;
            this.points[n2] = this.points[n2] + (double)y;
            i += 2;
        }
    }

    public void transpose() {
        if (this.bounds != null) {
            this.bounds.transpose();
        }
        int i = 0;
        while (i < this.size * 2) {
            double temp = this.points[i];
            this.points[i] = this.points[i + 1];
            this.points[i + 1] = temp;
            i += 2;
        }
    }
}

