/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class GMFGenNewFileCreationPage
extends WizardNewFileCreationPage {
    static final String EXT_GMFGEN = "gmfgen";
    private ResourceGroupEmulator resourceGroupEmulator;

    public GMFGenNewFileCreationPage(String pageId, IStructuredSelection selection) {
        super(pageId, selection);
    }

    public void createControl(Composite parent) {
        this.resourceGroupEmulator = new ResourceGroupEmulator();
        super.createControl(parent);
        this.validateFileExists();
    }

    protected boolean validatePage() {
        if (this.emulateValidate()) {
            String enteredExt = new Path(this.getFileName()).getFileExtension();
            if (enteredExt == null || !enteredExt.equals(EXT_GMFGEN)) {
                String pattern = Messages.GMFGenNewFileCreationPage_e_filename;
                this.setErrorMessage(MessageFormat.format(pattern, EXT_GMFGEN));
                return false;
            }
            this.validateFileExists();
            return true;
        }
        return false;
    }

    private void validateFileExists() {
        IPath resourcePath = this.getContainerFullPath().append(this.getFileName());
        if (this.isFileExists(resourcePath)) {
            this.setMessage(Messages.ResourceGroup_nameExists, 2);
        }
    }

    public IFile getModelFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }

    private boolean emulateValidate() {
        boolean valid = true;
        if (!this.resourceGroupEmulator.validateControls()) {
            if (this.resourceGroupEmulator.getProblemType() == 1 || this.resourceGroupEmulator.getProblemType() == 5) {
                this.setMessage(this.resourceGroupEmulator.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this.resourceGroupEmulator.getProblemMessage());
            }
            valid = false;
        }
        String resourceName = this.getFileName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    boolean isFileExists(IPath resourcePath) {
        if (resourcePath == null) {
            return false;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        return workspace.getRoot().getFolder(resourcePath).exists() || workspace.getRoot().getFile(resourcePath).exists();
    }

    private class ResourceGroupEmulator {
        static final int PROBLEM_NONE = 0;
        static final int PROBLEM_RESOURCE_EMPTY = 1;
        static final int PROBLEM_RESOURCE_EXIST = 2;
        static final int PROBLEM_PATH_INVALID = 4;
        static final int PROBLEM_CONTAINER_EMPTY = 5;
        static final int PROBLEM_PROJECT_DOES_NOT_EXIST = 6;
        static final int PROBLEM_NAME_INVALID = 7;
        static final int PROBLEM_PATH_OCCUPIED = 8;
        private boolean allowExistingResources = true;
        private String problemMessage = "";
        private int problemType = 0;

        ResourceGroupEmulator() {
        }

        boolean validateControls() {
            try {
                GMFGenNewFileCreationPage.this.getFileName();
            }
            catch (Exception exception) {
                return false;
            }
            this.problemType = 0;
            this.problemMessage = "";
            if (!this.validateContainer() || !this.validateResourceName()) {
                return false;
            }
            IPath path = GMFGenNewFileCreationPage.this.getContainerFullPath().append(GMFGenNewFileCreationPage.this.getFileName());
            return this.validateFullResourcePath(path);
        }

        private boolean validateContainer() {
            IPath path = GMFGenNewFileCreationPage.this.getContainerFullPath();
            if (path == null) {
                this.problemType = 5;
                this.problemMessage = Messages.ResourceGroup_folderEmpty;
                return false;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String projectName = path.segment(0);
            if (projectName == null || !workspace.getRoot().getProject(projectName).exists()) {
                this.problemType = 6;
                this.problemMessage = Messages.ResourceGroup_noProject;
                return false;
            }
            IWorkspaceRoot root = workspace.getRoot();
            while (path.segmentCount() > 1) {
                if (root.getFile(path).exists()) {
                    this.problemType = 8;
                    this.problemMessage = NLS.bind((String)Messages.ResourceGroup_pathOccupied, (Object)path.makeRelative());
                    return false;
                }
                path = path.removeLastSegments(1);
            }
            return true;
        }

        private boolean validateResourceName() {
            String resourceName = GMFGenNewFileCreationPage.this.getFileName();
            if (resourceName.length() == 0) {
                this.problemType = 1;
                this.problemMessage = NLS.bind((String)Messages.ResourceGroup_emptyName, (Object)Messages.WizardNewFileCreationPage_file);
                return false;
            }
            if (!Path.ROOT.isValidPath(resourceName)) {
                this.problemType = 7;
                this.problemMessage = NLS.bind((String)Messages.ResourceGroup_invalidFilename, (Object)resourceName);
                return false;
            }
            return true;
        }

        private boolean validateFullResourcePath(IPath resourcePath) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus result = workspace.validatePath(resourcePath.toString(), 2);
            if (!result.isOK()) {
                this.problemType = 4;
                this.problemMessage = result.getMessage();
                return false;
            }
            if (!this.allowExistingResources && GMFGenNewFileCreationPage.this.isFileExists(resourcePath)) {
                this.problemType = 2;
                this.problemMessage = Messages.ResourceGroup_nameExists;
                return false;
            }
            return true;
        }

        String getProblemMessage() {
            return this.problemMessage;
        }

        int getProblemType() {
            return this.problemType;
        }
    }
}

