/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSource;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelSourceImpl;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.DomainModelViewerFactory;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.StructureBuilder;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DefinitionPage
extends WizardPage {
    private final StructureBuilder structureBuilder;
    private final DomainModelSource domainModelSource;
    private DomainModelSourceImpl currentModelSource;
    private TreeViewer viewer;
    private Button deselectAllButton;
    private Button recognizeButton;

    public DefinitionPage(String pageId, StructureBuilder structureBuilder, DomainModelSource domainModelSource) {
        super(pageId);
        this.structureBuilder = structureBuilder;
        this.domainModelSource = domainModelSource;
    }

    protected GridData createFillBothGridData(int span) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    protected GridData createFillHorzGridData(int span) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl((Control)this.createDomainModelGroup(parent));
    }

    private Composite createDomainModelGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        Label domainModelElementsLabel = new Label(plate, 0);
        domainModelElementsLabel.setText(Messages.DefinitionPageElementsToProcess);
        domainModelElementsLabel.setLayoutData((Object)this.createFillHorzGridData(2));
        Composite viewerPlate = this.createViewerGroup(plate);
        viewerPlate.setLayoutData((Object)this.createFillBothGridData(2));
        plate.setLayoutData((Object)this.createFillBothGridData(1));
        return plate;
    }

    private Composite createViewerGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        this.viewer = this.createViewer(plate);
        this.viewer.getControl().setLayoutData((Object)this.createFillBothGridData(1));
        Composite buttonsPlate = this.createDomainModelButtons(plate);
        buttonsPlate.setLayoutData((Object)new GridData(1040));
        return plate;
    }

    private Composite createDomainModelButtons(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        this.deselectAllButton = new Button(plate, 8);
        this.deselectAllButton.setLayoutData((Object)this.createFillHorzGridData(1));
        this.deselectAllButton.setText(Messages.DefinitionPageDeselectAll);
        this.deselectAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                this.deselectChildren(DefinitionPage.this.getModel());
                DefinitionPage.this.viewer.refresh(true);
            }

            private void deselectChildren(ResolvedItem item) {
                for (ResolvedItem child : item.getChildren()) {
                    child.setResolution(null);
                    this.deselectChildren(child);
                }
            }
        });
        this.recognizeButton = new Button(plate, 8);
        this.recognizeButton.setLayoutData((Object)this.createFillHorzGridData(1));
        this.recognizeButton.setText(Messages.DefinitionPageDefaults);
        this.recognizeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EPackage contents = DefinitionPage.this.currentModelSource.getContents();
                DefinitionPage.this.viewer.setInput(contents == null ? null : DefinitionPage.this.structureBuilder.process(DefinitionPage.this.currentModelSource));
                DefinitionPage.this.viewer.expandAll();
                if (contents != null) {
                    DefinitionPage.this.setPageComplete(DefinitionPage.this.validatePage());
                } else {
                    DefinitionPage.this.setPageComplete(true);
                }
            }
        });
        return plate;
    }

    protected TreeViewer createViewer(Composite parent) {
        final Tree tree = new Tree(parent, 68356);
        TableLayout layout = new TableLayout(){
            private boolean firstTime = true;

            public void layout(Composite c, boolean flush) {
                super.layout(c, flush);
                if (!this.firstTime) {
                    return;
                }
                int cawidth = c.getClientArea().width;
                if (cawidth <= 1) {
                    return;
                }
                TreeColumn elementColumn = ((Tree)c).getColumn(0);
                int vsbWidth = tree.getVerticalBar().getSize().x + 9;
                int width = elementColumn.getWidth() - vsbWidth;
                if (width < 0) {
                    width = 0;
                }
                elementColumn.setWidth(width);
                this.firstTime = false;
            }
        };
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        TreeColumn elementColumn = new TreeColumn(tree, 16384);
        elementColumn.setText(Messages.DefinitionPageElement);
        elementColumn.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 32, true));
        this.addResolutionColumn(tree, ResolvedItem.Resolution.NODE, "/icons/cview16/node.gif");
        this.addResolutionColumn(tree, ResolvedItem.Resolution.LINK, "/icons/cview16/link.gif");
        if (this.structureBuilder.isWithLabels()) {
            this.addResolutionColumn(tree, ResolvedItem.Resolution.LABEL, "/icons/cview16/label.gif");
        }
        this.viewer = DomainModelViewerFactory.createViewer(tree, this.structureBuilder.isWithLabels());
        return this.viewer;
    }

    protected TreeColumn addResolutionColumn(Tree tree, ResolvedItem.Resolution resolution, String iconId) {
        TreeColumn column = new TreeColumn(tree, 0x1000000);
        column.setImage(Plugin.getDefault().getImageRegistry().get(iconId));
        column.setResizable(false);
        ((TableLayout)tree.getLayout()).addColumnData((ColumnLayoutData)new ColumnPixelData(18, false, true));
        return column;
    }

    protected boolean validatePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            return;
        }
        EPackage contents = this.domainModelSource.getContents();
        if (this.currentModelSource != null && this.currentModelSource.like(this.domainModelSource)) {
            return;
        }
        this.currentModelSource = this.createDomainModelSource(contents, this.domainModelSource.getDiagramElement());
        assert (this.currentModelSource != null);
        this.viewer.setInput(contents == null ? null : this.structureBuilder.process(this.currentModelSource));
        this.viewer.expandAll();
        this.viewer.getControl().pack();
        if (contents != null) {
            this.setPageComplete(this.validatePage());
        } else {
            this.setPageComplete(true);
        }
        ((Composite)this.getControl()).layout(true, true);
    }

    protected DomainModelSourceImpl createDomainModelSource(EPackage contents, EClass diagramElement) {
        return new DomainModelSourceImpl(contents, diagramElement);
    }

    public ResolvedItem getModel() {
        return (ResolvedItem)this.viewer.getInput();
    }
}

