/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.internal.figures;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.jface.util.Assert;

public class FeedbackConnection
extends PolylineConnectionEx {
    private Connection master = null;
    private List masterConstraint = null;

    public FeedbackConnection() {
        this.setLineStyle(4);
    }

    public FeedbackConnection(Connection master) {
        this();
        this.master = master;
        PointList pts = PointListUtilities.copyPoints(master.getPoints());
        this.setPoints(pts);
        this.setSourceAnchor(master.getSourceAnchor());
        this.setTargetAnchor(master.getTargetAnchor());
        this.setForegroundColor(master.getForegroundColor());
        if (master instanceof PolylineConnectionEx) {
            this.setSmoothness(((PolylineConnectionEx)master).getSmoothness());
            this.setRoutingStyles(((PolylineConnectionEx)master).isClosestDistanceRouting(), ((PolylineConnectionEx)master).isAvoidObstacleRouting());
        }
        ConnectionRouter masterRouter = master.getConnectionRouter();
        this.masterConstraint = (List)master.getRoutingConstraint();
        ArrayList<AbsoluteBendpoint> newConstraint = new ArrayList<AbsoluteBendpoint>(this.masterConstraint.size());
        this.setConnectionRouter(masterRouter);
        masterRouter.remove(master);
        int i = 0;
        while (i < this.masterConstraint.size()) {
            Bendpoint bp = (Bendpoint)this.masterConstraint.get(i);
            newConstraint.add(new AbsoluteBendpoint(bp.getLocation()));
            ++i;
        }
        Assert.isTrue((newConstraint.size() >= 2 && newConstraint.size() == this.masterConstraint.size() ? 1 : 0) != 0);
        this.setRoutingConstraint(newConstraint);
    }

    public void dispose() {
        if (this.getConnectionRouter() != null) {
            this.getConnectionRouter().remove((Connection)this);
        }
        this.setRoutingConstraint(null);
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener((AnchorListener)this);
        }
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener((AnchorListener)this);
        }
        if (this.master != null && this.masterConstraint != null) {
            this.master.setRoutingConstraint((Object)this.masterConstraint);
        }
    }
}

